/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;

public class Colour
extends Color {
    static Set instances = new HashSet();
    private static Colour lastInstance = null;
    public static boolean disableEquals = false;

    public Colour(int r, int g, int b, int a) {
        super(r, g, b, a);
        instances.add(this);
    }

    public static Colour getColour(Color c, int a) {
        return Colour.getColour(c.getRed(), c.getGreen(), c.getBlue(), a);
    }

    public static Colour getColour(Color c) {
        if (c instanceof Colour) {
            return (Colour)c;
        }
        return Colour.getColour(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public static Colour getColour(int rgb, boolean hasAlpha) {
        return Colour.getColour(new Color(rgb, hasAlpha));
    }

    public static Colour getColour(int r, int g, int b, int a) {
        lastInstance = Colour.retrieveInstance(r, g, b, a);
        if (lastInstance == null) {
            lastInstance = new Colour(r, g, b, a);
        }
        return lastInstance;
    }

    public static Colour getColour(int r, int g, int b) {
        return Colour.getColour(r, g, b, 255);
    }

    public static Colour getColour(Colour c1, Colour c2) {
        if (c1.reallyEquals(c2)) {
            return Colour.getColour(c1);
        }
        int r = (c1.getRed() + c2.getRed()) / 2;
        int g = (c1.getGreen() + c2.getGreen()) / 2;
        int b = (c1.getBlue() + c2.getBlue()) / 2;
        int a = (c1.getAlpha() + c2.getAlpha()) / 2;
        return Colour.getColour(r, g, b, a);
    }

    private static Colour retrieveInstance(int r, int g, int b, int a) {
        if (lastInstance != null && lastInstance.equals(r, g, b, a)) {
            return lastInstance;
        }
        for (Colour lastInstance : instances) {
            if (!lastInstance.equals(r, g, b, a)) continue;
            return lastInstance;
        }
        lastInstance = null;
        return lastInstance;
    }

    public Colour getTranslucent(int a) {
        return Colour.getColour(this.getRed(), this.getGreen(), this.getBlue(), a);
    }

    public boolean equals(Object obj) {
        if (disableEquals) {
            return false;
        }
        return super.equals(obj);
    }

    public boolean reallyEquals(Colour c) {
        if (this == c) {
            return true;
        }
        return this.equals(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
    }

    public boolean equals(int r, int g, int b, int a) {
        return this.getRed() == r && this.getGreen() == g && this.getBlue() == b && this.getAlpha() == a;
    }
}

