/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.TwoWayBoundedRangeModel;
import GridWare.WindowsGWSliderUI;
import javax.swing.BoundedRangeModel;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;

public class GWSlider
extends JSlider {
    private static final String uiClassID = "GWSliderUI";

    public GWSlider() {
        super(new TwoWayBoundedRangeModel());
    }

    public GWSlider(int min, int max, int value) {
        super(new TwoWayBoundedRangeModel(value, 0, min, max));
    }

    public void updateUI() {
        this.updateLabelUIs();
        this.setUI((SliderUI)((Object)new WindowsGWSliderUI(this)));
    }

    public BoundedRangeModel getModel() {
        return this.sliderModel;
    }

    public void setModel(BoundedRangeModel newModel) {
        BoundedRangeModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeChangeListener(this.changeListener);
        }
        this.sliderModel = (TwoWayBoundedRangeModel)newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", oldModel == null ? null : new Integer(oldModel.getValue()), newModel == null ? null : new Integer(newModel.getValue()));
            }
        }
        this.firePropertyChange("model", oldModel, this.sliderModel);
    }

    public void setValue(int v, boolean preserveExtent) {
        ((TwoWayBoundedRangeModel)this.getModel()).setValue(v, preserveExtent);
    }

    public void setValueAndExtent(int v, int e) {
        ((TwoWayBoundedRangeModel)this.getModel()).setValueAndExtent(v, e);
    }

    public void ensureExtentNegative() {
        if (this.getExtent() > 0) {
            ((TwoWayBoundedRangeModel)this.getModel()).flipRange();
        }
    }

    public void ensureExtentPositive() {
        if (this.getExtent() < 0) {
            ((TwoWayBoundedRangeModel)this.getModel()).flipRange();
        }
    }
}

