/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GridWindow;
import GridWare.MeasuresWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;

abstract class MeasureChooser
extends JComboBox {
    static final String REMOVE = "-----REMOVE-----";
    static final String NUMTRAJS = "Selected Trajectories";
    static final String NUMCELLS = "Selected Cells";
    static final String DURATION = "Mean Duration";
    static final String MISSING_DURATION = "Mean Missing Duration";
    static final String MISSING_EVENTS = "Mean Missing Events";
    static final String EVENTS = "Mean # of Events";
    static final String VISITS = "Mean # of Visits";
    static final String MEAN_RANGE = "Mean Cell Range";
    static final String OVERALL_RANGE = "Overall Cell Range";
    static final String DISPERSION = "Dispersion";
    static final String DUR_ENTROPY = "Duration Entropy";
    static final String VISIT_ENTROPY = "Visit Entropy";
    static final String DUR_PER_EVENT = "Duration Per Event";
    static final String DUR_PER_VISIT = "Duration Per Visit";
    static final String DUR_PER_CELL = "Duration Per Cell";
    static final String RETURN_TIME = "Mean Return Time";
    static final String RETURN_VISITS = "Mean Return Visits";
    static final String FIRST_ENTRY = "First Entry";
    static final String LAST_EXIT = "Last Exit";
    MeasuresWindow measuresWindow;
    JLabel outputLabel;
    static NumberFormat nf = NumberFormat.getInstance();
    static ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            MeasureChooser source = (MeasureChooser)e.getSource();
            String selected = (String)source.getSelectedItem();
            if (selected.equals(MeasureChooser.REMOVE)) {
                source.remove();
            } else {
                source.updateLabel();
            }
        }
    };

    MeasureChooser(MeasuresWindow mW, JLabel oL, String[] measures) {
        super(measures);
        this.measuresWindow = mW;
        this.outputLabel = oL;
        this.addActionListener(actionListener);
        this.addItem(REMOVE);
    }

    public abstract void updateLabel();

    public abstract void remove();

    public static String format(double number) {
        if (number >= 0.0) {
            return nf.format(number);
        }
        return GridWindow.missingValue;
    }

    public static String format(int number) {
        if (number >= 0) {
            return String.valueOf(number);
        }
        return GridWindow.missingValue;
    }
}

