/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.Trajectory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class Preferences
extends JFrame {
    protected JButton okButton;
    protected JButton cancelButton;
    protected JTextField minReturnsField;
    protected JTextField maxReturnTimeField;
    protected JTextField maxReturnVisitsField;
    protected JTextField missingValueField;
    protected JTextField minEventDurationField;
    protected JTextField minCellDurationField;
    protected JTextField transBinSizeField;
    protected JTextField transNumBinsField;
    protected JComboBox onsetOffsetChooser;
    static NumberFormat nf = NumberFormat.getInstance();

    public Preferences() {
        super("Preferences");
        int row;
        JLabel minReturnsLabel = new JLabel("Minimum Number of Returns: ");
        this.minReturnsField = new JTextField(4);
        JLabel maxReturnTimeLabel = new JLabel("Maximum Return Time: ");
        this.maxReturnTimeField = new JTextField(4);
        JLabel maxReturnVisitsLabel = new JLabel("Maximum Return Visits: ");
        this.maxReturnVisitsField = new JTextField(4);
        JLabel minEventDurationLabel = new JLabel("Minimum Event Duration: ");
        this.minEventDurationField = new JTextField(4);
        JLabel minCellDurationLabel = new JLabel("Minimum Cell Duration: ");
        this.minCellDurationField = new JTextField(4);
        JLabel missingValueLabel = new JLabel("Missing Value Symbol: ");
        this.missingValueField = new JTextField(4);
        Container contentPane = this.getContentPane();
        ((JPanel)contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout(10, 10));
        GridBagLayout prefLayout = new GridBagLayout();
        JPanel prefPanel = new JPanel(prefLayout);
        GridBagConstraints col1Constraints = new GridBagConstraints();
        col1Constraints.gridx = 0;
        col1Constraints.weightx = 0.0;
        col1Constraints.weighty = 0.0;
        col1Constraints.fill = 0;
        col1Constraints.anchor = 13;
        GridBagConstraints col2Constraints = new GridBagConstraints();
        col2Constraints.gridx = 1;
        col2Constraints.weightx = 0.0;
        col2Constraints.weighty = 0.0;
        col2Constraints.fill = 0;
        col2Constraints.anchor = 17;
        col1Constraints.gridy = row = 0;
        col2Constraints.gridy = row++;
        prefLayout.setConstraints(minReturnsLabel, col1Constraints);
        prefLayout.setConstraints(this.minReturnsField, col2Constraints);
        prefPanel.add(minReturnsLabel);
        prefPanel.add(this.minReturnsField);
        col1Constraints.gridy = row;
        col2Constraints.gridy = row++;
        prefLayout.setConstraints(maxReturnTimeLabel, col1Constraints);
        prefLayout.setConstraints(this.maxReturnTimeField, col2Constraints);
        prefPanel.add(maxReturnTimeLabel);
        prefPanel.add(this.maxReturnTimeField);
        col1Constraints.gridy = row;
        col2Constraints.gridy = row++;
        prefLayout.setConstraints(maxReturnVisitsLabel, col1Constraints);
        prefLayout.setConstraints(this.maxReturnVisitsField, col2Constraints);
        prefPanel.add(maxReturnVisitsLabel);
        prefPanel.add(this.maxReturnVisitsField);
        col1Constraints.gridy = row;
        col2Constraints.gridy = row++;
        prefLayout.setConstraints(minEventDurationLabel, col1Constraints);
        prefLayout.setConstraints(this.minEventDurationField, col2Constraints);
        prefPanel.add(minEventDurationLabel);
        prefPanel.add(this.minEventDurationField);
        col1Constraints.gridy = row;
        col2Constraints.gridy = row++;
        prefLayout.setConstraints(minCellDurationLabel, col1Constraints);
        prefLayout.setConstraints(this.minCellDurationField, col2Constraints);
        prefPanel.add(minCellDurationLabel);
        prefPanel.add(this.minCellDurationField);
        col1Constraints.gridy = row;
        col2Constraints.gridy = row;
        prefLayout.setConstraints(missingValueLabel, col1Constraints);
        prefLayout.setConstraints(this.missingValueField, col2Constraints);
        prefPanel.add(missingValueLabel);
        prefPanel.add(this.missingValueField);
        this.getContentPane().add((Component)prefPanel, "North");
        JPanel buttonPanel = new JPanel(new FlowLayout(2, 10, 10));
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newEvent) {
                Preferences.this.setVisible(false);
            }
        });
        this.okButton = new JButton("OK");
        buttonPanel.add(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent newEvent) {
                boolean prefsChanged = false;
                if (Trajectory.minReturns != Integer.parseInt(Preferences.this.minReturnsField.getText())) {
                    Trajectory.minReturns = Integer.parseInt(Preferences.this.minReturnsField.getText());
                    prefsChanged = true;
                }
                if (Trajectory.maxReturnTime != Double.parseDouble(Preferences.this.maxReturnTimeField.getText())) {
                    Trajectory.maxReturnTime = Double.parseDouble(Preferences.this.maxReturnTimeField.getText());
                    prefsChanged = true;
                }
                if (Trajectory.maxReturnVisits != Integer.parseInt(Preferences.this.maxReturnVisitsField.getText())) {
                    Trajectory.maxReturnVisits = Integer.parseInt(Preferences.this.maxReturnVisitsField.getText());
                    prefsChanged = true;
                }
                if (Trajectory.minEventDuration != Double.parseDouble(Preferences.this.minEventDurationField.getText())) {
                    Trajectory.minEventDuration = Double.parseDouble(Preferences.this.minEventDurationField.getText());
                    prefsChanged = true;
                }
                if (Trajectory.minCellDuration != Double.parseDouble(Preferences.this.minCellDurationField.getText())) {
                    Trajectory.minCellDuration = Double.parseDouble(Preferences.this.minCellDurationField.getText());
                    prefsChanged = true;
                }
                if (!GridWindow.missingValue.equals(Preferences.this.missingValueField.getText())) {
                    GridWindow.missingValue = Preferences.this.missingValueField.getText();
                    prefsChanged = true;
                }
                if (Preferences.this.onsetOffsetChooser.getSelectedIndex() == 0 && !Trajectory.onsetRelativeTrans) {
                    Trajectory.onsetRelativeTrans = true;
                    prefsChanged = true;
                } else if (Preferences.this.onsetOffsetChooser.getSelectedIndex() == 1 && Trajectory.onsetRelativeTrans) {
                    Trajectory.onsetRelativeTrans = false;
                    prefsChanged = true;
                }
                if (Trajectory.transBinSize != Integer.parseInt(Preferences.this.transBinSizeField.getText())) {
                    Trajectory.transBinSize = Integer.parseInt(Preferences.this.transBinSizeField.getText());
                    prefsChanged = true;
                }
                if (Trajectory.transNumBins != Integer.parseInt(Preferences.this.transNumBinsField.getText())) {
                    Trajectory.transNumBins = Integer.parseInt(Preferences.this.transNumBinsField.getText());
                    prefsChanged = true;
                }
                if (prefsChanged) {
                    GridWare.setSomethingToSave(true);
                    GridWare.gridWindow.takeMeasures();
                }
                Preferences.this.setVisible(false);
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setLocation(20, 40);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.minReturnsField.setText(Integer.toString(Trajectory.minReturns));
            this.maxReturnTimeField.setText(nf.format(Trajectory.maxReturnTime));
            this.maxReturnVisitsField.setText(Integer.toString(Trajectory.maxReturnVisits));
            this.minEventDurationField.setText(nf.format(Trajectory.minEventDuration));
            this.minCellDurationField.setText(nf.format(Trajectory.minCellDuration));
            this.missingValueField.setText(GridWindow.missingValue);
        }
        super.setVisible(visible);
    }
}

