/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellSet;
import GridWare.Colour;
import GridWare.DyadEvent;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.HasVariables;
import GridWare.IOHandler;
import GridWare.Variable;
import GridWare.VariableMap;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Trajectory
extends LinkedList
implements HasVariables {
    String path;
    String filename;
    StringWriter stringWriter;
    boolean stringWritten = false;
    static NumberFormat nf = NumberFormat.getInstance();
    static List trajVars = new ArrayList();
    static Map trajectoryVariables = new HashMap();
    static boolean variablesFixed = false;
    static double maxDuration;
    static double minDuration;
    VariableMap variables;
    List columnLabels = new ArrayList();
    List inertValues;
    static int minReturns;
    static double maxReturnTime;
    static int maxReturnVisits;
    static double minEventDuration;
    static double minCellDuration;
    static int maxVisitLag;
    static int maxTimeLag;
    static int transBinSize;
    static int transNumBins;
    static boolean onsetRelativeTrans;
    static boolean drawNodes;
    static boolean hollowNodes;
    static boolean translucentNodes;
    static boolean markStartNode;
    static boolean drawTransitions;
    static boolean drawArrows;
    static boolean drawMissing;
    static int arrowSize;
    static float[] dashArray;
    static BasicStroke outlineStroke;
    static BasicStroke solidStroke;
    static BasicStroke dashStroke;
    private CellSet measuredRegion = null;
    private Variable measuredXVar = null;
    private Variable measuredYVar = null;
    private int measuredMinReturns;
    private double measuredMaxReturnTime;
    private int measuredMaxReturnVisits;
    private double measuredMinEventDuration;
    private double measuredMinCellDuration;
    private double measuredMinTime;
    private double measuredMaxTime;
    double duration;
    double trimmedDuration;
    double gridDuration;
    double fullDuration;
    double missingDuration;
    double onset;
    double offset;
    double trimmedOnset;
    double trimmedOffset;
    int cellRange;
    int numVisits;
    int numEvents;
    int missingEvents;
    double durPerCell;
    double durPerEvent;
    double durPerVisit;
    double dispersion;
    double minDur;
    double regionDuration;
    int regionEvents;
    int regionVisits;
    int regionRange;
    int regionTimeReturns;
    int regionVisitReturns;
    double regionReturnTimeTotal;
    double regionReturnTime;
    int regionReturnVisitsTotal;
    double regionReturnVisits;
    double regionDurPerCell;
    double regionDurPerEvent;
    double regionDurPerVisit;
    double regionFirstEntry;
    double regionLastExit;
    double regionDispersion;
    int[][] cellNumEvents;
    int[][] cellNumVisits;
    double[][] cellDurations;
    double[][] cellReturnTimeTotals;
    double[][] cellReturnTimes;
    int[][] cellReturnVisitTotals;
    double[][] cellReturnVisits;
    int[][] cellTimeReturns;
    int[][] cellVisitReturns;
    double[][] cellDurPerEvent;
    double[][] cellDurPerVisit;
    double[][] cellFirstEntry;
    double[][] cellLastExit;
    double durEntropy;
    double visitEntropy;
    double transEntropy;
    double[][][] transProp;
    double TP;
    double TE;

    static {
        minDuration = Double.MAX_VALUE;
        minReturns = 2;
        maxReturnTime = 10.0;
        maxReturnVisits = 6;
        minEventDuration = 0.0;
        minCellDuration = 0.0;
        maxVisitLag = 5;
        maxTimeLag = 15;
        transBinSize = 3;
        transNumBins = 4;
        onsetRelativeTrans = false;
        drawNodes = false;
        hollowNodes = false;
        translucentNodes = true;
        markStartNode = true;
        drawTransitions = false;
        drawArrows = false;
        drawMissing = true;
        arrowSize = 10;
        dashArray = new float[]{5.0f, 5.0f};
        outlineStroke = new BasicStroke(GridWare.macPlatform ? 1.0f : 2.0f);
        solidStroke = new BasicStroke();
        dashStroke = new BasicStroke(solidStroke.getLineWidth(), solidStroke.getEndCap(), solidStroke.getLineJoin(), solidStroke.getMiterLimit(), dashArray, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Trajectory(String p, String fn, VariableMap vars, List iV) throws IOException {
        this.variables = vars;
        this.filename = fn;
        this.path = p;
        this.inertValues = iV;
        System.out.println("Opening " + this.path + this.filename + "...");
        FileReader fileReader = new FileReader(String.valueOf(this.path) + this.filename);
        if (fileReader == null) {
            throw new IOException("Unable to open " + this.path + this.filename);
        }
        this.stringWriter = new StringWriter(8192);
        char[] c = new char[8192];
        int count = fileReader.read(c);
        while (count != -1) {
            this.stringWriter.write(c, 0, count);
            count = fileReader.read(c);
        }
        fileReader.close();
        StringWriter stringWriter = this.stringWriter;
        synchronized (stringWriter) {
            this.stringWritten = true;
            this.stringWriter.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void parseString() {
        block32: {
            var1_1 = this.stringWriter;
            synchronized (var1_1) {
                while (true) {
                    while (true) {
                        if (this.stringWritten) {
                            break block32;
                        }
                        try {
                            this.stringWriter.wait();
                        }
                        catch (InterruptedException var2_3) {
                            // empty catch block
                        }
                    }
                    break;
                }
                catch (Throwable v0) {
                    throw v0;
                }
            }
        }
        try {
            if (!this.stringWritten) {
                throw new IOException("Timed out waiting for trajectory file " + this.filename + " to be read.");
            }
            br = new BufferedReader(new StringReader(this.stringWriter.toString()));
            if (br == null) {
                throw new IOException("Trajectory file " + this.filename + "was not read.");
            }
            line = br.readLine();
            if (line == null) {
                throw new IOException(String.valueOf(this.filename) + " empty.");
            }
            do {
                if (!(st = new StringTokenizer(line, "\t")).hasMoreTokens()) continue;
                stateVariables = new HashSet<E>(DyadEvent.getStateVariables());
                if (true) ** GOTO lbl43
            } while ((line = br.readLine()) != null);
            throw new IOException(String.valueOf(this.filename) + " empty.");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            GridWare.quitDueToError(ex.getMessage());
        }
        return;
        do {
            columnLabel = st.nextToken().trim().toLowerCase();
            this.columnLabels.add(columnLabel);
            if (!DyadEvent.isVariable(columnLabel)) continue;
            stateVariables.remove(DyadEvent.getVariable(columnLabel));
lbl43:
            // 3 sources

        } while (st.hasMoreTokens());
        if (!this.columnLabels.contains("onset")) {
            throw new IOException("No \"Onset\" column found in file " + this.filename);
        }
        if (stateVariables.size() > 0) {
            throw new IOException("Missing state variables: " + stateVariables.toString() + " in file " + this.filename);
        }
        readFinalOffset = false;
        prevOnset = 0.0;
        while ((line = br.readLine()) != null) {
            st = new StringTokenizer(line, "\t");
            if (!st.hasMoreTokens()) continue;
            state = new Comparable[DyadEvent.numVariables()];
            inertValues = new ArrayList<String>();
            atLeastOneValue = false;
            onsetString = null;
            colourString = null;
            xPosString = null;
            yPosString = null;
            eventOnset = 0.0;
            nodeColour = null;
            nodePosition = null;
            for (String curLabel : this.columnLabels) {
                if (st.hasMoreTokens()) {
                    curVariable = DyadEvent.isVariable(curLabel) != false ? DyadEvent.getVariable(curLabel) : null;
                    valueString = st.nextToken().trim();
                    if (curVariable != null) {
                        if (valueString.equals("")) continue;
                        atLeastOneValue = true;
                        variableValue = curVariable.valueOf(valueString);
                        curVariable.addValue(variableValue);
                        state[DyadEvent.getVariableIndex((Variable)curVariable)] = variableValue;
                        continue;
                    }
                    if (curLabel.equals("onset")) {
                        onsetString = valueString;
                        try {
                            eventOnset = Trajectory.parseOnset(onsetString);
                        }
                        catch (ParseException ex) {
                            System.out.println("Onset value not a properly formatted number in file " + this.filename);
                            ex.printStackTrace();
                            GridWare.quitDueToError("Onset value not a properly formatted number in file " + this.filename);
                        }
                        continue;
                    }
                    if (curLabel.equals("colour") || curLabel.equals("color")) {
                        if (valueString.equals("")) continue;
                        atLeastOneValue = true;
                        nodeColour = Colour.getColour(Integer.parseInt(valueString), false);
                        continue;
                    }
                    if (curLabel.endsWith(" pos")) {
                        posVarName = curLabel.substring(0, curLabel.length() - 4);
                        if (!DyadEvent.isVariable(posVarName)) continue;
                        posVariable = DyadEvent.getVariable(posVarName);
                        if (valueString.equals("")) continue;
                        atLeastOneValue = true;
                        if (nodePosition == null) {
                            nodePosition = DyadEvent.getRandomPosition();
                        }
                        nodePosition[DyadEvent.getVariableIndex((Variable)posVariable)] = Double.parseDouble(valueString);
                        continue;
                    }
                    inertValues.add(valueString);
                    continue;
                }
                if (onsetString == null) throw new IOException("Missing value in column " + curLabel);
                if (atLeastOneValue != false) throw new IOException("Missing value in column " + curLabel);
                this.offset = eventOnset;
                this.duration = this.offset - this.onset;
                readFinalOffset = true;
            }
            if (this.size() == 0) {
                this.onset = eventOnset;
            } else {
                ((DyadEvent)this.getLast()).setOffset(eventOnset - this.onset);
            }
            if (!readFinalOffset) {
                de = new DyadEvent(this, eventOnset - this.onset, state, inertValues, nodeColour, nodePosition);
                this.add(de);
            }
            if (eventOnset > 0.0 && eventOnset != this.offset && (min_dur = eventOnset - prevOnset) > Trajectory.minEventDuration) {
                Trajectory.minDuration = Math.min(Trajectory.minDuration, min_dur);
            }
            prevOnset = eventOnset;
        }
        if (!readFinalOffset) {
            throw new IOException("No final offset found in file " + this.filename);
        }
        br.close();
    }

    static double parseOnset(String onsetString) throws ParseException {
        StringTokenizer st = new StringTokenizer(onsetString, ":", true);
        double onset = 0.0;
        while (st.hasMoreTokens()) {
            String curToken = st.nextToken();
            if (curToken.equals(":")) {
                onset *= 60.0;
                continue;
            }
            onset += nf.parse(curToken).doubleValue();
        }
        return onset;
    }

    public static void fixVariables() {
        variablesFixed = true;
    }

    public static void init() {
        trajVars = new ArrayList();
        trajectoryVariables = new HashMap();
        variablesFixed = false;
        maxDuration = 0.0;
        minReturns = 2;
        maxReturnTime = 10.0;
        maxReturnVisits = 6;
        minEventDuration = 0.0;
        minCellDuration = 0.0;
        maxVisitLag = 5;
        maxTimeLag = 15;
        drawNodes = false;
        hollowNodes = false;
        translucentNodes = true;
        markStartNode = true;
        drawTransitions = false;
        drawArrows = false;
        drawMissing = true;
        arrowSize = 10;
    }

    public static void addTrajectoryVariable(Variable v) {
        if (!variablesFixed) {
            if (trajectoryVariables.containsKey(v.label)) {
                throw new IllegalArgumentException("Variable " + v.label + " already exists.");
            }
        } else {
            throw new UnsupportedOperationException("New variables can no longer be added.");
        }
        trajectoryVariables.put(v.label, v);
        trajVars.add(v);
    }

    public static VariableMap getEmptyVariables() {
        return new VariableMap(trajectoryVariables);
    }

    public static Variable getVariable(String label) {
        if (Trajectory.isVariable(label = label.toLowerCase())) {
            return (Variable)trajectoryVariables.get(label);
        }
        throw new IllegalArgumentException("Variable \"" + label + "\" not found.");
    }

    public static List getTrajectoryVariables() {
        return trajVars;
    }

    public static boolean isVariable(Variable v) {
        return trajectoryVariables.containsValue(v);
    }

    public static boolean isVariable(String s) {
        return trajectoryVariables.containsKey(s);
    }

    public static int numVariables() {
        return trajectoryVariables.size();
    }

    public static Vector getVariables() {
        return new Vector(trajVars);
    }

    public static Vector getVariableNames() {
        Vector<String> names = new Vector<String>();
        Iterator i = Trajectory.getVariables().iterator();
        while (i.hasNext()) {
            names.add(((Variable)i.next()).label);
        }
        return names;
    }

    public Comparable getValue(Variable v) {
        if (this.variables.containsKey(v)) {
            return (Comparable)this.variables.get(v);
        }
        throw new IllegalArgumentException("Variable \"" + v.label + "\" not found.");
    }

    public void takeMeasures(Variable xVar, Variable yVar, CellSet region, int minTime, int maxTime) {
        int finalOutVisits;
        boolean updateRegionMeasures = false;
        if (!region.equals(this.measuredRegion)) {
            updateRegionMeasures = true;
            this.measuredRegion = new CellSet(region);
        }
        boolean updateReturnMeasures = false;
        if (minReturns != this.measuredMinReturns || maxReturnTime != this.measuredMaxReturnTime || maxReturnVisits != this.measuredMaxReturnVisits) {
            updateReturnMeasures = true;
            this.measuredMinReturns = minReturns;
            this.measuredMaxReturnTime = maxReturnTime;
            this.measuredMaxReturnVisits = maxReturnVisits;
        }
        boolean updateGridMeasures = false;
        if (!xVar.equals(this.measuredXVar) || !yVar.equals(this.measuredYVar)) {
            updateGridMeasures = true;
            updateRegionMeasures = true;
            updateReturnMeasures = true;
            this.measuredXVar = xVar;
            this.measuredYVar = yVar;
        }
        if ((double)minTime != this.measuredMinTime || (double)maxTime != this.measuredMaxTime || minEventDuration != this.measuredMinEventDuration || minCellDuration != this.measuredMinCellDuration) {
            updateGridMeasures = true;
            updateRegionMeasures = true;
            updateReturnMeasures = true;
            this.measuredMinTime = minTime;
            this.measuredMaxTime = maxTime;
            this.measuredMinEventDuration = minEventDuration;
            this.measuredMinCellDuration = minCellDuration;
        }
        if (!(updateRegionMeasures || updateGridMeasures || updateReturnMeasures)) {
            return;
        }
        int numX = xVar.numValues();
        int numY = yVar.numValues();
        int numCells = numX * numY;
        this.trimmedOnset = this.onset + Math.max((double)minTime, 0.0);
        this.trimmedOffset = this.onset + Math.min((double)maxTime, this.duration);
        this.trimmedDuration = this.trimmedOffset - this.trimmedOnset;
        if (updateGridMeasures) {
            this.gridDuration = 0.0;
            this.fullDuration = 0.0;
            this.missingDuration = 0.0;
            this.missingEvents = 0;
            this.cellRange = 0;
            this.numVisits = 0;
            this.numEvents = 0;
            this.durPerEvent = 0.0;
            this.durPerVisit = 0.0;
            this.durPerCell = 0.0;
            this.dispersion = 0.0;
            this.durEntropy = 0.0;
            this.visitEntropy = 0.0;
            this.transEntropy = 0.0;
        }
        if (updateRegionMeasures) {
            this.regionDuration = 0.0;
            this.regionEvents = 0;
            this.regionVisits = 0;
            this.regionRange = 0;
            this.regionDurPerEvent = 0.0;
            this.regionDurPerVisit = 0.0;
            this.regionDurPerCell = 0.0;
            this.regionDispersion = 0.0;
        }
        DyadEvent previousRegionVisit = null;
        int regionVisitsSince = -1;
        if (updateRegionMeasures || updateReturnMeasures) {
            this.regionTimeReturns = 0;
            this.regionVisitReturns = 0;
            this.regionReturnTimeTotal = 0.0;
            this.regionReturnTime = -1.0;
            this.regionReturnVisitsTotal = 0;
            this.regionReturnVisits = -1.0;
            this.regionFirstEntry = this.trimmedDuration;
            this.regionLastExit = 0.0;
        }
        if (updateGridMeasures) {
            this.cellNumEvents = new int[numX][numY];
            this.cellNumVisits = new int[numX][numY];
            this.cellDurations = new double[numX][numY];
            this.cellDurPerEvent = new double[numX][numY];
            this.cellDurPerVisit = new double[numX][numY];
        }
        DyadEvent[][] prevVisit = new DyadEvent[numX][numY];
        DyadEvent previousCellVisit = null;
        int[][] cellVisitsSince = new int[numX][numY];
        if (updateReturnMeasures) {
            this.cellReturnTimeTotals = new double[numX][numY];
            this.cellReturnTimes = new double[numX][numY];
            this.cellReturnVisitTotals = new int[numX][numY];
            this.cellReturnVisits = new double[numX][numY];
            this.cellTimeReturns = new int[numX][numY];
            this.cellVisitReturns = new int[numX][numY];
            this.cellFirstEntry = new double[numX][numY];
            this.cellLastExit = new double[numX][numY];
        }
        DyadEvent curEvent = null;
        DyadEvent prevEvent = null;
        int curX = -1;
        int curY = -1;
        this.minDur = Double.MAX_VALUE;
        ListIterator i = this.listIterator();
        while (i.hasNext()) {
            curEvent = (DyadEvent)i.next();
            if (curEvent.onset >= (double)maxTime || curEvent.offset <= (double)minTime) continue;
            curX = curEvent.getValueIndex(xVar);
            curY = curEvent.getValueIndex(yVar);
            double trimmedEventOnset = Math.max((double)minTime, curEvent.onset);
            double trimmedEventOffset = Math.min((double)maxTime, curEvent.offset);
            double trimmedEventDuration = trimmedEventOffset - trimmedEventOnset;
            if (updateGridMeasures) {
                this.fullDuration += trimmedEventDuration;
            }
            if (curX == -1 || curY == -1) {
                if (!updateGridMeasures) continue;
                this.missingDuration += trimmedEventDuration;
                ++this.missingEvents;
                continue;
            }
            this.minDur = Math.min(this.minDur, curEvent.duration());
            if (curEvent.duration() < minEventDuration) continue;
            if (updateGridMeasures) {
                this.gridDuration += trimmedEventDuration;
                ++this.numEvents;
                int[] nArray = this.cellNumEvents[curX];
                int n = curY;
                nArray[n] = nArray[n] + 1;
                double[] dArray = this.cellDurations[curX];
                int n2 = curY;
                dArray[n2] = dArray[n2] + trimmedEventDuration;
            }
            if (updateReturnMeasures) {
                previousCellVisit = prevVisit[curX][curY];
                if (previousCellVisit == null) {
                    this.cellFirstEntry[curX][curY] = trimmedEventOnset;
                } else if (cellVisitsSince[curX][curY] - 1 > 0) {
                    int[] nArray = this.cellReturnVisitTotals[curX];
                    int n = curY;
                    nArray[n] = nArray[n] + Math.min(cellVisitsSince[curX][curY] - 1, maxReturnVisits);
                    double[] dArray = this.cellReturnTimeTotals[curX];
                    int n3 = curY;
                    dArray[n3] = dArray[n3] + Math.min(curEvent.onset - previousCellVisit.offset, maxReturnTime);
                }
                this.cellLastExit[curX][curY] = trimmedEventOffset;
            }
            if ((updateRegionMeasures || updateReturnMeasures) && region.contains(curEvent.getCell())) {
                ++this.regionEvents;
                this.regionDuration += trimmedEventDuration;
                if (prevEvent == null || !region.contains(prevEvent.getCell())) {
                    ++this.regionVisits;
                    if (previousRegionVisit == null) {
                        this.regionFirstEntry = trimmedEventOnset;
                    } else {
                        this.regionReturnVisitsTotal += Math.min(regionVisitsSince, maxReturnVisits);
                        this.regionReturnTimeTotal += Math.min(curEvent.onset - previousRegionVisit.offset, maxReturnTime);
                    }
                }
                previousRegionVisit = curEvent;
                this.regionLastExit = trimmedEventOffset;
            }
            if (prevEvent == null || curEvent.getCell() != prevEvent.getCell()) {
                if (updateGridMeasures) {
                    int[] nArray = this.cellNumVisits[curX];
                    int n = curY;
                    nArray[n] = nArray[n] + 1;
                    ++this.numVisits;
                    double startTime = curEvent.offset;
                    DyadEvent prevLagEvent = curEvent;
                    ListIterator j = this.listIterator(i.nextIndex());
                    int timeCount = 0;
                    int visitCount = 0;
                    while (j.hasNext() && timeCount < maxTimeLag && visitCount < maxVisitLag) {
                        DyadEvent lagEvent = (DyadEvent)j.next();
                        int lagX = lagEvent.getValueIndex(xVar);
                        int lagY = lagEvent.getValueIndex(yVar);
                        if (lagX == -1 || lagY == -1) continue;
                        if (lagEvent.getCell() != prevLagEvent.getCell()) {
                            ++visitCount;
                        }
                        while ((double)timeCount < lagEvent.offset - startTime && timeCount < maxTimeLag) {
                            ++timeCount;
                        }
                        prevLagEvent = lagEvent;
                    }
                }
                if (updateReturnMeasures) {
                    int x = 0;
                    while (x < numX) {
                        int y = 0;
                        while (y < numY) {
                            if (x == curX && y == curY) {
                                cellVisitsSince[x][y] = 0;
                            } else if (cellVisitsSince[x][y] >= 0) {
                                int[] nArray = cellVisitsSince[x];
                                int n = y;
                                nArray[n] = nArray[n] + 1;
                            }
                            ++y;
                        }
                        ++x;
                    }
                }
                if (updateRegionMeasures || updateReturnMeasures) {
                    if (region.contains(curEvent.getCell())) {
                        regionVisitsSince = 0;
                    } else if (regionVisitsSince >= 0) {
                        ++regionVisitsSince;
                    }
                }
            }
            prevEvent = curEvent;
            prevVisit[curX][curY] = curEvent;
        }
        if (updateRegionMeasures || updateReturnMeasures) {
            if (this.regionVisits > 0) {
                this.regionTimeReturns = this.regionVisits - 1;
                this.regionReturnTime = this.regionTimeReturns > 0 ? this.regionReturnTimeTotal / (double)this.regionTimeReturns : 0.0;
                double finalOutTime = Math.min(this.duration, (double)maxTime) - previousRegionVisit.offset;
                if (this.regionTimeReturns == 0 && finalOutTime >= maxReturnTime) {
                    this.regionReturnTimeTotal = maxReturnTime;
                    this.regionTimeReturns = 1;
                    this.regionReturnTime = maxReturnTime;
                } else if (finalOutTime > this.regionReturnTime) {
                    this.regionReturnTimeTotal += Math.min(finalOutTime, maxReturnTime);
                    ++this.regionTimeReturns;
                    this.regionReturnTime = this.regionReturnTimeTotal / (double)this.regionTimeReturns;
                }
                if (this.regionTimeReturns < minReturns) {
                    this.regionReturnTime = -1.0;
                }
                this.regionVisitReturns = this.regionVisits - 1;
                this.regionReturnVisits = this.regionVisitReturns > 0 ? this.regionReturnVisitsTotal / this.regionVisitReturns : 0;
                finalOutVisits = regionVisitsSince;
                if (this.regionVisitReturns == 0 && finalOutVisits >= maxReturnVisits) {
                    this.regionReturnVisitsTotal = maxReturnVisits;
                    this.regionVisitReturns = 1;
                    this.regionReturnVisits = maxReturnVisits;
                } else if ((double)finalOutVisits > this.regionReturnVisits) {
                    this.regionReturnVisitsTotal += Math.min(finalOutVisits, maxReturnVisits);
                    ++this.regionVisitReturns;
                    this.regionReturnVisits = (double)this.regionReturnVisitsTotal / (double)this.regionVisitReturns;
                }
                if (this.regionVisitReturns < minReturns) {
                    this.regionReturnVisits = -1.0;
                }
            } else {
                this.regionReturnTimeTotal = -1.0;
                this.regionReturnTime = -1.0;
                this.regionReturnVisitsTotal = -1;
                this.regionReturnVisits = -1.0;
            }
        }
        if (updateRegionMeasures || updateReturnMeasures) {
            int x = 0;
            while (x < numX) {
                int y = 0;
                while (y < numY) {
                    if (updateGridMeasures) {
                        this.cellDurPerEvent[x][y] = this.cellNumEvents[x][y] > 0 ? this.cellDurations[x][y] / (double)this.cellNumEvents[x][y] : -1.0;
                        this.cellDurPerVisit[x][y] = this.cellNumVisits[x][y] > 0 ? this.cellDurations[x][y] / (double)this.cellNumVisits[x][y] : -1.0;
                        double durProb = this.cellDurations[x][y] / this.gridDuration;
                        this.dispersion += Math.pow(durProb, 2.0);
                        this.durEntropy -= durProb == 0.0 ? 0.0 : durProb * Math.log(durProb);
                        double visitProb = (double)this.cellNumVisits[x][y] / (double)this.numVisits;
                        this.visitEntropy -= visitProb == 0.0 ? 0.0 : visitProb * Math.log(visitProb);
                        boolean bl = false;
                    }
                    if (updateRegionMeasures && region.contains(GridWindow.cells[x][y])) {
                        this.regionDispersion += Math.pow(this.cellDurations[x][y] / this.regionDuration, 2.0);
                    }
                    if ((updateGridMeasures || updateRegionMeasures) && this.cellDurations[x][y] > minCellDuration) {
                        if (updateGridMeasures) {
                            ++this.cellRange;
                        }
                        if (updateRegionMeasures && region.contains(GridWindow.cells[x][y])) {
                            ++this.regionRange;
                        }
                    }
                    if (updateReturnMeasures) {
                        this.cellTimeReturns[x][y] = this.cellNumVisits[x][y] - 1;
                        if (this.cellTimeReturns[x][y] >= 0) {
                            this.cellReturnTimes[x][y] = this.cellTimeReturns[x][y] > 0 ? this.cellReturnTimeTotals[x][y] / (double)this.cellTimeReturns[x][y] : 0.0;
                            double finalOutTime = Math.min(this.duration, (double)maxTime) - prevVisit[x][y].offset;
                            if (this.cellTimeReturns[x][y] == 0 && finalOutTime >= maxReturnTime) {
                                this.cellReturnTimeTotals[x][y] = maxReturnTime;
                                this.cellTimeReturns[x][y] = 1;
                                this.cellReturnTimes[x][y] = maxReturnTime;
                            } else if (finalOutTime > this.cellReturnTimes[x][y]) {
                                double[] dArray = this.cellReturnTimeTotals[x];
                                int n = y;
                                dArray[n] = dArray[n] + Math.min(finalOutTime, maxReturnTime);
                                int[] nArray = this.cellTimeReturns[x];
                                int n4 = y;
                                nArray[n4] = nArray[n4] + 1;
                                this.cellReturnTimes[x][y] = this.cellReturnTimeTotals[x][y] / (double)this.cellTimeReturns[x][y];
                            }
                            if (this.cellTimeReturns[x][y] < minReturns) {
                                this.cellReturnTimes[x][y] = -1.0;
                            }
                        } else {
                            this.cellReturnTimeTotals[x][y] = -1.0;
                            this.cellReturnTimes[x][y] = -1.0;
                        }
                        this.cellVisitReturns[x][y] = this.cellNumVisits[x][y] - 1;
                        if (this.cellVisitReturns[x][y] >= 0) {
                            this.cellReturnVisits[x][y] = this.cellVisitReturns[x][y] > 0 ? this.cellReturnVisitTotals[x][y] / this.cellVisitReturns[x][y] : 0;
                            finalOutVisits = cellVisitsSince[x][y];
                            if (this.cellVisitReturns[x][y] == 0 && finalOutVisits >= maxReturnVisits) {
                                this.cellReturnVisitTotals[x][y] = maxReturnVisits;
                                this.cellVisitReturns[x][y] = 1;
                                this.cellReturnVisits[x][y] = maxReturnVisits;
                            } else if ((double)finalOutVisits > this.cellReturnVisits[x][y]) {
                                int[] nArray = this.cellReturnVisitTotals[x];
                                int n = y;
                                nArray[n] = nArray[n] + Math.min(finalOutVisits, maxReturnVisits);
                                int[] nArray2 = this.cellVisitReturns[x];
                                int n5 = y;
                                nArray2[n5] = nArray2[n5] + 1;
                                this.cellReturnVisits[x][y] = (double)this.cellReturnVisitTotals[x][y] / (double)this.cellVisitReturns[x][y];
                            }
                            if (this.cellVisitReturns[x][y] < minReturns) {
                                this.cellReturnVisits[x][y] = -1.0;
                            }
                        } else {
                            this.cellReturnVisitTotals[x][y] = -1;
                            this.cellReturnVisits[x][y] = -1.0;
                        }
                    }
                    ++y;
                }
                ++x;
            }
        }
        if (updateGridMeasures) {
            this.dispersion = (1.0 - this.dispersion) * (double)numCells / ((double)numCells - 1.0);
            this.durPerEvent = this.numEvents > 0 ? this.gridDuration / (double)this.numEvents : -1.0;
            this.durPerVisit = this.numVisits > 0 ? this.gridDuration / (double)this.numVisits : -1.0;
            double d = this.durPerCell = this.cellRange > 0 ? this.gridDuration / (double)this.cellRange : -1.0;
        }
        if (updateRegionMeasures) {
            this.regionDispersion = (1.0 - this.regionDispersion) * (double)region.size() / ((double)region.size() - 1.0);
            this.regionDurPerEvent = this.regionEvents > 0 ? this.regionDuration / (double)this.regionEvents : -1.0;
            this.regionDurPerVisit = this.regionVisits > 0 ? this.regionDuration / (double)this.regionVisits : -1.0;
            this.regionDurPerCell = this.regionRange > 0 ? this.regionDuration / (double)this.regionRange : -1.0;
        }
    }

    private double transBinTime(double time) {
        double temp = time % (double)transNumBins > 0.0 ? transNumBins : 0;
        return Math.floor(time / (double)transNumBins) + temp;
    }

    public void takeTransitionMeasures(Variable xVar, Variable yVar, CellSet dep, CellSet dest, int minTime, int maxTime) {
        this.TP = 0.0;
        this.TE = 0.0;
        int totalTrans = 0;
        int totalTransToDest = 0;
        double totalOriginDur = 0.0;
        boolean isSource = false;
        boolean isDest = false;
        boolean wasSource = false;
        double transBin = GridWindow.transBin;
        int curX = -1;
        int curY = -1;
        Iterator i = this.iterator();
        while (i.hasNext()) {
            double transProb = 0.0;
            DyadEvent curEvent = (DyadEvent)i.next();
            isSource = dep.contains(curEvent.getCell());
            isDest = dest.contains(curEvent.getCell());
            curX = curEvent.getValueIndex(xVar);
            curY = curEvent.getValueIndex(yVar);
            if (curX == -1 || curY == -1) continue;
            double curOnset = curEvent.onset;
            double curOffset = curEvent.offset;
            if (curOnset >= (double)maxTime || curOffset <= (double)minTime) continue;
            if (isSource) {
                if (i.hasNext()) {
                    double curDur = 0.0;
                    if (curEvent.offset > (double)maxTime) continue;
                    curDur = curEvent.onset < (double)minTime ? curEvent.offset - (double)minTime : curEvent.duration();
                    totalOriginDur += curDur;
                }
            } else if (wasSource) {
                if (isDest) {
                    ++totalTrans;
                    ++totalTransToDest;
                } else {
                    ++totalTrans;
                }
            }
            wasSource = isSource;
            if (totalTrans <= 0 || totalTransToDest <= 0) continue;
            transProb = (double)totalTransToDest / (double)totalTrans;
            this.TE -= transProb * Math.log(transProb);
        }
        this.TP = totalOriginDur > 0.0 && totalTransToDest > 0 ? (double)totalTransToDest / (totalOriginDur / transBin) : 0.0;
    }

    public void updateNodes() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            ((DyadEvent)i.next()).updateNode();
        }
    }

    public void randomizeNodes() {
        for (DyadEvent curEvent : this) {
            curEvent.nodePosition = DyadEvent.getRandomPosition();
            curEvent.updatePosition();
        }
    }

    public void randomizeNodes(CellSet cells) {
        for (DyadEvent curEvent : this) {
            if (!cells.isEmpty() && !cells.contains(curEvent.cell)) continue;
            curEvent.nodePosition = DyadEvent.getRandomPosition();
            curEvent.updatePosition();
        }
    }

    public void updateNodePositions() {
        for (DyadEvent curEvent : this) {
            curEvent.updatePosition();
        }
    }

    public void drawTransitions(Graphics2D g, int nodeLayout, int minTime, int maxTime) {
        Iterator i = this.iterator();
        DyadEvent nextEvent = (DyadEvent)i.next();
        DyadEvent lastNonMissingEvent = null;
        g.setStroke(solidStroke);
        Colour.disableEquals = true;
        if (nodeLayout == 0) {
            while (i.hasNext()) {
                int delta2;
                int delta1;
                double theta;
                int y_m;
                int x_m;
                int y2;
                int x2;
                int y1;
                int x1;
                DyadEvent curEvent = nextEvent;
                nextEvent = (DyadEvent)i.next();
                if (!(curEvent.offset > (double)minTime) || !(nextEvent.onset < (double)maxTime)) continue;
                if (curEvent.cell != null) {
                    lastNonMissingEvent = curEvent;
                    if (nextEvent.cell == null) continue;
                    g.setColor(Colour.getColour(curEvent.nodeColour, nextEvent.nodeColour));
                    x1 = curEvent.randomX;
                    y1 = curEvent.randomY;
                    x2 = nextEvent.randomX;
                    y2 = nextEvent.randomY;
                    g.drawLine(x1, y1, x2, y2);
                    if (!drawArrows) continue;
                    x_m = (x1 + x2) / 2;
                    y_m = (y1 + y2) / 2;
                    theta = 2.356194490192345 - Math.atan2(y2 - y1, x2 - x1);
                    delta1 = (int)((double)arrowSize * Math.cos(theta));
                    delta2 = (int)((double)arrowSize * Math.sin(theta));
                    g.drawLine(x_m, y_m, x_m + delta1, y_m - delta2);
                    g.drawLine(x_m, y_m, x_m - delta2, y_m - delta1);
                    continue;
                }
                if (!drawMissing || nextEvent.cell == null || lastNonMissingEvent == null) continue;
                g.setColor(Colour.getColour(lastNonMissingEvent.nodeColour, nextEvent.nodeColour));
                g.setStroke(dashStroke);
                x1 = lastNonMissingEvent.randomX;
                y1 = lastNonMissingEvent.randomY;
                x2 = nextEvent.randomX;
                y2 = nextEvent.randomY;
                g.drawLine(x1, y1, x2, y2);
                g.setStroke(solidStroke);
                if (!drawArrows) continue;
                x_m = (x1 + x2) / 2;
                y_m = (y1 + y2) / 2;
                theta = 2.356194490192345 - Math.atan2(y2 - y1, x2 - x1);
                delta1 = (int)((double)arrowSize * Math.cos(theta));
                delta2 = (int)((double)arrowSize * Math.sin(theta));
                g.drawLine(x_m, y_m, x_m + delta1, y_m + delta2);
                g.drawLine(x_m, y_m, x_m + delta2, y_m + delta1);
            }
        } else if (nodeLayout == 1) {
            while (i.hasNext()) {
                int delta2;
                int delta1;
                double theta;
                int y_m;
                int x_m;
                int y2;
                int x2;
                int y1;
                int x1;
                DyadEvent curEvent = nextEvent;
                nextEvent = (DyadEvent)i.next();
                if (!(curEvent.offset > (double)minTime) || !(nextEvent.onset < (double)maxTime)) continue;
                if (curEvent.cell != null) {
                    lastNonMissingEvent = curEvent;
                    if (nextEvent.cell == null) continue;
                    g.setColor(Colour.getColour(curEvent.nodeColour, nextEvent.nodeColour));
                    x1 = curEvent.diagonalX;
                    y1 = curEvent.diagonalY;
                    x2 = nextEvent.diagonalX;
                    y2 = nextEvent.diagonalY;
                    g.drawLine(x1, y1, x2, y2);
                    if (!drawArrows) continue;
                    x_m = (x1 + x2) / 2;
                    y_m = (y1 + y2) / 2;
                    theta = 2.356194490192345 - Math.atan2(y2 - y1, x2 - x1);
                    delta1 = (int)((double)arrowSize * Math.cos(theta));
                    delta2 = (int)((double)arrowSize * Math.sin(theta));
                    g.drawLine(x_m, y_m, x_m + delta1, y_m - delta2);
                    g.drawLine(x_m, y_m, x_m - delta2, y_m - delta1);
                    continue;
                }
                if (!drawMissing || nextEvent.cell == null || lastNonMissingEvent == null) continue;
                g.setColor(Colour.getColour(lastNonMissingEvent.nodeColour, nextEvent.nodeColour));
                g.setStroke(dashStroke);
                x1 = lastNonMissingEvent.diagonalX;
                y1 = lastNonMissingEvent.diagonalY;
                x2 = nextEvent.diagonalX;
                y2 = nextEvent.diagonalY;
                g.drawLine(x1, y1, x2, y2);
                g.setStroke(solidStroke);
                if (!drawArrows) continue;
                x_m = (x1 + x2) / 2;
                y_m = (y1 + y2) / 2;
                theta = 2.356194490192345 - Math.atan2(y2 - y1, x2 - x1);
                delta1 = (int)((double)arrowSize * Math.cos(theta));
                delta2 = (int)((double)arrowSize * Math.sin(theta));
                g.drawLine(x_m, y_m, x_m + delta1, y_m + delta2);
                g.drawLine(x_m, y_m, x_m + delta2, y_m + delta1);
            }
        }
        Colour.disableEquals = false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public void drawNodes(Graphics2D g, int nodeLayout, int minTime, int maxTime) {
        block25: {
            block27: {
                firstNode = true;
                curEvent = null;
                g.setStroke(Trajectory.outlineStroke);
                Colour.disableEquals = true;
                if (nodeLayout != 0) break block27;
                i = this.iterator();
                eventsPostMinTime = false;
                if (true) ** GOTO lbl19
            }
            if (nodeLayout != 1) break block25;
            i = this.iterator();
            eventsPostMinTime = false;
            if (true) ** GOTO lbl66
            do {
                curEvent = (DyadEvent)i.next();
                if (!(curEvent.offset > (double)minTime)) continue;
                eventsPostMinTime = true;
                break;
lbl19:
                // 2 sources

            } while (i.hasNext());
            if (eventsPostMinTime) {
                firstIteration = true;
                do {
                    if (firstIteration) {
                        firstIteration = false;
                    } else {
                        curEvent = (DyadEvent)i.next();
                    }
                    if (curEvent.onset >= (double)maxTime) break block25;
                    if (curEvent.cell == null) continue;
                    if (curEvent.onset < (double)minTime) {
                        trimmedEventOnset = minTime;
                        trimmedEventOffset = Math.min((double)maxTime, curEvent.offset);
                        trimmedEventDuration = trimmedEventOffset - trimmedEventOnset;
                        trimmedNodeWidth = (double)curEvent.randomWidth * trimmedEventDuration / curEvent.duration();
                        trimmedNodeHeight = (double)curEvent.randomHeight * trimmedEventDuration / curEvent.duration();
                        nodeImage = new Ellipse2D.Double((double)curEvent.randomX - trimmedNodeWidth / 2.0, (double)curEvent.randomY - trimmedNodeHeight / 2.0, trimmedNodeWidth, trimmedNodeHeight);
                    } else if (curEvent.offset > (double)maxTime) {
                        trimmedEventOffset = maxTime;
                        trimmedEventDuration = trimmedEventOffset - curEvent.onset;
                        trimmedNodeWidth = (double)curEvent.randomWidth * trimmedEventDuration / curEvent.duration();
                        trimmedNodeHeight = (double)curEvent.randomHeight * trimmedEventDuration / curEvent.duration();
                        nodeImage = new Ellipse2D.Double((double)curEvent.randomX - trimmedNodeWidth / 2.0, (double)curEvent.randomY - trimmedNodeHeight / 2.0, trimmedNodeWidth, trimmedNodeHeight);
                    } else {
                        nodeImage = curEvent.randomImage;
                    }
                    g.setColor(Trajectory.translucentNodes != false ? curEvent.nodeTranslucentColour : curEvent.nodeColour);
                    if (Trajectory.markStartNode && firstNode) {
                        if (!Trajectory.hollowNodes) {
                            g.draw(nodeImage);
                        } else {
                            g.fill(nodeImage);
                        }
                    } else if (Trajectory.hollowNodes) {
                        g.draw(nodeImage);
                    } else {
                        g.fill(nodeImage);
                    }
                    firstNode = false;
                } while (i.hasNext());
            }
            break block25;
            do {
                curEvent = (DyadEvent)i.next();
                if (!(curEvent.offset > (double)minTime)) continue;
                eventsPostMinTime = true;
                break;
lbl66:
                // 2 sources

            } while (i.hasNext());
            if (eventsPostMinTime) {
                firstIteration = true;
                do {
                    if (firstIteration) {
                        firstIteration = false;
                    } else {
                        curEvent = (DyadEvent)i.next();
                    }
                    if (curEvent.onset >= (double)maxTime) break;
                    if (curEvent.cell == null) continue;
                    if (curEvent.onset < (double)minTime) {
                        trimmedEventOnset = minTime;
                        trimmedEventOffset = Math.min((double)maxTime, curEvent.offset);
                        trimmedEventDuration = trimmedEventOffset - trimmedEventOnset;
                        trimmedNodeWidth = (double)curEvent.diagonalWidth * trimmedEventDuration / curEvent.duration();
                        trimmedNodeHeight = (double)curEvent.diagonalHeight * trimmedEventDuration / curEvent.duration();
                        nodeImage = new Ellipse2D.Double((double)curEvent.diagonalX - trimmedNodeWidth / 2.0, (double)curEvent.diagonalY - trimmedNodeHeight / 2.0, trimmedNodeWidth, trimmedNodeHeight);
                    } else if (curEvent.offset > (double)maxTime) {
                        trimmedEventOffset = maxTime;
                        trimmedEventDuration = trimmedEventOffset - curEvent.onset;
                        trimmedNodeWidth = (double)curEvent.diagonalWidth * trimmedEventDuration / curEvent.duration();
                        trimmedNodeHeight = (double)curEvent.diagonalHeight * trimmedEventDuration / curEvent.duration();
                        nodeImage = new Ellipse2D.Double((double)curEvent.diagonalX - trimmedNodeWidth / 2.0, (double)curEvent.diagonalY - trimmedNodeHeight / 2.0, trimmedNodeWidth, trimmedNodeHeight);
                    } else {
                        nodeImage = curEvent.diagonalImage;
                    }
                    g.setColor(Trajectory.translucentNodes != false ? curEvent.nodeTranslucentColour : curEvent.nodeColour);
                    if (Trajectory.hollowNodes) {
                        g.draw(nodeImage);
                        continue;
                    }
                    g.fill(nodeImage);
                } while (i.hasNext());
            }
        }
        Colour.disableEquals = false;
    }

    public void draw(Graphics2D g, int nodeLayout, int minTime, int maxTime) {
        if (drawTransitions) {
            this.drawTransitions(g, nodeLayout, minTime, maxTime);
        }
        if (drawNodes) {
            this.drawNodes(g, nodeLayout, minTime, maxTime);
        }
    }

    public void colourNodes(Colour c, CellSet cells, int minTime, int maxTime) {
        for (DyadEvent curEvent : this) {
            if (!(curEvent.onset < (double)maxTime) || !(curEvent.offset > (double)minTime) || !cells.isEmpty() && !cells.contains(curEvent.cell)) continue;
            curEvent.setColour(c);
        }
    }

    public void save(String folderName) {
        this.path = folderName;
        IOHandler.openOutFile(String.valueOf(this.path) + this.filename);
        StringBuffer output = new StringBuffer();
        output.append("onset");
        for (String curLabel : this.columnLabels) {
            if (curLabel.equals("onset") || curLabel.equals("color") || curLabel.equals("colour") || curLabel.endsWith(" pos")) continue;
            output.append("\t" + curLabel);
        }
        output.append("\tcolour");
        Iterator i = DyadEvent.stateVars.iterator();
        while (i.hasNext()) {
            output.append("\t" + ((Variable)i.next()).toString() + " POS");
        }
        output.append("\n");
        for (DyadEvent curEvent : this) {
            output.append(this.onset + curEvent.onset);
            for (String curLabel : this.columnLabels) {
                if (DyadEvent.isVariable(curLabel)) {
                    Variable curVariable = DyadEvent.getVariable(curLabel);
                    Comparable curValue = curEvent.getValue(curVariable);
                    if (curValue != null) {
                        if (curVariable.saveLabelsNotValues) {
                            output.append("\t" + curVariable.getLabel(curValue));
                            continue;
                        }
                        output.append("\t" + curValue);
                        continue;
                    }
                    output.append("\t" + GridWindow.missingValue);
                    continue;
                }
                if (curLabel.equals("onset") || curLabel.equals("color") || curLabel.equals("colour") || curLabel.endsWith(" pos")) continue;
                output.append("\t" + curEvent.inertValues.remove(0));
            }
            output.append("\t" + curEvent.nodeColour.getRGB());
            int v = 0;
            Iterator j = DyadEvent.stateVars.iterator();
            while (j.hasNext()) {
                output.append("\t" + curEvent.nodePosition[v++]);
                j.next();
            }
            output.append("\n");
        }
        output.append(String.valueOf(this.offset) + "\n");
        IOHandler.printToFile(output.toString());
        IOHandler.closeOutFile();
        System.out.println("Finished writing to file " + this.filename);
    }

    public String toString() {
        return this.filename;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Trajectory)) {
            return false;
        }
        return ((Trajectory)o).path.equals(this.path) && ((Trajectory)o).filename.equals(this.filename);
    }
}

