/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import java.util.EventListener;
import javax.swing.BoundedRangeModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class TwoWayBoundedRangeModel
implements BoundedRangeModel {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int value = 0;
    private int extent = 0;
    private int min = 0;
    private int max = 100;
    private boolean isAdjusting = false;

    public TwoWayBoundedRangeModel() {
    }

    public TwoWayBoundedRangeModel(int value, int extent, int min, int max) {
        if (max < min || value < min || value + extent < min || value + extent > max) {
            throw new IllegalArgumentException("invalid range properties");
        }
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    public int getValue() {
        return this.value;
    }

    public int getExtent() {
        return this.extent;
    }

    public int getMinimum() {
        return this.min;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setValue(int v) {
        int newValue = Math.min(Math.max(v, this.min), this.max);
        int otherValue = this.value + this.extent;
        int newExtent = otherValue - newValue;
        this.setRangeProperties(newValue, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setExtent(int n) {
        int newExtent = n;
        if (this.value + newExtent > this.max) {
            newExtent = this.max - this.value;
        } else if (this.value + newExtent < this.min) {
            newExtent = this.min - this.value;
        }
        this.setRangeProperties(this.value, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setValueAndExtent(int v, int newExtent) {
        int newValue = Math.min(Math.max(v, this.min), this.max);
        if (newValue + newExtent > this.max) {
            newValue = this.max - newExtent;
        } else if (newValue + newExtent < this.min) {
            newValue = this.min - newExtent;
        }
        this.setRangeProperties(newValue, newExtent, this.min, this.max, this.isAdjusting);
    }

    public void setValue(int v, boolean preserveExtent) {
        if (preserveExtent) {
            this.setValueAndExtent(v, this.extent);
        } else {
            this.setValue(v);
        }
    }

    public void setMinimum(int n) {
        int newMax = Math.max(n, this.max);
        int newExtent = Math.max(n - this.value, this.extent);
        int newValue = Math.max(n, this.value);
        newExtent = Math.min(newMax - newValue, newExtent);
        this.setRangeProperties(newValue, newExtent, n, newMax, this.isAdjusting);
    }

    public void setMaximum(int n) {
        int newMin = Math.min(n, this.min);
        int newExtent = Math.min(n - this.value, this.extent);
        int newValue = Math.min(n, this.value);
        newExtent = Math.max(newMin - newValue, newExtent);
        this.setRangeProperties(newValue, newExtent, newMin, n, this.isAdjusting);
    }

    public void setValueIsAdjusting(boolean b) {
        this.setRangeProperties(this.value, this.extent, this.min, this.max, b);
    }

    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    public void setRangeProperties(int newValue, int newExtent, int newMin, int newMax, boolean adjusting) {
        boolean isChange;
        if (newMin > newMax) {
            newMin = newMax;
        }
        if (newValue > newMax) {
            newMax = newValue;
        }
        if (newValue < newMin) {
            newMin = newValue;
        }
        if ((long)newExtent + (long)newValue > (long)newMax) {
            newExtent = newMax - newValue;
        } else if ((long)newExtent + (long)newValue < (long)newMin) {
            newExtent = newMin - newValue;
        }
        boolean bl = isChange = newValue != this.value || newExtent != this.extent || newMin != this.min || newMax != this.max || adjusting != this.isAdjusting;
        if (isChange) {
            this.value = newValue;
            this.extent = newExtent;
            this.min = newMin;
            this.max = newMax;
            this.isAdjusting = adjusting;
            this.fireStateChanged();
        }
    }

    public void flipRange() {
        this.setRangeProperties(this.value + this.extent, -this.extent, this.min, this.max, this.isAdjusting);
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == ChangeListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
            }
            i -= 2;
        }
    }

    public String toString() {
        String modelString = "value=" + this.getValue() + ", " + "extent=" + this.getExtent() + ", " + "min=" + this.getMinimum() + ", " + "max=" + this.getMaximum() + ", " + "adj=" + this.getValueIsAdjusting();
        return String.valueOf(this.getClass().getName()) + "[" + modelString + "]";
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }
}

