/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GridWindow;
import GridWare.HasVariables;
import java.util.Collection;
import java.util.Comparator;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;

public abstract class Variable
implements Comparator {
    String label;
    SortedSet valueSet;
    Vector values;
    SortedMap labelMap;
    boolean valuesFixed = false;
    boolean nonCanonicallyOrdered = false;
    boolean saveLabelsNotValues = false;
    static boolean allowMissingValues = true;

    public Variable(String lbl) {
        this.label = lbl.toLowerCase();
        this.valueSet = new TreeSet();
        this.values = new Vector();
        this.labelMap = new TreeMap();
    }

    public int compare(Object o1, Object o2) {
        Comparable v1 = ((HasVariables)o1).getValue(this);
        Comparable v2 = ((HasVariables)o2).getValue(this);
        if (v1 == null || v2 == null) {
            throw new NullPointerException("Variable \"" + this.label + "\" has no value.");
        }
        return v1.compareTo(v2);
    }

    public abstract boolean validate(Comparable var1);

    public int numValues() {
        return this.valueSet.size();
    }

    public Comparable minValue() {
        return (Comparable)this.valueSet.first();
    }

    public Comparable maxValue() {
        return (Comparable)this.valueSet.last();
    }

    public void addValue(Comparable value) {
        this.addValue(value, value != null ? value.toString() : GridWindow.missingValue);
    }

    public void addValue(Comparable value, String valueLabel) {
        if (this.validate(value) && value != null && !this.valueSet.contains(value)) {
            this.valueSet.add(value);
            this.values.add(value);
            this.setLabel(value, valueLabel);
        }
    }

    public void fixValues() {
        this.valuesFixed = true;
    }

    public Vector getValues() {
        if (this.nonCanonicallyOrdered) {
            return this.values;
        }
        return new Vector(this.valueSet);
    }

    public Collection getLabels() {
        return this.labelMap.values();
    }

    public String getLabel(Comparable value) {
        return (String)this.labelMap.get(value);
    }

    public void setLabel(Comparable value, String label) {
        this.labelMap.put(value, label);
    }

    public int getIndex(Comparable value) {
        if (this.nonCanonicallyOrdered) {
            return this.values.indexOf(value);
        }
        if (value == null) {
            return -1;
        }
        if (this.valueSet.contains(value)) {
            return this.valueSet.headSet(value).size();
        }
        return -1;
    }

    public String toString() {
        return this.label;
    }

    public abstract Comparable valueOf(String var1);
}

