/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.DyadEvent;
import GridWare.IntVariable;
import GridWare.StringVariable;
import GridWare.Trajectory;
import GridWare.Variable;
import GridWare.VariableCreationDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class VariablePanel
extends JPanel
implements ActionListener {
    VariableCreationDialog vCDialog;
    JLabel kindLabel;
    JLabel nameLabel;
    JLabel typeLabel;
    JLabel minLabel;
    JLabel maxLabel;
    JLabel categoriesLabel;
    JComboBox kindChooser;
    JComboBox typeChooser;
    JTextField nameField;
    JTextField minField;
    JTextField maxField;
    JTextField categoriesField;
    JButton removeButton;
    Component xFiller;
    GridBagConstraints c = new GridBagConstraints();
    GridBagLayout gridbag = new GridBagLayout();
    boolean ordinal;

    VariablePanel(VariableCreationDialog vCD, String kind, String type, String name) {
        this.vCDialog = vCD;
        String[] kindStrings = new String[]{"Trajectory", "State"};
        this.kindChooser = new JComboBox<String>(kindStrings);
        if (kind != null) {
            this.kindChooser.setSelectedItem(kind);
        }
        String[] typeStrings = new String[]{"Ordinal", "Categorical"};
        this.typeChooser = new JComboBox<String>(typeStrings);
        if (type != null) {
            this.typeChooser.setSelectedItem(type);
        }
        this.ordinal = ((String)this.typeChooser.getSelectedItem()).equals("Ordinal");
        this.typeChooser.addActionListener(this);
        this.nameLabel = new JLabel(" Name:");
        this.nameField = new JTextField(10);
        this.minLabel = new JLabel(" Minimum:");
        this.minField = new JTextField(4);
        this.maxLabel = new JLabel(" Maximum:");
        this.maxField = new JTextField(4);
        this.categoriesLabel = new JLabel(" Categories:");
        this.categoriesField = new JTextField(16);
        this.removeButton = new JButton("Remove");
        this.removeButton.addActionListener(this);
        this.setLayout(this.gridbag);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.gridwidth = 1;
        this.c.gridheight = 1;
        this.c.weightx = 0.0;
        this.c.weighty = 0.0;
        this.c.anchor = 17;
        this.c.fill = 0;
        this.gridbag.setConstraints(this.kindChooser, this.c);
        this.add(this.kindChooser);
        this.c.anchor = 17;
        this.c.gridx = 1;
        this.gridbag.setConstraints(this.typeChooser, this.c);
        this.add(this.typeChooser);
        this.c.anchor = 13;
        this.c.gridx = 2;
        this.gridbag.setConstraints(this.nameLabel, this.c);
        this.add(this.nameLabel);
        if (name != null) {
            this.nameField.setText(name);
        }
        this.c.anchor = 17;
        this.c.gridx = 3;
        this.gridbag.setConstraints(this.nameField, this.c);
        this.add(this.nameField);
        if (this.ordinal) {
            this.c.anchor = 13;
            this.c.gridx = 4;
            this.gridbag.setConstraints(this.minLabel, this.c);
            this.add(this.minLabel);
            this.c.anchor = 17;
            this.c.gridx = 5;
            this.gridbag.setConstraints(this.minField, this.c);
            this.add(this.minField);
            this.c.anchor = 13;
            this.c.gridx = 6;
            this.gridbag.setConstraints(this.maxLabel, this.c);
            this.add(this.maxLabel);
            this.c.anchor = 17;
            this.c.gridx = 7;
            this.gridbag.setConstraints(this.maxField, this.c);
            this.add(this.maxField);
        } else {
            this.c.anchor = 13;
            this.c.gridx = 4;
            this.gridbag.setConstraints(this.categoriesLabel, this.c);
            this.add(this.categoriesLabel);
            this.c.anchor = 17;
            this.c.gridx = 5;
            this.c.gridwidth = 3;
            this.c.weightx = 1.0;
            this.gridbag.setConstraints(this.categoriesField, this.c);
            this.add(this.categoriesField);
            this.c.gridwidth = 1;
            this.c.weightx = 0.0;
        }
        this.c.anchor = 13;
        this.c.gridx = 8;
        this.c.weightx = this.ordinal ? 1.0 : 0.0;
        this.gridbag.setConstraints(this.removeButton, this.c);
        this.add(this.removeButton);
        this.c.weightx = 0.0;
    }

    public void ordinalToCategorical() {
        if (this.ordinal) {
            this.vCDialog.setVisible(false);
            this.remove(this.maxField);
            this.remove(this.maxLabel);
            this.remove(this.minField);
            this.remove(this.minLabel);
            this.remove(this.removeButton);
            this.ordinal = false;
            this.c.anchor = 13;
            this.c.gridx = 4;
            this.gridbag.setConstraints(this.categoriesLabel, this.c);
            this.add(this.categoriesLabel);
            this.c.anchor = 17;
            this.c.gridx = 5;
            this.c.gridwidth = 3;
            this.c.weightx = 1.0;
            this.gridbag.setConstraints(this.categoriesField, this.c);
            this.add(this.categoriesField);
            this.c.gridwidth = 1;
            this.c.weightx = 0.0;
            this.c.anchor = 13;
            this.c.gridx = 8;
            this.gridbag.setConstraints(this.removeButton, this.c);
            this.add(this.removeButton);
            this.validate();
            this.vCDialog.pack();
            this.typeChooser.setEnabled(true);
            this.setEnabled(true);
            this.vCDialog.setEnabled(true);
            this.vCDialog.setVisible(true);
        }
    }

    public void categoricalToOrdinal() {
        if (!this.ordinal) {
            this.vCDialog.setVisible(false);
            this.remove(this.categoriesField);
            this.remove(this.categoriesLabel);
            this.remove(this.removeButton);
            this.ordinal = true;
            this.c.anchor = 13;
            this.c.gridx = 4;
            this.gridbag.setConstraints(this.minLabel, this.c);
            this.add(this.minLabel);
            this.c.anchor = 17;
            this.c.gridx = 5;
            this.gridbag.setConstraints(this.minField, this.c);
            this.add(this.minField);
            this.c.anchor = 13;
            this.c.gridx = 6;
            this.gridbag.setConstraints(this.maxLabel, this.c);
            this.add(this.maxLabel);
            this.c.anchor = 17;
            this.c.gridx = 7;
            this.gridbag.setConstraints(this.maxField, this.c);
            this.add(this.maxField);
            this.c.anchor = 13;
            this.c.gridx = 8;
            this.c.weightx = 1.0;
            this.gridbag.setConstraints(this.removeButton, this.c);
            this.add(this.removeButton);
            this.c.weightx = 0.0;
            this.validate();
            this.vCDialog.pack();
            this.typeChooser.setEnabled(true);
            this.setEnabled(true);
            this.vCDialog.setEnabled(true);
            this.vCDialog.setVisible(true);
        }
    }

    public void actionPerformed(ActionEvent newEvent) {
        JComponent source = (JComponent)newEvent.getSource();
        if (source == this.removeButton) {
            this.vCDialog.mainPanel.remove(this);
            this.vCDialog.variables.remove(this);
            this.vCDialog.pack();
        } else if (source == this.typeChooser) {
            String selectedType = (String)this.typeChooser.getSelectedItem();
            if (selectedType.equals("Categorical")) {
                this.ordinalToCategorical();
            } else if (selectedType.equals("Ordinal")) {
                this.categoricalToOrdinal();
            }
        }
    }

    public void createVariable() {
        Variable newVariable = null;
        String varName = this.nameField.getText();
        String varKind = (String)this.kindChooser.getSelectedItem();
        String varType = (String)this.typeChooser.getSelectedItem();
        if (varKind.equals("Trajectory")) {
            if (varType.equals("Ordinal")) {
                try {
                    int min = Integer.parseInt(this.minField.getText());
                    int max = Integer.parseInt(this.maxField.getText());
                    newVariable = new IntVariable(varName, min, max);
                }
                catch (NumberFormatException ex) {
                    newVariable = new IntVariable(varName);
                }
            } else if (varType.equals("Categorical")) {
                String categories = this.categoriesField.getText();
                newVariable = categories.equals("") ? new StringVariable(varName) : new StringVariable(varName, categories);
            }
            Trajectory.addTrajectoryVariable(newVariable);
        } else if (varKind.equals("State")) {
            if (varType.equals("Ordinal")) {
                try {
                    int min = Integer.parseInt(this.minField.getText());
                    int max = Integer.parseInt(this.maxField.getText());
                    newVariable = new IntVariable(varName, min, max);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Minimum and maximum required for ordinal state variables.");
                }
            } else if (varType.equals("Categorical")) {
                String categories = this.categoriesField.getText();
                if (categories.equals("")) {
                    throw new IllegalArgumentException("Categories required for categorical state variables.");
                }
                newVariable = new StringVariable(varName, categories);
            }
            DyadEvent.addStateVariable(newVariable);
        }
    }
}

