/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.Colour;
import GridWare.GWSlider;
import com.sun.java.swing.plaf.windows.WindowsSliderUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowsGWSliderUI
extends WindowsSliderUI {
    protected boolean filledSlider = true;
    private transient boolean isDragging;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsGWSliderUI((GWSlider)c);
    }

    public WindowsGWSliderUI() {
        super(null);
    }

    public WindowsGWSliderUI(JSlider b) {
        super(b);
    }

    public void installUI(JComponent c) {
        this.isDragging = false;
        super.installUI(c);
        this.installKeyboardActions(this.slider);
    }

    protected void installKeyboardActions(JSlider slider) {
        InputMap km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(slider, 0, km);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(slider, am);
    }

    InputMap getInputMap(int condition) {
        if (condition == 0) {
            InputMap keyMap = new InputMap();
            keyMap.put(KeyStroke.getKeyStroke(39, 0), "positiveUnitIncrementBothThumbs");
            keyMap.put(KeyStroke.getKeyStroke(37, 0), "negativeUnitIncrementBothThumbs");
            keyMap.put(KeyStroke.getKeyStroke(39, 8), "positiveUnitIncrementOneThumb");
            keyMap.put(KeyStroke.getKeyStroke(37, 8), "negativeUnitIncrementOneThumb");
            keyMap.put(KeyStroke.getKeyStroke(39, 1), "positiveBlockIncrementBothThumbs");
            keyMap.put(KeyStroke.getKeyStroke(37, 1), "negativeBlockIncrementBothThumbs");
            keyMap.put(KeyStroke.getKeyStroke(39, 9), "positiveBlockIncrementOneThumb");
            keyMap.put(KeyStroke.getKeyStroke(37, 9), "negativeBlockIncrementOneThumb");
            return keyMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("Slider.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Slider.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("positiveUnitIncrementOneThumb", new SharedActionScroller(1, false, false));
        map.put("positiveBlockIncrementOneThumb", new SharedActionScroller(1, true, false));
        map.put("negativeUnitIncrementOneThumb", new SharedActionScroller(-1, false, false));
        map.put("negativeBlockIncrementOneThumb", new SharedActionScroller(-1, true, false));
        map.put("minScrollOneThumb", new SharedActionScroller(-2, true, false));
        map.put("maxScrollOneThumb", new SharedActionScroller(2, true, false));
        map.put("positiveUnitIncrementBothThumbs", new SharedActionScroller(1, false, true));
        map.put("positiveBlockIncrementBothThumbs", new SharedActionScroller(1, true, true));
        map.put("negativeUnitIncrementBothThumbs", new SharedActionScroller(-1, false, true));
        map.put("negativeBlockIncrementBothThumbs", new SharedActionScroller(-1, true, true));
        map.put("minScrollBothThumbs", new SharedActionScroller(-2, true, true));
        map.put("maxScrollBothThumbs", new SharedActionScroller(2, true, true));
        return map;
    }

    protected void uninstallKeyboardActions(JSlider slider) {
        SwingUtilities.replaceUIActionMap(slider, null);
        SwingUtilities.replaceUIInputMap(slider, 0, null);
    }

    protected ChangeListener createChangeListener(JSlider slider) {
        return new GWChangeHandler();
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new GWTrackListener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = this.slider.getValue();
            int blockIncrement = Math.abs(this.slider.getExtent()) + 1;
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            ((GWSlider)this.slider).setValue(oldValue + delta, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction, boolean preserveExtent) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = this.slider.getValue();
            int blockIncrement = Math.abs(this.slider.getExtent()) + 1;
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            ((GWSlider)this.slider).setValue(oldValue + delta, preserveExtent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = this.slider.getValue();
            int delta = 1 * (direction > 0 ? 1 : -1);
            ((GWSlider)this.slider).setValue(oldValue + delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction, boolean preserveExtent) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int oldValue = this.slider.getValue();
            int delta = 1 * (direction > 0 ? 1 : -1);
            ((GWSlider)this.slider).setValue(oldValue + delta, preserveExtent);
        }
    }

    protected void scrollDueToClickInTrack(int dir) {
        this.scrollByBlock(dir);
    }

    public void paintTrack(Graphics g) {
        boolean leftToRight = true;
        int trackLeft = 0;
        int trackTop = 0;
        int trackWidth = 0;
        int trackHeight = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.slider.getOrientation() == 0) {
            trackLeft = this.trackRect.x;
            trackHeight = this.trackRect.height;
            trackBottom = trackHeight - 1 - this.getThumbOverhang();
            trackWidth = this.getTrackWidth();
            trackTop = trackBottom - (trackWidth - 1);
            trackRight = trackWidth - 1;
        }
        g.translate(trackLeft, trackTop);
        if (this.filledSlider) {
            boolean middleOfThumb = false;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            if (this.slider.getOrientation() == 0) {
                int valuePosition = this.xPositionForValue(this.slider.getValue());
                int valuePlusExtentPosition = this.xPositionForValue(this.slider.getValue() + this.slider.getExtent());
                fillLeft = Math.min(valuePosition, valuePlusExtentPosition);
                fillRight = Math.max(valuePosition, valuePlusExtentPosition);
                fillLeft -= trackLeft;
                fillRight -= trackLeft;
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
            } else {
                int valuePosition = this.yPositionForValue(this.slider.getValue());
                int valuePlusExtentPosition = this.yPositionForValue(this.slider.getValue() + this.slider.getExtent());
                fillTop = Math.min(valuePosition, valuePlusExtentPosition);
                fillBottom = Math.max(valuePosition, valuePlusExtentPosition);
                fillTop -= this.trackRect.x;
                fillBottom -= this.trackRect.x;
                fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                int n = fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
            }
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getBackground());
                g.drawLine(fillLeft, fillTop, fillRight, fillTop);
                g.drawLine(fillLeft, fillTop, fillLeft, fillBottom);
                g.setColor(Colour.getColour(new Color(134, 158, 255, 192)));
                g.fillRoundRect(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop, fillBottom - fillTop, fillBottom - fillTop);
            } else {
                g.setColor(Colour.getColour(new Color(134, 158, 255, 192)));
                g.fillRoundRect(fillLeft, fillTop, fillRight - fillLeft, trackBottom - trackTop, fillBottom - fillTop, fillBottom - fillTop);
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    protected int getTrackWidth() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.height;
        }
        return this.trackRect.width;
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return (int)(this.getThumbSize().getHeight() - (double)this.getTrackWidth()) / 2;
    }

    static /* synthetic */ void access$1(WindowsGWSliderUI windowsGWSliderUI) {
        ((BasicSliderUI)((Object)windowsGWSliderUI)).calculateThumbLocation();
    }

    static /* synthetic */ boolean access$6(WindowsGWSliderUI windowsGWSliderUI) {
        return ((BasicSliderUI)((Object)windowsGWSliderUI)).drawInverted();
    }

    static /* synthetic */ int access$9(WindowsGWSliderUI windowsGWSliderUI, int n) {
        return ((BasicSliderUI)((Object)windowsGWSliderUI)).yPositionForValue(n);
    }

    static /* synthetic */ int access$10(WindowsGWSliderUI windowsGWSliderUI, int n) {
        return ((BasicSliderUI)((Object)windowsGWSliderUI)).xPositionForValue(n);
    }

    public class GWChangeHandler
    extends BasicSliderUI.ChangeHandler {
        public GWChangeHandler() {
            super((BasicSliderUI)((Object)WindowsGWSliderUI.this));
        }

        public void stateChanged(ChangeEvent e) {
            if (!WindowsGWSliderUI.this.isDragging) {
                WindowsGWSliderUI.access$1(WindowsGWSliderUI.this);
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.repaint();
            }
        }
    }

    protected class GWTrackListener
    extends BasicSliderUI.TrackListener {
        protected GWTrackListener() {
            super((BasicSliderUI)((Object)WindowsGWSliderUI.this));
        }

        public void mouseReleased(MouseEvent e) {
            if (!((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).scrollTimer.stop();
            if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getSnapToTicks()) {
                WindowsGWSliderUI.this.isDragging = false;
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.setValueIsAdjusting(false);
            } else {
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.setValueIsAdjusting(false);
                WindowsGWSliderUI.this.isDragging = false;
            }
            ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.repaint();
        }

        public void mousePressed(MouseEvent e) {
            boolean maintainExtent;
            if (!((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.isRequestFocusEnabled()) {
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.requestFocus();
            }
            boolean bl = maintainExtent = !e.isAltDown();
            if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.x;
                    }
                }
                WindowsGWSliderUI.this.isDragging = true;
                return;
            }
            WindowsGWSliderUI.this.isDragging = false;
            ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.setValueIsAdjusting(true);
            Dimension sbSize = ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getSize();
            int direction = 1;
            switch (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getOrientation()) {
                case 1: {
                    int scrollbarCenter;
                    if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.height / 2;
                        if (!WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                            direction = this.currentMouseY < scrollbarCenter ? 1 : -1;
                            break;
                        }
                        direction = this.currentMouseY < scrollbarCenter ? -1 : 1;
                        break;
                    }
                    int thumbY = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.y;
                    if (!WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                        direction = this.currentMouseY < thumbY ? 1 : -1;
                        break;
                    }
                    direction = this.currentMouseY < thumbY ? -1 : 1;
                    break;
                }
                case 0: {
                    int scrollbarCenter;
                    if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).thumbRect.isEmpty()) {
                        scrollbarCenter = sbSize.width / 2;
                        if (!WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                            direction = this.currentMouseX < scrollbarCenter ? -1 : 1;
                            break;
                        }
                        direction = this.currentMouseX < scrollbarCenter ? 1 : -1;
                        break;
                    }
                    int thumbX = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.x;
                    if (!WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                        direction = this.currentMouseX < thumbX ? -1 : 1;
                        break;
                    }
                    int n = direction = this.currentMouseX < thumbX ? 1 : -1;
                }
            }
            if (e.isAltDown() && e.isShiftDown()) {
                WindowsGWSliderUI.this.scrollByUnit(direction, true);
            } else if (e.isAltDown()) {
                WindowsGWSliderUI.this.scrollByUnit(direction, false);
            } else if (e.isShiftDown()) {
                WindowsGWSliderUI.this.scrollByBlock(direction, true);
            } else {
                WindowsGWSliderUI.this.scrollByUnit(direction, true);
            }
            Rectangle r = ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).thumbRect;
            if (!r.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(direction)) {
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).scrollTimer.stop();
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).scrollListener.setDirection(direction);
                ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).scrollTimer.start();
            }
        }

        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!WindowsGWSliderUI.this.isDragging) {
                return;
            }
            boolean maintainExtent = !e.isAltDown();
            ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.setValueIsAdjusting(true);
            int extent = ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getExtent();
            switch (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.y;
                    int trackBottom = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.y + (((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.height - 1);
                    int vMin = 0;
                    int vMax = 0;
                    if (!maintainExtent || extent == 0) {
                        vMin = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum());
                        vMax = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum());
                    } else if (extent > 0) {
                        vMin = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum());
                        vMax = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum() - extent);
                    } else if (extent < 0) {
                        vMin = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum() - extent);
                        vMax = WindowsGWSliderUI.access$9(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum());
                    }
                    if (WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                        trackBottom = vMax;
                        trackTop = vMin;
                    } else {
                        trackBottom = vMin;
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    WindowsGWSliderUI.this.setThumbLocation(((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.x, thumbTop);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    ((GWSlider)((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider).setValue(WindowsGWSliderUI.this.valueForYPosition(thumbMiddle), maintainExtent);
                    break;
                }
                case 0: {
                    int halfThumbWidth = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.x;
                    int trackRight = ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.x + (((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).trackRect.width - 1);
                    int hMin = 0;
                    int hMax = 0;
                    if (!maintainExtent || extent == 0) {
                        hMin = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum());
                        hMax = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum());
                    } else if (extent > 0) {
                        hMin = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum());
                        hMax = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum() - extent);
                    } else if (extent < 0) {
                        hMin = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum() - extent);
                        hMax = WindowsGWSliderUI.access$10(WindowsGWSliderUI.this, ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum());
                    }
                    if (WindowsGWSliderUI.access$6(WindowsGWSliderUI.this)) {
                        trackLeft = hMax;
                        trackRight = hMin;
                    } else {
                        trackLeft = hMin;
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    WindowsGWSliderUI.this.setThumbLocation(thumbLeft, ((BasicSliderUI)((Object)((WindowsGWSliderUI)WindowsGWSliderUI.this))).thumbRect.y);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    ((GWSlider)((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider).setValue(WindowsGWSliderUI.this.valueForXPosition(thumbMiddle), maintainExtent);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        public boolean shouldScroll(int direction) {
            Rectangle r = ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).thumbRect;
            if (((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getOrientation() == 1 ? ((WindowsGWSliderUI.access$6(WindowsGWSliderUI.this) ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((WindowsGWSliderUI.access$6(WindowsGWSliderUI.this) ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getValue() >= ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMaximum()) {
                return false;
            }
            return direction >= 0 || ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getValue() > ((BasicSliderUI)((Object)WindowsGWSliderUI.this)).slider.getMinimum();
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = false;
        }

        public ScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.useBlockIncrement) {
                WindowsGWSliderUI.this.scrollByBlock(this.direction);
            } else {
                WindowsGWSliderUI.this.scrollByUnit(this.direction);
            }
            if (!((BasicSliderUI)((Object)WindowsGWSliderUI.this)).trackListener.shouldScroll(this.direction)) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;
        boolean preserveExtent;

        public SharedActionScroller(int dir, boolean block, boolean preserveExtent) {
            this.dir = dir;
            this.block = block;
            this.preserveExtent = preserveExtent;
        }

        public void actionPerformed(ActionEvent e) {
            GWSlider slider = (GWSlider)e.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int realDir = this.dir;
                WindowsGWSliderUI ui = (WindowsGWSliderUI)((Object)slider.getUI());
                if (slider.getInverted()) {
                    int n = realDir = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    ui.scrollByBlock(realDir, this.preserveExtent);
                } else {
                    ui.scrollByUnit(realDir, this.preserveExtent);
                }
            } else if (slider.getInverted()) {
                if (this.dir == -2) {
                    slider.setValue(slider.getMaximum(), this.preserveExtent);
                } else if (this.dir == 2) {
                    slider.setValue(slider.getMinimum(), this.preserveExtent);
                }
            } else if (this.dir == -2) {
                slider.setValue(slider.getMinimum(), this.preserveExtent);
            } else if (this.dir == 2) {
                slider.setValue(slider.getMaximum(), this.preserveExtent);
            }
        }
    }
}

