/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GridWindow;
import GridWare.VTextIcon;
import GridWare.ValueLabel;
import GridWare.Variable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class YAxis
extends JPanel {
    Variable variable;
    String axisString;
    Vector categoryValues;
    int numCategories;
    ValueLabel[] categoryLabels;
    JLabel axisLabel;
    JPanel labelPanel;
    Font axisFont = new Font("sansserif", 1, 20);
    Font categoryFont = new Font("sansserif", 0, 18);
    GridBagConstraints constraints = new GridBagConstraints();
    GridBagLayout layout = new GridBagLayout();

    public YAxis(Variable var) {
        this.variable = var;
        this.axisString = String.valueOf(this.variable.label.substring(0, 1).toUpperCase()) + this.variable.label.substring(1);
        this.categoryValues = this.variable.getValues();
        this.numCategories = this.categoryValues.size();
        this.setLayout(this.layout);
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 3;
        this.constraints.anchor = 17;
        this.constraints.gridheight = this.numCategories;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.axisLabel = new JLabel();
        this.axisLabel.setFont(this.axisFont);
        this.axisLabel.setVerticalAlignment(0);
        this.axisLabel.setHorizontalAlignment(2);
        this.layout.setConstraints(this.axisLabel, this.constraints);
        this.add(this.axisLabel);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridLayout(this.numCategories, 1));
        this.categoryLabels = new ValueLabel[this.numCategories];
        Iterator values = this.categoryValues.iterator();
        int l = 0;
        while (l < this.numCategories) {
            Comparable value = (Comparable)values.next();
            this.categoryLabels[l] = new ValueLabel(value);
            this.categoryLabels[l].setFont(this.categoryFont);
            this.categoryLabels[l].setIcon(new VTextIcon(this.categoryLabels[l], this.variable.getLabel(value), 2, true));
            this.categoryLabels[l].setHorizontalAlignment(4);
            this.categoryLabels[l].addMouseListener(GridWindow.cellListener);
            ++l;
        }
        l = this.numCategories;
        while (l > 0) {
            this.labelPanel.add(this.categoryLabels[l - 1]);
            --l;
        }
        this.constraints.gridx = 1;
        this.constraints.gridy = 0;
        this.constraints.fill = 3;
        this.constraints.anchor = 17;
        this.constraints.gridheight = this.numCategories;
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 1.0;
        this.layout.setConstraints(this.labelPanel, this.constraints);
        this.add(this.labelPanel);
        this.axisLabel.setIcon(new VTextIcon(this.axisLabel, this.axisString, 2, false));
    }

    public void updateLabels() {
        int l = 0;
        while (l < this.numCategories) {
            this.categoryLabels[l].setIcon(new VTextIcon(this.categoryLabels[l], this.variable.getLabel(this.categoryLabels[l].value), 2, true));
            ++l;
        }
        this.adjustCategoryLabelSize();
        this.repaint();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.adjustCategoryLabelSize();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.adjustCategoryLabelSize();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.adjustCategoryLabelSize();
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.adjustCategoryLabelSize();
    }

    public void adjustCategoryLabelSize() {
        Dimension d = this.getSize();
        int valueLabelWidth = (int)Math.floor(d.getWidth() / 2.0);
        int valueLabelHeight = (int)Math.floor(d.getHeight() / (double)this.numCategories);
        Font font = null;
        int fontSize = 18;
        boolean shrunkFont = false;
        d.setSize(valueLabelWidth, valueLabelHeight);
        int l = 0;
        while (l < this.numCategories) {
            this.categoryLabels[l].setPreferredSize(d);
            this.categoryLabels[l].setSize(d);
            font = this.categoryLabels[l].getFont().deriveFont((float)fontSize);
            this.categoryLabels[l].setFont(font);
            this.categoryLabels[l].setIcon(new VTextIcon(this.categoryLabels[l], this.variable.getLabel(this.categoryLabels[l].value), 2, true));
            while (!((VTextIcon)this.categoryLabels[l].getIcon()).recalcDimensions() && fontSize >= 12) {
                font = font.deriveFont((float)(--fontSize));
                shrunkFont = true;
                this.categoryLabels[l].setIcon(new VTextIcon(this.categoryLabels[l], this.variable.getLabel(this.categoryLabels[l].value), 2, true));
            }
            ++l;
        }
        if (shrunkFont) {
            int m = 0;
            while (m < this.numCategories) {
                this.categoryLabels[m].setFont(font);
                this.categoryLabels[m].setIcon(new VTextIcon(this.categoryLabels[m], this.variable.getLabel(this.categoryLabels[m].value), 2, true));
                this.categoryLabels[m].invalidate();
                ++m;
            }
        }
        this.validate();
    }
}

