/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellPanel;
import GridWare.CellSet;
import GridWare.DyadEvent;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.TSort;
import GridWare.Trajectory;
import GridWare.TrajectorySet;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeSet;

public class testGridWare {
    static PrintStream stdout = System.out;

    public static void main(String[] args) {
        boolean TEST_ALL = false;
        boolean TEST_OVERALL = false;
        boolean TEST_REGION = false;
        boolean TEST_INDIVIDUAL = false;
        String[] test_input = new String[1];
        if (args.length > 2) {
            stdout.println("TOO MANY ARGUMENTS ONLY 2 or NO ARGUMENT is NEEDED");
            System.exit(0);
        } else if (args.length == 2) {
            String option = args[0];
            if (option.equalsIgnoreCase("ALL")) {
                TEST_ALL = true;
            } else if (option.equalsIgnoreCase("Overall")) {
                TEST_OVERALL = true;
            } else if (option.equalsIgnoreCase("Region")) {
                TEST_REGION = true;
            } else if (option.equalsIgnoreCase("Individual")) {
                TEST_INDIVIDUAL = true;
            } else {
                stdout.println("Unknown option: " + option);
                stdout.println("Available options are: all | overall | region | individual");
                System.exit(0);
            }
        } else {
            stdout.println("MISSING OPTION: Available options are: all | overall | region | individual");
            System.exit(0);
        }
        test_input[0] = args.length == 2 ? args[1] : String.valueOf(System.getProperty("user.dir")) + "\\test\\Example 2\\Example.gwf";
        GridWare TestingGW = new GridWare();
        GridWare.main(test_input);
        while (!GridWare.readyToMeasure) {
        }
        GridWare.gridWindow.takeMeasures();
        TrajectorySet data = GridWare.measures.trajectories;
        for (Trajectory test : data) {
            stdout.println(test.filename);
            for (DyadEvent curEvent : test) {
                stdout.println("ONSET: " + curEvent.onset);
                stdout.println("OFFSET: " + curEvent.offset);
                stdout.println("Current X: " + curEvent.getValueIndex(GridWindow.xVariable));
                stdout.println("Current Y: " + curEvent.getValueIndex(GridWindow.yVariable) + "\n");
            }
        }
        if (TEST_ALL || TEST_OVERALL) {
            testGridWare.printOverallData(data);
        }
        TreeSet<Trajectory> sortedSet = new TreeSet<Trajectory>(new TSort());
        if (TEST_INDIVIDUAL || TEST_ALL) {
            Iterator<Object> it = data.iterator();
            stdout.println("INDIVIDUAL CALCULATION RESULT");
            while (it.hasNext()) {
                Trajectory temp = (Trajectory)it.next();
                sortedSet.add(temp);
            }
            for (Trajectory temp : sortedSet) {
                testGridWare.printIndividualData(temp);
            }
        }
        if (TEST_REGION || TEST_ALL) {
            testGridWare.selectRegion(TestingGW);
            testGridWare.printRegionData(data);
        }
        TestingGW.quit(false);
    }

    private static void printOverallData(TrajectorySet data) {
        stdout.println("OVERALL CALCULATION RESULT");
        stdout.println("size\t\t\t" + data.size());
        stdout.println("missing duration\t" + data.missingDuration);
        stdout.println("missing event\t\t" + data.missingEvents);
        stdout.println("duration\t\t" + data.duration);
        stdout.println("# of events\t\t" + data.numEvents);
        stdout.println("# of visits\t\t" + data.numVisits);
        stdout.println("mean range\t\t" + data.meanRange);
        stdout.println("overall range\t\t" + data.overallRange);
        stdout.println("dispersion\t\t" + data.dispersion + "\r\n");
    }

    private static void printRegionData(TrajectorySet data) {
        stdout.println("REGIONAL CALCULATION RESULT");
        stdout.println("size\t\t\t" + data.regionSize);
        stdout.println("duration\t\t" + data.regionDuration);
        stdout.println("# of events\t\t" + data.regionEvents);
        stdout.println("# of visits\t\t" + data.regionVisits);
        stdout.println("mean range\t\t" + data.regionMeanRange);
        stdout.println("overall range\t\t" + data.regionOverallRange);
        stdout.println("dispersion\t\t" + data.regionDispersion);
        stdout.println("duration per event\t" + data.regionDurPerEvent);
        stdout.println("duration per visit\t" + data.regionDurPerVisit);
        stdout.println("duration per cell\t" + data.regionDurPerCell);
        stdout.println("first entry\t\t" + data.regionFirstEntry);
        stdout.println("last exit\t\t" + data.regionLastExit);
        stdout.println("mean return time\t" + data.regionReturnTime);
        stdout.println("mean return visit\t" + data.regionReturnVisits + "\r\n");
    }

    private static void printIndividualData(Trajectory data) {
        stdout.println("filename: " + data.filename);
        stdout.println("size\t\t\t" + data.size());
        stdout.println("duration\t\t" + data.duration);
        stdout.println("# of events\t\t" + data.numEvents);
        stdout.println("# of visits\t\t" + data.numVisits);
        stdout.println("cell range\t\t" + data.cellRange);
        stdout.println("dispersion\t\t" + data.dispersion);
        stdout.println("duration per event\t" + data.durPerEvent);
        stdout.println("duration per visit\t" + data.durPerVisit);
        stdout.println("duration per cell\t" + data.durPerCell + "\r\n");
    }

    private static void selectRegion(GridWare GW) {
        int num_col = GridWindow.numCols;
        int num_row = GridWindow.numRows;
        CellSet selectedCells = GridWindow.selectedCells;
        int x = 0;
        int y = 0;
        int slope = num_row / num_col;
        while (x < num_col) {
            y = num_row - x * slope - 1;
            CellPanel cell = GridWindow.cells[x][x * slope];
            selectedCells.add(cell);
            stdout.println("Cell[" + x + "]" + "[" + x * slope + "] - selected");
            cell = GridWindow.cells[x][y];
            selectedCells.add(cell);
            stdout.println("Cell[" + x + "]" + "[" + y + "] - selected");
            ++x;
        }
        GridWindow.takeMeasures();
    }
}

