/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellSet;
import GridWare.GridWindow;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CellPanel
extends JPanel {
    int x;
    int y;
    boolean selected;

    public CellPanel(int x, int y, Color bgc, Dimension size, MouseListener listener) {
        this.x = x;
        this.y = y;
        this.setBackground(bgc);
        this.setPreferredSize(size);
        this.addMouseListener(listener);
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
        this.setBorder();
    }

    public void setBorder(boolean top, boolean left, boolean bottom, boolean right) {
        this.setBorder(BorderFactory.createMatteBorder(top ? 3 : 0, left ? 3 : 0, bottom ? 3 : 0, right ? 3 : 0, Color.yellow));
    }

    public void setBorder() {
        if (this.selected) {
            CellPanel northCell = GridWindow.getCell(this.x, this.y + 1);
            CellPanel eastCell = GridWindow.getCell(this.x + 1, this.y);
            CellPanel southCell = GridWindow.getCell(this.x, this.y - 1);
            CellPanel westCell = GridWindow.getCell(this.x - 1, this.y);
            boolean northBorder = northCell == null || !northCell.getSelected();
            boolean eastBorder = eastCell == null || !eastCell.getSelected();
            boolean southBorder = southCell == null || !southCell.getSelected();
            boolean westBorder = westCell == null || !westCell.getSelected();
            this.setBorder(northBorder, westBorder, southBorder, eastBorder);
        } else {
            this.setBorder(false, false, false, false);
        }
    }

    public void setBorder(Object[] regions) {
        boolean northBorder = false;
        boolean eastBorder = false;
        boolean southBorder = false;
        boolean westBorder = false;
        if (this.selected) {
            CellPanel northCell = GridWindow.getCell(this.x, this.y + 1);
            CellPanel eastCell = GridWindow.getCell(this.x + 1, this.y);
            CellPanel southCell = GridWindow.getCell(this.x, this.y - 1);
            CellPanel westCell = GridWindow.getCell(this.x - 1, this.y);
            if (northCell == null) {
                northBorder = true;
            }
            if (eastCell == null) {
                eastBorder = true;
            }
            if (southCell == null) {
                southBorder = true;
            }
            if (westCell == null) {
                westBorder = true;
            }
            int i = 0;
            while (i < regions.length) {
                CellSet curRegion = (CellSet)regions[i];
                if (curRegion.contains(this) && !curRegion.contains(northCell)) {
                    northBorder = true;
                }
                if (curRegion.contains(this) && !curRegion.contains(eastCell)) {
                    eastBorder = true;
                }
                if (curRegion.contains(this) && !curRegion.contains(southCell)) {
                    southBorder = true;
                }
                if (curRegion.contains(this) && !curRegion.contains(westCell)) {
                    westBorder = true;
                }
                ++i;
            }
        }
        this.setBorder(northBorder, westBorder, southBorder, eastBorder);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public String toString() {
        String xLabel = GridWindow.xVariable.getLabel((Comparable)GridWindow.xVariable.values.get(this.x));
        String yLabel = GridWindow.yVariable.getLabel((Comparable)GridWindow.yVariable.values.get(this.y));
        return String.valueOf(xLabel) + "," + yLabel;
    }
}

