/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellPanel;
import GridWare.Colour;
import GridWare.GridWindow;
import GridWare.HasVariables;
import GridWare.Trajectory;
import GridWare.Variable;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DyadEvent
implements HasVariables {
    Trajectory trajectory;
    static List stateVars;
    List inertValues;
    static Map stateVariables;
    static boolean variablesFixed;
    double onset;
    double offset;
    Comparable[] state;
    CellPanel cell;
    double dX;
    double dY;
    double diagonalPosition;
    double randomSize = 0.1;
    double diagonalSize;
    int randomX;
    int randomY;
    int diagonalX;
    int diagonalY;
    int randomHeight;
    int randomWidth;
    int diagonalHeight;
    int diagonalWidth;
    Ellipse2D.Double randomImage;
    Ellipse2D.Double diagonalImage;
    static final int RANDOM_LAYOUT = 0;
    static final int DIAGONAL_LAYOUT = 1;
    static final double SQRT2;
    double[] nodePosition = DyadEvent.getRandomPosition();
    static Colour defaultNodeColour;
    Colour nodeColour;
    Colour nodeTranslucentColour;

    static {
        stateVariables = new HashMap();
        variablesFixed = false;
        SQRT2 = Math.sqrt(2.0);
        defaultNodeColour = Colour.getColour(0, 0, 204);
    }

    public DyadEvent(Trajectory traj, double on, Comparable[] s, List iV, Colour c, double[] nP) {
        this.trajectory = traj;
        this.onset = on;
        this.state = s;
        this.inertValues = iV;
        if (c != null) {
            this.setColour(c);
        } else {
            this.setColour(defaultNodeColour);
        }
        if (nP != null) {
            this.nodePosition = nP;
        }
    }

    public static void fixVariables() {
        variablesFixed = true;
    }

    public static void init() {
        stateVars = new ArrayList();
        stateVariables = new HashMap();
        variablesFixed = false;
    }

    public static void addStateVariable(Variable v) {
        if (!variablesFixed) {
            if (stateVariables.containsKey(v.label)) {
                throw new IllegalArgumentException("Variable " + v.label + " already exists.");
            }
        } else {
            throw new UnsupportedOperationException("New variables can no longer be added.");
        }
        stateVariables.put(v.label, v);
        stateVars.add(v);
    }

    public static double[] getRandomPosition() {
        double[] position = new double[DyadEvent.numVariables()];
        Iterator i = stateVars.iterator();
        while (i.hasNext()) {
            position[DyadEvent.getVariableIndex((Variable)((Variable)i.next()))] = Math.random();
        }
        return position;
    }

    public double getXPosition() {
        return this.nodePosition[DyadEvent.getVariableIndex(GridWindow.xVariable)];
    }

    public double getYPosition() {
        return this.nodePosition[DyadEvent.getVariableIndex(GridWindow.yVariable)];
    }

    public static List getStateVariables() {
        return stateVars;
    }

    public static Variable getVariable(String label) {
        label = label.toLowerCase();
        return (Variable)stateVariables.get(label);
    }

    public static Variable getVariable(int i) {
        return (Variable)stateVars.get(i);
    }

    public static int getVariableIndex(Variable v) {
        return stateVars.indexOf(v);
    }

    public static boolean isStateVariable(Variable v) {
        return stateVariables.containsValue(v);
    }

    public static boolean isVariable(Variable v) {
        return DyadEvent.isStateVariable(v);
    }

    public static boolean isVariable(String s) {
        return stateVariables.containsKey(s);
    }

    public static Collection getVariableNames() {
        return stateVariables.keySet();
    }

    public static int numVariables() {
        return stateVariables.size();
    }

    public void setColour(Colour c) {
        this.nodeColour = c;
        this.nodeTranslucentColour = c.getTranslucent(127);
    }

    public void setOnset(double on) {
        this.onset = on;
    }

    public void setOffset(double off) {
        this.offset = off;
    }

    public double duration() {
        return this.offset - this.onset;
    }

    public Comparable getValue(Variable v) {
        if (stateVars.contains(v)) {
            Comparable value = this.state[DyadEvent.getVariableIndex(v)];
            if (value == null && !GridWindow.allowMissingValues) {
                System.err.println("State variable " + v.toString() + " has no value at " + this.trajectory.filename + " " + (this.trajectory.onset + this.onset));
            }
            return value;
        }
        throw new IllegalArgumentException("Variable \"" + v.label + "\" not found.");
    }

    public int getValueIndex(Variable v) {
        return v.getIndex(this.getValue(v));
    }

    public CellPanel getCell() {
        return GridWindow.getCell(this);
    }

    public void updateNode() {
        double duration = this.duration();
        this.randomSize = 2.0 * Math.sqrt(duration / Trajectory.maxDuration / Math.PI);
        this.diagonalSize = duration / Trajectory.maxDuration;
        this.diagonalPosition = (this.onset + duration / 2.0) / Trajectory.maxDuration;
        this.dX = (1.0 - 1.0 / SQRT2) / 2.0 + 1.0 / SQRT2 * this.diagonalPosition;
        this.dY = (1.0 - 1.0 / SQRT2) / 2.0 + 1.0 / SQRT2 * this.diagonalPosition;
        this.setCell(this.getCell());
    }

    public void setCell(CellPanel c) {
        this.cell = c;
        this.updatePosition();
    }

    public void updatePosition() {
        if (this.cell != null) {
            this.randomWidth = (int)((double)this.cell.getWidth() * this.randomSize);
            this.randomHeight = (int)((double)this.cell.getHeight() * this.randomSize);
            this.diagonalWidth = (int)((double)this.cell.getWidth() * this.diagonalSize);
            this.diagonalHeight = (int)((double)this.cell.getHeight() * this.diagonalSize);
            this.randomX = this.cell.getX() + (int)((double)this.cell.getWidth() * (this.getXPosition() * (1.0 - this.randomSize) + this.randomSize / 2.0));
            this.randomY = this.cell.getY() + (int)((double)this.cell.getHeight() * (this.getYPosition() * (1.0 - this.randomSize) + this.randomSize / 2.0));
            this.diagonalX = this.cell.getX() + (int)((double)this.cell.getWidth() * this.dX);
            this.diagonalY = this.cell.getY() + this.cell.getHeight() - (int)((double)this.cell.getHeight() * this.dY);
            this.randomImage = new Ellipse2D.Double((double)this.randomX - (double)this.randomWidth / 2.0, (double)this.randomY - (double)this.randomHeight / 2.0, this.randomWidth, this.randomHeight);
            this.diagonalImage = new Ellipse2D.Double((double)this.diagonalX - (double)this.diagonalWidth / 2.0, (double)this.diagonalY - (double)this.diagonalHeight / 2.0, this.diagonalWidth, this.diagonalHeight);
        }
    }
}

