/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.Filter;
import GridWare.FiltersWindow;
import GridWare.GWSlider;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.PiecemealFilter;
import GridWare.RangeFilter;
import GridWare.Trajectory;
import GridWare.Variable;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.HashSet;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class FilterPanel
extends JPanel {
    FiltersWindow filtersWindow;
    GridWindow gridWindow;
    Filter filter;
    Variable variable;
    JComboBox filterChooser;
    GridBagLayout layout = new GridBagLayout();
    GridBagConstraints sliderConstraints = new GridBagConstraints();
    GridBagConstraints listConstraints = new GridBagConstraints();
    GWSlider filterSlider;
    JLabel lessThanLabel1;
    JLabel lessThanLabel2;
    JTextField minField = new JTextField(4);
    JTextField maxField = new JTextField(4);
    JList filterList;
    JScrollPane scrollPane;
    ChangeListener sliderListener = new ChangeListener(){

        public void stateChanged(ChangeEvent evt) {
            GWSlider source = (GWSlider)evt.getSource();
            int value = source.getValue();
            int extent = source.getExtent();
            if (extent > 0) {
                FilterPanel.this.minField.setText(Integer.toString(value));
                FilterPanel.this.maxField.setText(Integer.toString(value + extent));
                ((RangeFilter)FilterPanel.this.filter).adjustBounds(new Integer(value), new Integer(value + extent));
            } else {
                FilterPanel.this.maxField.setText(Integer.toString(value));
                FilterPanel.this.minField.setText(Integer.toString(value + extent));
                ((RangeFilter)FilterPanel.this.filter).adjustBounds(new Integer(value + extent), new Integer(value));
            }
            FilterPanel.this.repaint();
        }
    };
    ActionListener fieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            JTextField source = (JTextField)evt.getSource();
            int min = Integer.parseInt(FilterPanel.this.minField.getText());
            int max = Integer.parseInt(FilterPanel.this.maxField.getText());
            if (source == FilterPanel.this.minField) {
                if (min > max) {
                    max = min;
                    FilterPanel.this.maxField.setText(FilterPanel.this.minField.getText());
                    FilterPanel.this.filterSlider.setValueAndExtent(min, 0);
                } else if (FilterPanel.this.filterSlider.getExtent() >= 0) {
                    FilterPanel.this.filterSlider.setValue(min, false);
                }
            } else if (source == FilterPanel.this.maxField) {
                if (min > max) {
                    min = max;
                    FilterPanel.this.minField.setText(FilterPanel.this.maxField.getText());
                    FilterPanel.this.filterSlider.setValueAndExtent(max, 0);
                } else if (FilterPanel.this.filterSlider.getExtent() <= 0) {
                    FilterPanel.this.filterSlider.setValue(max, false);
                }
            }
            if (FilterPanel.this.filterSlider.isRequestFocusEnabled()) {
                FilterPanel.this.filterSlider.requestFocus();
            }
            GridWindow.takeMeasures();
        }
    };
    FocusListener fieldFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent evt) {
            JTextField source = (JTextField)evt.getSource();
            if (source == FilterPanel.this.minField) {
                FilterPanel.this.filterSlider.ensureExtentPositive();
            } else if (source == FilterPanel.this.maxField) {
                FilterPanel.this.filterSlider.ensureExtentNegative();
            }
        }
    };
    ListSelectionListener listListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent evt) {
            JList source = (JList)evt.getSource();
            int firstIndex = evt.getFirstIndex();
            int lastIndex = evt.getLastIndex();
            ListModel model = source.getModel();
            HashSet<Comparable> addSet = new HashSet<Comparable>();
            HashSet<Comparable> removeSet = new HashSet<Comparable>();
            int i = firstIndex;
            while (i <= lastIndex) {
                Comparable curValue = (Comparable)model.getElementAt(i);
                if (source.isSelectedIndex(i)) {
                    addSet.add(curValue);
                } else {
                    removeSet.add(curValue);
                }
                ++i;
            }
            ((PiecemealFilter)FilterPanel.this.filter).addAndRemoveValues(addSet, removeSet);
            if (GridWare.readyToMeasure) {
                GridWare.gridWindow.takeMeasures();
            }
        }
    };

    public void setFilter(Variable var) {
        if (this.filter != null) {
            this.gridWindow.removeFilter(this.filter);
        }
        this.variable = var;
        this.filter = this.gridWindow.createFilter(this.variable);
        if (this.filter instanceof RangeFilter) {
            if (this.filterList != null) {
                this.remove(this.scrollPane);
                this.filterList = null;
            } else if (this.filterSlider != null) {
                this.remove(this.filterSlider);
                this.filterSlider.removeChangeListener(this.sliderListener);
            }
            if (this.filterSlider == null) {
                this.minField.setVisible(true);
                this.lessThanLabel1.setVisible(true);
                this.lessThanLabel2.setVisible(true);
                this.maxField.setVisible(true);
            }
            this.filterSlider = new GWSlider();
            this.filterSlider.setSnapToTicks(true);
            this.filterSlider.setPaintTicks(true);
            this.filterSlider.setPaintLabels(true);
            this.filterSlider.setMajorTickSpacing((int)Math.ceil((double)this.filter.getRange() / 10.0));
            this.filterSlider.setMinorTickSpacing(1);
            RangeFilter rangeFilter = (RangeFilter)this.filter;
            this.filterSlider.setMinimum(rangeFilter.min);
            this.filterSlider.setMaximum(rangeFilter.max);
            this.filterSlider.addChangeListener(this.sliderListener);
            this.layout.setConstraints(this.filterSlider, this.sliderConstraints);
            this.add(this.filterSlider);
            this.filterSlider.setValue(rangeFilter.min);
            this.filterSlider.setExtent(rangeFilter.max - rangeFilter.min);
            this.minField.setText(String.valueOf(rangeFilter.min));
            this.maxField.setText(String.valueOf(rangeFilter.max));
            this.revalidate();
        } else if (this.filter instanceof PiecemealFilter) {
            this.minField.setVisible(false);
            this.lessThanLabel1.setVisible(false);
            this.lessThanLabel2.setVisible(false);
            this.maxField.setVisible(false);
            if (this.filterList != null) {
                this.remove(this.scrollPane);
            } else if (this.filterSlider != null) {
                this.remove(this.filterSlider);
                this.filterSlider = null;
            }
            this.filterList = new JList();
            this.filterList.setListData(this.variable.getValues());
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.4")) {
                this.filterList.setLayoutOrientation(2);
            }
            this.filterList.addListSelectionListener(this.listListener);
            this.filterList.setSelectionInterval(0, this.filter.getRange() - 1);
            this.filterList.setVisibleRowCount(5);
            this.scrollPane = new JScrollPane(this.filterList);
            this.layout.setConstraints(this.scrollPane, this.listConstraints);
            this.add(this.scrollPane);
            this.revalidate();
        }
    }

    public void remove() {
        if (this.filter != null) {
            this.gridWindow.removeFilter(this.filter);
        }
        this.setVisible(false);
        this.remove(this.minField);
        this.remove(this.lessThanLabel1);
        this.remove(this.filterChooser);
        this.remove(this.lessThanLabel2);
        this.remove(this.maxField);
        if (this.filterList != null) {
            this.remove(this.scrollPane);
            this.scrollPane = null;
            this.filterList.removeListSelectionListener(this.listListener);
            this.filterList = null;
        } else if (this.filterSlider != null) {
            this.remove(this.filterSlider);
            this.minField.removeActionListener(this.fieldListener);
            this.minField.removeFocusListener(this.fieldFocusListener);
            this.maxField.removeActionListener(this.fieldListener);
            this.maxField.removeFocusListener(this.fieldFocusListener);
            this.filterSlider.removeChangeListener(this.sliderListener);
            this.filterSlider = null;
        }
        this.minField = null;
        this.lessThanLabel1 = null;
        this.filterChooser = null;
        this.lessThanLabel2 = null;
        this.maxField = null;
        this.filtersWindow.filters.remove(this);
        this.filtersWindow.contentPane.remove(this);
        this.filtersWindow.pack();
        this.gridWindow.filter();
    }

    public FilterPanel(FiltersWindow fW, Variable var) {
        this.filtersWindow = fW;
        this.gridWindow = this.filtersWindow.gridWindow;
        this.setLayout(this.layout);
        this.sliderConstraints.gridx = 0;
        this.sliderConstraints.gridy = 1;
        this.sliderConstraints.weightx = 1.0;
        this.sliderConstraints.weighty = 0.0;
        this.sliderConstraints.gridwidth = 5;
        this.sliderConstraints.gridheight = 1;
        this.sliderConstraints.fill = 2;
        this.sliderConstraints.anchor = 10;
        this.listConstraints.gridx = 0;
        this.listConstraints.gridy = 1;
        this.listConstraints.weightx = 1.0;
        this.listConstraints.weighty = 1.0;
        this.listConstraints.gridwidth = 5;
        this.listConstraints.gridheight = 1;
        this.listConstraints.fill = 1;
        this.listConstraints.anchor = 10;
        GridBagConstraints gbc = new GridBagConstraints();
        this.minField.setHorizontalAlignment(4);
        this.minField.addActionListener(this.fieldListener);
        this.minField.addFocusListener(this.fieldFocusListener);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 14;
        this.layout.setConstraints(this.minField, gbc);
        this.lessThanLabel1 = new JLabel(" \u2264 ");
        gbc.gridx = 1;
        gbc.weightx = 0.0;
        gbc.anchor = 15;
        this.layout.setConstraints(this.lessThanLabel1, gbc);
        this.filterChooser = new JComboBox(Trajectory.getVariableNames());
        this.filterChooser.addItem("REMOVE");
        this.filterChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JComboBox source = (JComboBox)e.getSource();
                String selected = (String)source.getSelectedItem();
                if (selected.equals("REMOVE")) {
                    FilterPanel.this.remove();
                } else {
                    FilterPanel.this.setFilter(Trajectory.getVariable(selected));
                }
                if (GridWare.readyToMeasure) {
                    GridWare.gridWindow.takeMeasures();
                }
            }
        });
        this.filterChooser.setMaximumSize(new Dimension(100, 25));
        gbc.gridx = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 15;
        this.layout.setConstraints(this.filterChooser, gbc);
        this.lessThanLabel2 = new JLabel(" \u2264 ");
        gbc.gridx = 3;
        gbc.weightx = 0.0;
        gbc.anchor = 15;
        this.layout.setConstraints(this.lessThanLabel2, gbc);
        this.maxField.setHorizontalAlignment(2);
        this.maxField.addActionListener(this.fieldListener);
        this.maxField.addFocusListener(this.fieldFocusListener);
        gbc.gridx = 4;
        gbc.weightx = 0.0;
        gbc.anchor = 16;
        this.layout.setConstraints(this.maxField, gbc);
        this.add(this.minField);
        this.add(this.lessThanLabel1);
        this.add(this.filterChooser);
        this.add(this.lessThanLabel2);
        this.add(this.maxField);
        this.minField.setVisible(false);
        this.lessThanLabel1.setVisible(false);
        this.lessThanLabel2.setVisible(false);
        this.maxField.setVisible(false);
        this.filterChooser.setSelectedItem(var.label);
    }
}

