/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GWSlider;
import GridWare.GridWindow;
import GridWare.IntVariable;
import GridWare.RangeFilter;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class FilterSlider
extends GWSlider {
    GridWindow gridWindow;
    RangeFilter curFilter;
    JPanel panel = new JPanel();
    JLabel lessThanLabel1;
    JLabel lessThanLabel2;
    JLabel label;
    JTextField minField = new JTextField(4);
    JTextField maxField = new JTextField(4);
    GridBagLayout panelLayout = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    static ChangeListener filterSliderListener = new ChangeListener(){

        public void stateChanged(ChangeEvent evt) {
            FilterSlider source = (FilterSlider)evt.getSource();
            if (!source.getValueIsAdjusting()) {
                int min = source.getValue();
                source.minField.setText(Integer.toString(min));
                source.maxField.setText(Integer.toString(min + source.getExtent()));
                source.curFilter.adjustBounds(new Integer(min), new Integer(min + source.getExtent()));
                source.repaint();
            }
        }
    };
    ActionListener fieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            int max;
            JTextField source = (JTextField)evt.getSource();
            int min = Integer.parseInt(FilterSlider.this.minField.getText());
            if (min > (max = Integer.parseInt(FilterSlider.this.maxField.getText()))) {
                if (source == FilterSlider.this.minField) {
                    max = min;
                    FilterSlider.this.maxField.setText(FilterSlider.this.minField.getText());
                } else if (source == FilterSlider.this.maxField) {
                    min = max;
                    FilterSlider.this.minField.setText(FilterSlider.this.maxField.getText());
                }
            }
            FilterSlider.this.setValue(min);
            FilterSlider.this.setExtent(max - min);
        }
    };

    public FilterSlider(int orientation, IntVariable var, GridWindow gW) {
        this.gridWindow = gW;
        this.curFilter = (RangeFilter)this.gridWindow.createFilter(var);
        this.curFilter.extent = this.curFilter.max - this.curFilter.min;
        this.setSnapToTicks(false);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.setMajorTickSpacing((int)Math.ceil((double)this.curFilter.getRange() / 10.0));
        this.setMinorTickSpacing(Math.max(1, (int)Math.ceil((double)this.curFilter.getRange() / 100.0)));
        this.setMinimum(this.curFilter.min);
        this.setMaximum(this.curFilter.max);
        this.setValue(this.curFilter.value);
        this.setExtent(this.curFilter.extent);
        this.panel.setLayout(this.panelLayout);
        this.minField.setHorizontalAlignment(4);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 14;
        this.panelLayout.setConstraints(this.minField, this.gbc);
        this.panel.add(this.minField);
        this.lessThanLabel1 = new JLabel(" \u2264 ");
        this.gbc.gridx = 1;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 15;
        this.panelLayout.setConstraints(this.lessThanLabel1, this.gbc);
        this.panel.add(this.lessThanLabel1);
        this.label = new JLabel(this.curFilter.sortVariable.label);
        this.gbc.gridx = 2;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 15;
        this.panelLayout.setConstraints(this.label, this.gbc);
        this.panel.add(this.label);
        this.lessThanLabel2 = new JLabel(" \u2264 ");
        this.gbc.gridx = 3;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 15;
        this.panelLayout.setConstraints(this.lessThanLabel2, this.gbc);
        this.panel.add(this.lessThanLabel2);
        this.gbc.gridx = 4;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 16;
        this.panelLayout.setConstraints(this.maxField, this.gbc);
        this.panel.add(this.maxField);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 5;
        this.gbc.gridheight = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.panelLayout.setConstraints(this, this.gbc);
        this.panel.add(this);
        this.minField.addActionListener(this.fieldListener);
        this.maxField.addActionListener(this.fieldListener);
        this.addChangeListener(filterSliderListener);
        this.fireStateChanged();
    }
}

