/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.FilterPanel;
import GridWare.GridWindow;
import GridWare.TimeSlider;
import GridWare.Trajectory;
import GridWare.Variable;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FiltersWindow
extends JFrame {
    GridWindow gridWindow;
    Container contentPane;
    Iterator trajVariableIterator;
    TimeSlider timeSlider;
    GridBagConstraints filterConstraints = new GridBagConstraints();
    GridBagLayout filtersLayout = new GridBagLayout();
    Set filters = new HashSet();
    boolean resettingFilters = false;

    public FiltersWindow(GridWindow gW) {
        super("Filters");
        if (gW == null) {
            throw new IllegalArgumentException("No GridWindow linked to FiltersWindow");
        }
        this.gridWindow = gW;
        this.contentPane = this.getContentPane();
        ((JPanel)this.contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(this.filtersLayout);
        this.filterConstraints.gridx = 0;
        this.filterConstraints.gridy = -1;
        this.filterConstraints.weightx = 1.0;
        this.filterConstraints.weighty = 1.0;
        this.filterConstraints.gridwidth = 4;
        this.filterConstraints.gridheight = 1;
        this.filterConstraints.fill = 1;
        this.filterConstraints.anchor = 10;
        int filterCount = 0;
        Iterator i = Trajectory.getVariables().iterator();
        while (i.hasNext() && filterCount < 4) {
            Variable curVariable = (Variable)i.next();
            FilterPanel filterPanel = new FilterPanel(this, curVariable);
            this.filters.add(filterPanel);
            this.filtersLayout.setConstraints(filterPanel, this.filterConstraints);
            this.contentPane.add(filterPanel);
            ++filterCount;
        }
        int min = 0;
        int max = (int)Math.ceil(Trajectory.maxDuration);
        this.timeSlider = new TimeSlider(min, max, min, max - min, this.gridWindow);
        this.filtersLayout.setConstraints(this.timeSlider.panel, this.filterConstraints);
        this.contentPane.add(this.timeSlider.panel);
    }

    public void addFilter() {
        this.setVisible(false);
        this.contentPane.remove(this.timeSlider.panel);
        Iterator trajVariableIterator = Trajectory.getVariables().iterator();
        Variable curVariable = null;
        boolean variableAlreadyFiltered = true;
        block0: while (trajVariableIterator.hasNext() && variableAlreadyFiltered) {
            curVariable = (Variable)trajVariableIterator.next();
            variableAlreadyFiltered = false;
            for (FilterPanel curFilter : this.filters) {
                if (curFilter.variable != curVariable) continue;
                variableAlreadyFiltered = true;
                continue block0;
            }
        }
        FilterPanel filterPanel = new FilterPanel(this, curVariable);
        this.filters.add(filterPanel);
        this.filtersLayout.setConstraints(filterPanel, this.filterConstraints);
        this.contentPane.add(filterPanel);
        this.filtersLayout.setConstraints(this.timeSlider.panel, this.filterConstraints);
        this.contentPane.add(this.timeSlider.panel);
        this.pack();
        this.setVisible(true);
    }

    public void resetFilters() {
        this.resettingFilters = true;
        for (FilterPanel curFilter : this.filters) {
            curFilter.setFilter(curFilter.variable);
        }
        this.timeSlider.reset();
        this.resettingFilters = false;
    }
}

