/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.AboutBox;
import GridWare.Colour;
import GridWare.DyadEvent;
import GridWare.FiltersWindow;
import GridWare.GridWindow;
import GridWare.GroupsWindow;
import GridWare.IOHandler;
import GridWare.IntVariable;
import GridWare.LogWindow;
import GridWare.MeasuresWindow;
import GridWare.Preferences;
import GridWare.RegionsWindow;
import GridWare.StringVariable;
import GridWare.Trajectory;
import GridWare.Variable;
import GridWare.VariableCreationDialog;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class GridWare {
    static GridWare app;
    static GridWindow gridWindow;
    static MeasuresWindow measures;
    static FiltersWindow filters;
    static File userDir;
    static File currentDir;
    static PrintStream outStream;
    protected static AboutBox aboutBox;
    protected static Preferences prefs;
    protected static LogWindow logWindow;
    protected static RegionsWindow regionsWindow;
    protected static GroupsWindow groupsWindow;
    static boolean macPlatform;
    static int verticalBaseline;
    static int interWindowSpace;
    static int filtersWindowWidth;
    static int measuresWindowWidth;
    static long startTime;
    protected Action newAction;
    protected Action openAction;
    protected Action closeAction;
    protected Action saveAction;
    protected Action saveAsAction;
    protected Action printAction;
    protected Action imageExportAction;
    protected Action measuresExportAction;
    protected Action aboutAction;
    protected Action preferencesAction;
    protected Action quitAction;
    protected Action colourAction;
    protected Action addFilterAction;
    protected Action resetFiltersAction;
    protected Action randomAction;
    protected Action diagonalAction;
    protected Action randomizeAction;
    protected Action xAxisAction;
    protected Action yAxisAction;
    protected Action filtersAction;
    protected Action measuresAction;
    protected Action squareCellsAction;
    protected Action arrowsAction;
    protected Action addGridMeasureAction;
    protected Action addRegionMeasureAction;
    protected Action transitionsAction;
    protected Action nodesAction;
    protected Action translucentAction;
    protected Action hollowAction;
    protected Action startNodeAction;
    protected Action missingAction;
    protected Action createRegionAction;
    protected Action showRegionsAction;
    protected Action deleteRegionsAction;
    protected Action renameRegionAction;
    protected Action createCellRegionsAction;
    protected Action createGroupAction;
    protected Action addToGroupAction;
    protected Action showGroupsAction;
    protected Action deleteGroupsAction;
    protected Action renameGroupAction;
    protected List xAxisActions;
    protected List yAxisActions;
    protected JMenuBar mainMenuBar;
    protected JMenuBar filtersMenuBar;
    protected JMenuBar measuresMenuBar;
    protected JMenuBar logMenuBar;
    protected JMenuBar regionsMenuBar;
    protected JMenuBar groupsMenuBar;
    protected JMenu fileMenu;
    protected JMenu editMenu;
    protected JMenu filtersMenu;
    protected JMenu groupsMenu;
    protected JMenu layoutMenu;
    protected JMenu xAxisMenu;
    protected JMenu yAxisMenu;
    protected JMenu regionsMenu;
    protected JMenu measuresMenu;
    protected JMenu helpMenu;
    protected JMenu filtersFileMenu;
    protected JMenu filtersEditMenu;
    protected JMenu filtersFiltersMenu;
    protected JMenu filtersGroupsMenu;
    protected JMenu filtersLayoutMenu;
    protected JMenu filtersXAxisMenu;
    protected JMenu filtersYAxisMenu;
    protected JMenu filtersRegionsMenu;
    protected JMenu filtersMeasuresMenu;
    protected JMenu filtersHelpMenu;
    protected JMenu measuresFileMenu;
    protected JMenu measuresEditMenu;
    protected JMenu measuresFiltersMenu;
    protected JMenu measuresGroupsMenu;
    protected JMenu measuresLayoutMenu;
    protected JMenu measuresXAxisMenu;
    protected JMenu measuresYAxisMenu;
    protected JMenu measuresRegionsMenu;
    protected JMenu measuresMeasuresMenu;
    protected JMenu measuresHelpMenu;
    protected JMenu logFileMenu;
    protected JMenu logEditMenu;
    protected JMenu logFiltersMenu;
    protected JMenu logGroupsMenu;
    protected JMenu logLayoutMenu;
    protected JMenu logXAxisMenu;
    protected JMenu logYAxisMenu;
    protected JMenu logRegionsMenu;
    protected JMenu logMeasuresMenu;
    protected JMenu logHelpMenu;
    protected JMenu regionsFileMenu;
    protected JMenu regionsEditMenu;
    protected JMenu regionsFiltersMenu;
    protected JMenu regionsGroupsMenu;
    protected JMenu regionsLayoutMenu;
    protected JMenu regionsXAxisMenu;
    protected JMenu regionsYAxisMenu;
    protected JMenu regionsRegionsMenu;
    protected JMenu regionsMeasuresMenu;
    protected JMenu regionsHelpMenu;
    protected JMenu groupsFileMenu;
    protected JMenu groupsEditMenu;
    protected JMenu groupsFiltersMenu;
    protected JMenu groupsGroupsMenu;
    protected JMenu groupsLayoutMenu;
    protected JMenu groupsXAxisMenu;
    protected JMenu groupsYAxisMenu;
    protected JMenu groupsRegionsMenu;
    protected JMenu groupsMeasuresMenu;
    protected JMenu groupsHelpMenu;
    protected ResourceBundle resbundle;
    File openFile;
    static boolean somethingToSave;
    private static String inputFile;
    FileReader dataFileReader;
    BufferedReader trajReader;
    String trajFolderName;
    static boolean readyToMeasure;
    static boolean readyToTested;

    static {
        macPlatform = false;
        verticalBaseline = macPlatform ? 15 : 0;
        interWindowSpace = 1;
        filtersWindowWidth = 250;
        measuresWindowWidth = 280;
        somethingToSave = false;
        inputFile = "";
        readyToMeasure = false;
        readyToTested = false;
    }

    public GridWare() {
        aboutBox = new AboutBox();
        prefs = new Preferences();
        gridWindow = new GridWindow();
    }

    public static void main(String[] args) {
        startTime = new Date().getTime();
        logWindow = new LogWindow(filtersWindowWidth + interWindowSpace, 580);
        try {
            currentDir = userDir = new File(System.getProperty("user.dir"));
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            String javaVersion = System.getProperty("java.version");
            if (javaVersion.startsWith("1.4")) {
                Toolkit.getDefaultToolkit().setDynamicLayout(true);
            }
            if (args.length >= 1) {
                inputFile = args[0];
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    app = new GridWare();
                    if (GridWare.app.openFile == null) {
                        if (inputFile.equals("")) {
                            app.openDataFile(GridWare.selectInputFile());
                        } else {
                            System.out.println("GridWare Starting with input file : " + inputFile);
                            app.openDataFile(new File(inputFile));
                        }
                    }
                }
            });
        }
        catch (Throwable thrown) {
            thrown.printStackTrace();
            GridWare.quitDueToError(thrown.getMessage());
        }
    }

    public void openDataFile(File file) {
        this.openFile = file;
        logWindow.setVisible(true);
        if (this.openFile == null) {
            System.out.println("No file selected for opening.  Quitting...");
            this.quit(false);
        } else {
            try {
                String fileName = this.openFile.getName();
                int indexOfLastDot = fileName.lastIndexOf(".");
                this.trajFolderName = indexOfLastDot >= 0 ? String.valueOf(this.openFile.getParent()) + "/" + fileName.substring(0, indexOfLastDot) + "_trjs/" : String.valueOf(this.openFile.getParent()) + "/" + fileName + "_trjs/";
                somethingToSave = false;
                boolean configured = false;
                System.out.println("Opening " + fileName + "...");
                this.dataFileReader = new FileReader(this.openFile);
                this.trajReader = new BufferedReader(this.dataFileReader);
                if (this.trajReader == null) {
                    throw new IOException("Unable to open " + fileName);
                }
                DyadEvent.stateVars = new ArrayList();
                this.trajReader.mark(500);
                String line = this.trajReader.readLine();
                if (line.toLowerCase().startsWith("<gridware>")) {
                    StringTokenizer st;
                    line = this.trajReader.readLine();
                    if (line.toLowerCase().startsWith("<config>")) {
                        configured = true;
                        while (!(line = this.trajReader.readLine()).toLowerCase().startsWith("</config>")) {
                            st = new StringTokenizer(line, "\t,");
                            if (!st.hasMoreTokens()) continue;
                            if (line.toLowerCase().startsWith("region\t")) {
                                RegionsWindow.regionDefinitions.append(String.valueOf(line) + "\n");
                                continue;
                            }
                            if (line.toLowerCase().startsWith("group\t")) {
                                GroupsWindow.groupDefinitions.append(String.valueOf(line) + "\n");
                                continue;
                            }
                            String firstToken = st.nextToken().trim().toLowerCase();
                            if (firstToken.equals("trajectory") || firstToken.equals("identifier") || firstToken.equals("attribute") || firstToken.equals("state")) {
                                StringVariable stringVar;
                                String variableKind = firstToken;
                                String variableType = st.nextToken().trim();
                                String variableName = st.nextToken().trim();
                                if (variableKind.equals("trajectory") || variableKind.equals("identifier") || variableKind.equals("attribute")) {
                                    if (variableType.equals("integer") || variableType.equals("ordinal")) {
                                        if (st.hasMoreTokens()) {
                                            String variableMin = st.nextToken().trim();
                                            if (!st.hasMoreTokens()) {
                                                throw new IOException("Missing maximum value for variable " + variableName);
                                            }
                                            String variableMax = st.nextToken().trim();
                                            Trajectory.addTrajectoryVariable(new IntVariable(variableName, Integer.parseInt(variableMin), Integer.parseInt(variableMax)));
                                            continue;
                                        }
                                        Trajectory.addTrajectoryVariable(new IntVariable(variableName));
                                        continue;
                                    }
                                    if (variableType.equals("string") || variableType.equals("categorical")) {
                                        stringVar = new StringVariable(variableName);
                                        if (st.hasMoreTokens()) {
                                            stringVar.nonCanonicallyOrdered = true;
                                            while (st.hasMoreTokens()) {
                                                stringVar.addValue(stringVar.valueOf(st.nextToken().trim()));
                                            }
                                            stringVar.fixValues();
                                        }
                                        Trajectory.addTrajectoryVariable(stringVar);
                                        continue;
                                    }
                                    throw new IOException("Unsupported variable type: " + variableType);
                                }
                                if (!variableKind.equals("state")) continue;
                                if (variableType.equals("integer") || variableType.equals("ordinal")) {
                                    if (!st.hasMoreTokens()) {
                                        throw new IOException("Missing minimum value for variable " + variableName);
                                    }
                                    int min = Integer.parseInt(st.nextToken().trim());
                                    if (!st.hasMoreTokens()) {
                                        throw new IOException("Missing maximum value for variable " + variableName);
                                    }
                                    int max = Integer.parseInt(st.nextToken().trim());
                                    if (st.hasMoreTokens()) {
                                        ArrayList<String> labels = new ArrayList<String>();
                                        while (st.hasMoreTokens()) {
                                            String curLabel = st.nextToken().trim();
                                            Iterator j = labels.iterator();
                                            while (j.hasNext()) {
                                                if (!curLabel.equals(j.next())) continue;
                                                throw new IOException("Duplicate labels for state variable " + variableName + ": " + curLabel);
                                            }
                                            labels.add(curLabel);
                                        }
                                        if (labels.size() <= max - min) {
                                            throw new IOException("Missing labels for variable " + variableName);
                                        }
                                        String[] variableLabels = new String[labels.size()];
                                        labels.toArray(variableLabels);
                                        DyadEvent.addStateVariable(new IntVariable(variableName, min, max, variableLabels));
                                        continue;
                                    }
                                    DyadEvent.addStateVariable(new IntVariable(variableName, min, max));
                                    continue;
                                }
                                if (variableType.equals("string") || variableType.equals("categorical")) {
                                    stringVar = new StringVariable(variableName);
                                    if (st.hasMoreTokens()) {
                                        stringVar.nonCanonicallyOrdered = true;
                                        while (st.hasMoreTokens()) {
                                            stringVar.addValue(stringVar.valueOf(st.nextToken().trim()));
                                        }
                                    } else {
                                        throw new IOException("Must specify values for variable " + variableName);
                                    }
                                    stringVar.fixValues();
                                    DyadEvent.addStateVariable(stringVar);
                                    continue;
                                }
                                throw new IOException("Unsupported variable type: " + variableType);
                            }
                            if (firstToken.equals("minreturns")) {
                                Trajectory.minReturns = Integer.parseInt(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("maxreturntime")) {
                                Trajectory.maxReturnTime = Double.parseDouble(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("maxreturnvisits")) {
                                Trajectory.maxReturnVisits = Integer.parseInt(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("mineventduration")) {
                                Trajectory.minEventDuration = Double.parseDouble(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("mincellduration")) {
                                Trajectory.minCellDuration = Double.parseDouble(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("missingvaluesymbol")) {
                                GridWindow.missingValue = st.nextToken().trim();
                                continue;
                            }
                            if (firstToken.equals("transitionsrelativeto")) {
                                String onsetsOffsetsString = st.nextToken().trim().toLowerCase();
                                if (onsetsOffsetsString.equals("onsets")) {
                                    Trajectory.onsetRelativeTrans = true;
                                    continue;
                                }
                                if (onsetsOffsetsString.equals("offsets")) {
                                    Trajectory.onsetRelativeTrans = false;
                                    continue;
                                }
                                throw new IOException("Invalid configuration symbol: " + onsetsOffsetsString);
                            }
                            if (firstToken.equals("transbinsize")) {
                                Trajectory.transBinSize = Integer.parseInt(st.nextToken().trim());
                                continue;
                            }
                            if (firstToken.equals("transnumbins")) {
                                Trajectory.transNumBins = Integer.parseInt(st.nextToken().trim());
                                continue;
                            }
                            throw new IOException("Invalid configuration symbol: " + firstToken);
                        }
                    }
                    this.trajReader.mark(500);
                    while (!(st = new StringTokenizer(line = this.trajReader.readLine(), "\t")).hasMoreTokens()) {
                        this.trajReader.mark(500);
                    }
                }
                if (!line.toLowerCase().startsWith("<trajectories>")) {
                    this.trajReader.reset();
                } else {
                    this.trajReader.mark(500);
                }
                if (!configured) {
                    this.createVariables(this.trajReader.readLine(), this.trajReader.readLine());
                } else {
                    this.setUpWindow();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                GridWare.quitDueToError(ex.getMessage());
            }
        }
    }

    public void createVariables(String nameLine, String valueLine) {
        String curValue;
        String curName;
        StringTokenizer nameTokenizer = new StringTokenizer(nameLine, "\t");
        StringTokenizer valueTokenizer = new StringTokenizer(valueLine, "\t");
        Vector<String> trajVarNames = new Vector<String>();
        Vector<String> trajVarTypes = new Vector<String>();
        String trjFile = null;
        while (nameTokenizer.hasMoreTokens()) {
            curName = nameTokenizer.nextToken().trim();
            curValue = valueTokenizer.nextToken().trim();
            if (!curName.toLowerCase().equals("filename")) {
                trajVarNames.add(curName);
                try {
                    Integer.parseInt(curValue);
                    trajVarTypes.add("Ordinal");
                }
                catch (NumberFormatException nFE) {
                    trajVarTypes.add("Categorical");
                }
                continue;
            }
            trjFile = curValue;
        }
        try {
            FileReader dataFileReader = new FileReader(String.valueOf(this.trajFolderName) + trjFile);
            if (dataFileReader == null) {
                throw new IOException("Unable to open " + trjFile);
            }
            BufferedReader br = new BufferedReader(dataFileReader);
            nameTokenizer = new StringTokenizer(br.readLine(), "\t");
            valueTokenizer = new StringTokenizer(br.readLine(), "\t");
            br.close();
            dataFileReader.close();
            Vector<String> stateVarNames = new Vector<String>();
            Vector<String> stateVarTypes = new Vector<String>();
            while (nameTokenizer.hasMoreTokens()) {
                curName = nameTokenizer.nextToken().trim();
                curValue = valueTokenizer.nextToken().trim();
                if (curName.toLowerCase().equals("onset") || curName.toLowerCase().equals("colour") || curName.toLowerCase().equals("color") || curName.endsWith(" POS")) continue;
                stateVarNames.add(curName);
                try {
                    Integer.parseInt(curValue);
                    stateVarTypes.add("Ordinal");
                }
                catch (NumberFormatException nFE) {
                    stateVarTypes.add("Categorical");
                }
            }
            VariableCreationDialog variableCreationDialog = new VariableCreationDialog(gridWindow, "Define Variables", trajVarTypes, trajVarNames, stateVarTypes, stateVarNames);
        }
        catch (IOException ioEx) {
            VariableCreationDialog variableCreationDialog = new VariableCreationDialog(gridWindow, "Define Variables");
        }
    }

    public void setUpWindow() {
        try {
            if (this.trajReader == null) {
                this.close(false);
            }
            this.trajReader.reset();
            if (this.openFile != null) {
                String title = this.openFile.getName();
                if (macPlatform) {
                    gridWindow.setTitle(title);
                } else {
                    gridWindow.setTitle(String.valueOf(title) + " - GridWare");
                }
                gridWindow.setupGrid(this.trajReader, this.trajFolderName);
                System.out.println("Initializing nodes...");
                gridWindow.updateNodes();
                System.out.println("Nodes initialized.");
                filters = new FiltersWindow(gridWindow);
                measures = GridWindow.measures;
                regionsWindow = new RegionsWindow(gridWindow);
                groupsWindow = new GroupsWindow(gridWindow);
                this.createActions();
                this.addMenus();
                gridWindow.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent e) {
                        GridWare.this.quit(true);
                    }
                });
                gridWindow.setLocation(filtersWindowWidth + interWindowSpace, verticalBaseline);
                gridWindow.setSize(480, 550 - verticalBaseline);
                gridWindow.squareCells();
                filters.setResizable(true);
                filters.pack();
                filters.setLocation(0, verticalBaseline);
                filters.setSize(filtersWindowWidth, GridWare.filters.getSize().height);
                int gridWindowHeight = GridWare.gridWindow.getSize().height;
                int gridWindowWidth = GridWare.gridWindow.getSize().width;
                measures.setLocation(filtersWindowWidth + interWindowSpace + gridWindowWidth + interWindowSpace, verticalBaseline);
                measures.pack();
                measures.setSize(measuresWindowWidth, GridWare.measures.getSize().height);
                measures.setResizable(true);
                regionsWindow.setLocation(0, Math.min(600 - GridWare.regionsWindow.getSize().height, verticalBaseline + GridWare.filters.getSize().height + interWindowSpace));
                regionsWindow.pack();
                groupsWindow.setLocation(0, Math.min(600 - GridWare.groupsWindow.getSize().height, verticalBaseline + GridWare.filters.getSize().height + interWindowSpace));
                groupsWindow.pack();
                this.layoutMenu.getItem(0).doClick();
                this.xAxisMenu.getItem(0).setSelected(true);
                if (macPlatform) {
                    this.filtersXAxisMenu.getItem(0).setSelected(true);
                    this.measuresXAxisMenu.getItem(0).setSelected(true);
                    this.logXAxisMenu.getItem(0).setSelected(true);
                    this.regionsXAxisMenu.getItem(0).setSelected(true);
                    this.groupsXAxisMenu.getItem(0).setSelected(true);
                }
                this.yAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                if (macPlatform) {
                    this.filtersYAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                    this.measuresYAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                    this.logYAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                    this.regionsYAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                    this.groupsYAxisMenu.getItem(this.yAxisMenu.getItemCount() > 1 ? 1 : 0).setSelected(true);
                }
                readyToMeasure = true;
                gridWindow.setGridTitle();
                System.out.println("Calculating measures...");
                GridWindow.takeMeasures();
                System.out.println("Measures calculated.");
                readyToTested = true;
                gridWindow.setVisible(true);
                this.showFilters();
                this.showMeasures();
                System.out.println("Select one or more trajectories using filters, then choose ");
                System.out.println("\"Show Event Nodes\" and/or \"Show Transitions\" under the Grid menu.");
            }
            this.trajReader.close();
            this.dataFileReader.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            GridWare.quitDueToError(ex.getMessage());
        }
    }

    public static void setSomethingToSave(boolean sts) {
        somethingToSave = sts;
    }

    public static void quitDueToError(String msg) {
        JOptionPane.showMessageDialog(gridWindow, "GridWare must quit now due to an error.\n\n" + msg + "\n\n" + "See the file gw_run_log.txt for more information.\n" + "Send bug reports to <alex.lamey@utoronto.ca>", "Error", 0);
        app.quit(false);
    }

    public boolean close(boolean confirmSave) {
        int response = gridWindow != null && confirmSave && somethingToSave ? JOptionPane.showConfirmDialog(gridWindow, "Do you want to save first?") : 1;
        if (response == 0) {
            this.saveState(true);
        }
        if (response != 2) {
            if (logWindow != null) {
                logWindow.dispose();
            }
            if (aboutBox != null) {
                aboutBox.dispose();
            }
            if (prefs != null) {
                prefs.dispose();
            }
            if (gridWindow != null) {
                if (GridWindow.measures != null) {
                    GridWindow.measures.dispose();
                }
                gridWindow.dispose();
            }
            if (filters != null) {
                filters.dispose();
            }
            if (regionsWindow != null) {
                regionsWindow.dispose();
            }
            RegionsWindow.regionDefinitions = new StringBuffer("");
            if (groupsWindow != null) {
                groupsWindow.dispose();
            }
            GroupsWindow.groupDefinitions = new StringBuffer("");
            measures = null;
            filters = null;
            gridWindow = null;
            GridWindow.init();
            Trajectory.init();
            DyadEvent.init();
            this.openFile = null;
            somethingToSave = false;
            readyToMeasure = false;
            return true;
        }
        return false;
    }

    public void saveState(boolean saveAs) {
        if (saveAs || this.openFile == null && somethingToSave) {
            File file = GridWare.selectOutputFile();
            if (file != null) {
                if (file.getPath().endsWith(".gwf")) {
                    this.saveState(file);
                } else {
                    this.saveState(new File(String.valueOf(file.getPath()) + ".gwf"));
                }
            }
        } else if (somethingToSave) {
            this.saveState(this.openFile);
        }
    }

    public void saveState(File file) {
        Iterator j;
        Vector varValues;
        if (file == null) {
            return;
        }
        this.openFile = file;
        System.out.println("Saving to " + this.openFile.getPath() + "...");
        String openFileName = this.openFile.getName();
        if (macPlatform) {
            gridWindow.setTitle(openFileName);
        } else {
            gridWindow.setTitle(String.valueOf(openFileName) + " - GridWare");
        }
        NumberFormat nf = NumberFormat.getInstance();
        StringBuffer output = new StringBuffer("");
        output.append("<GridWare>\n");
        output.append("<Config>\n");
        for (Variable curVariable : Trajectory.getTrajectoryVariables()) {
            output.append("trajectory\t");
            if (curVariable instanceof IntVariable) {
                output.append("ordinal\t");
                output.append(String.valueOf(curVariable.label) + "\t");
                output.append(curVariable.minValue() + "\t");
                output.append(curVariable.maxValue() + "\t");
            } else if (curVariable instanceof StringVariable) {
                output.append("categorical\t");
                output.append(String.valueOf(curVariable.label) + "\t");
                varValues = curVariable.getValues();
                j = varValues.iterator();
                while (j.hasNext()) {
                    output.append(String.valueOf((String)j.next()) + "\t");
                }
            }
            output.append("\n");
        }
        for (Variable curVariable : DyadEvent.getStateVariables()) {
            output.append("state\t");
            if (curVariable instanceof IntVariable) {
                if (curVariable.saveLabelsNotValues) {
                    output.append("categorical\t");
                } else {
                    output.append("ordinal\t");
                }
                output.append(String.valueOf(curVariable.label) + "\t");
                if (curVariable.saveLabelsNotValues) {
                    varValues = curVariable.getValues();
                    j = varValues.iterator();
                    while (j.hasNext()) {
                        output.append(String.valueOf(curVariable.getLabel((Comparable)j.next())) + "\t");
                    }
                } else {
                    output.append(curVariable.minValue() + "\t");
                    output.append(curVariable.maxValue() + "\t");
                }
            } else if (curVariable instanceof StringVariable) {
                output.append("categorical\t");
                output.append(String.valueOf(curVariable.label) + "\t");
                varValues = curVariable.getValues();
                j = varValues.iterator();
                while (j.hasNext()) {
                    output.append(String.valueOf(curVariable.getLabel((Comparable)j.next())) + "\t");
                }
            }
            output.append("\n");
        }
        output.append(groupsWindow.toString());
        output.append(regionsWindow.toString());
        output.append("MinReturns\t" + Trajectory.minReturns + "\n");
        output.append("MaxReturnTime\t" + nf.format(Trajectory.maxReturnTime) + "\n");
        output.append("MaxReturnVisits\t" + Trajectory.maxReturnVisits + "\n");
        output.append("MinEventDuration\t" + nf.format(Trajectory.minEventDuration) + "\n");
        output.append("MinCellDuration\t" + nf.format(Trajectory.minCellDuration) + "\n");
        output.append("MissingValueSymbol\t" + GridWindow.missingValue + "\n");
        output.append("TransitionsRelativeTo\t" + (Trajectory.onsetRelativeTrans ? "onsets" : "offsets") + "\n");
        output.append("TransBinSize\t" + Trajectory.transBinSize + "\n");
        output.append("TransNumBins\t" + Trajectory.transNumBins + "\n");
        output.append("</Config>\n");
        output.append("<Trajectories>\n");
        output.append(GridWindow.allTrajectories.saveString());
        output.append("</Trajectories>\n");
        output.append("</GridWare>\n");
        IOHandler.openOutFile(this.openFile);
        IOHandler.printToFile(output.toString());
        IOHandler.closeOutFile();
        int lastIndexOfDot = openFileName.lastIndexOf(".");
        String trajFolderName = lastIndexOfDot >= 0 ? String.valueOf(this.openFile.getParent()) + "/" + openFileName.substring(0, lastIndexOfDot) + "_trjs/" : String.valueOf(this.openFile.getPath()) + "_trjs/";
        gridWindow.saveTrajectories(trajFolderName);
        somethingToSave = false;
        System.out.println("Save finished.");
    }

    public static File selectInputFile() {
        JFileChooser fc = new JFileChooser(currentDir);
        fc.setDialogTitle("GridWare: Open GWF file");
        if (fc.showOpenDialog(gridWindow) == 0) {
            currentDir = fc.getSelectedFile().getParentFile();
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File selectOutputFile(String filename) {
        JFileChooser fc = new JFileChooser(String.valueOf(currentDir.getPath()) + "/" + filename);
        if (fc.showSaveDialog(gridWindow) == 0) {
            currentDir = fc.getSelectedFile().getParentFile();
            return fc.getSelectedFile();
        }
        return null;
    }

    public static File selectOutputFile() {
        JFileChooser fc = new JFileChooser(currentDir);
        if (fc.showSaveDialog(gridWindow) == 0) {
            currentDir = fc.getSelectedFile().getParentFile();
            return fc.getSelectedFile();
        }
        return null;
    }

    public void about() {
        aboutBox.setVisible(true);
    }

    public void preferences() {
        prefs.setVisible(true);
    }

    public void quit(boolean confirmSave) {
        if (confirmSave) {
            if (this.close(confirmSave)) {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    public void showFilters() {
        filters.setVisible(true);
        filters.show();
    }

    public void hideFilters() {
        filters.setVisible(false);
    }

    public void showMeasures() {
        GridWindow.measures.setVisible(true);
        GridWindow.measures.show();
    }

    public void hideMeasures() {
        GridWindow.measures.setVisible(false);
    }

    public void createActions() {
        int shortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.openAction = new openActionClass("Open...", KeyStroke.getKeyStroke(79, shortcutKeyMask));
        this.closeAction = new closeActionClass("Close", KeyStroke.getKeyStroke(87, shortcutKeyMask));
        this.saveAction = new saveActionClass("Save", KeyStroke.getKeyStroke(83, shortcutKeyMask));
        this.saveAsAction = new saveAsActionClass("Save As...");
        this.imageExportAction = new imageExportActionClass("Export Image...");
        this.measuresExportAction = new measuresExportActionClass("Export Measures...");
        if (!macPlatform) {
            this.preferencesAction = new preferencesActionClass("Preferences...");
            this.quitAction = new quitActionClass("Quit", KeyStroke.getKeyStroke(81, shortcutKeyMask));
            this.aboutAction = new aboutActionClass("About GridWare");
        }
        this.addFilterAction = new addFilterActionClass("Add Filter");
        this.resetFiltersAction = new resetFiltersActionClass("Reset Filters");
        this.randomAction = new layoutActionClass("Random Layout");
        this.diagonalAction = new layoutActionClass("Diagonal Layout");
        this.randomizeAction = new layoutActionClass("Randomize Nodes", KeyStroke.getKeyStroke(90, shortcutKeyMask));
        this.colourAction = new colourActionClass("Colour Nodes...", KeyStroke.getKeyStroke(76, shortcutKeyMask));
        this.squareCellsAction = new squareCellsActionClass("Square Cells", KeyStroke.getKeyStroke(85, shortcutKeyMask));
        this.filtersAction = new filtersActionClass("Hide Filters");
        this.measuresAction = new measuresActionClass("Hide Measures");
        this.arrowsAction = new arrowsActionClass("Show Arrows");
        this.transitionsAction = new transitionsActionClass("Show Transitions");
        this.nodesAction = new nodesActionClass("Show Event Nodes");
        this.translucentAction = new translucentActionClass("Opaque Nodes");
        this.hollowAction = new hollowActionClass("Hollow Nodes");
        this.startNodeAction = new startNodeActionClass("Unmark Start Node");
        this.missingAction = new missingActionClass("Hide Missing");
        this.xAxisActions = new ArrayList();
        this.yAxisActions = new ArrayList();
        for (Variable variable : DyadEvent.getStateVariables()) {
            this.xAxisActions.add(new xAxisActionClass(variable));
            this.yAxisActions.add(new yAxisActionClass(variable));
        }
        this.addGridMeasureAction = new addGridMeasureActionClass("Add Grid Measure");
        this.addRegionMeasureAction = new addRegionMeasureActionClass("Add Region Measure");
        this.createRegionAction = new createRegionActionClass("Create Region", KeyStroke.getKeyStroke(82, shortcutKeyMask));
        this.createCellRegionsAction = new createCellRegionsActionClass("Create Cell Regions");
        this.renameRegionAction = new renameRegionActionClass("Rename Region");
        this.deleteRegionsAction = new deleteRegionsActionClass("Delete Regions");
        this.showRegionsAction = new showRegionsActionClass("Show Regions");
    }

    public void addMenus() {
        AbstractAction action;
        this.mainMenuBar = new JMenuBar();
        this.fileMenu = new JMenu("File");
        this.fileMenu.add(new JMenuItem(this.openAction));
        this.fileMenu.add(new JMenuItem(this.closeAction));
        this.fileMenu.add(new JMenuItem(this.saveAction));
        this.fileMenu.add(new JMenuItem(this.saveAsAction));
        this.fileMenu.add(new JMenuItem(this.imageExportAction));
        this.fileMenu.add(new JMenuItem(this.measuresExportAction));
        if (!macPlatform) {
            this.fileMenu.add(new JMenuItem(this.quitAction));
        }
        this.mainMenuBar.add(this.fileMenu);
        this.filtersMenu = new JMenu("Filters");
        this.filtersMenu.add(new JMenuItem(this.addFilterAction));
        this.filtersMenu.add(new JMenuItem(this.resetFiltersAction));
        this.mainMenuBar.add(this.filtersMenu);
        this.layoutMenu = new JMenu("Grid");
        JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(this.randomAction);
        ButtonGroup layoutGroup = new ButtonGroup();
        ((layoutActionClass)this.randomAction).addButton(menuItem);
        this.layoutMenu.add(menuItem);
        layoutGroup.add(menuItem);
        menuItem = new JRadioButtonMenuItem(this.diagonalAction);
        ((layoutActionClass)this.diagonalAction).addButton(menuItem);
        this.layoutMenu.add(menuItem);
        layoutGroup.add(menuItem);
        this.layoutMenu.addSeparator();
        this.layoutMenu.add(new JMenuItem(this.squareCellsAction));
        this.layoutMenu.add(new JMenuItem(this.colourAction));
        this.layoutMenu.add(new JMenuItem(this.randomizeAction));
        this.layoutMenu.addSeparator();
        this.layoutMenu.add(new JMenuItem(this.nodesAction));
        this.layoutMenu.add(new JMenuItem(this.translucentAction));
        this.layoutMenu.add(new JMenuItem(this.hollowAction));
        this.layoutMenu.add(new JMenuItem(this.startNodeAction));
        this.layoutMenu.addSeparator();
        this.layoutMenu.add(new JMenuItem(this.transitionsAction));
        this.layoutMenu.add(new JMenuItem(this.arrowsAction));
        this.layoutMenu.add(new JMenuItem(this.missingAction));
        this.mainMenuBar.add(this.layoutMenu);
        this.xAxisMenu = new JMenu("X Axis");
        this.yAxisMenu = new JMenu("Y Axis");
        ButtonGroup xAxisGroup = new ButtonGroup();
        ButtonGroup yAxisGroup = new ButtonGroup();
        Iterator x = this.xAxisActions.iterator();
        Iterator y = this.yAxisActions.iterator();
        while (x.hasNext()) {
            action = (AbstractAction)x.next();
            menuItem = new JRadioButtonMenuItem(action);
            ((xAxisActionClass)action).addButton(menuItem);
            this.xAxisMenu.add(menuItem);
            xAxisGroup.add(menuItem);
            action = (AbstractAction)y.next();
            menuItem = new JRadioButtonMenuItem(action);
            ((yAxisActionClass)action).addButton(menuItem);
            this.yAxisMenu.add(menuItem);
            yAxisGroup.add(menuItem);
        }
        this.mainMenuBar.add(this.yAxisMenu);
        this.mainMenuBar.add(this.xAxisMenu);
        this.regionsMenu = new JMenu("Regions");
        this.regionsMenu.add(new JMenuItem(this.createRegionAction));
        this.regionsMenu.add(new JMenuItem(this.createCellRegionsAction));
        this.regionsMenu.add(new JMenuItem(this.renameRegionAction));
        this.regionsMenu.add(new JMenuItem(this.deleteRegionsAction));
        this.regionsMenu.add(new JMenuItem(this.showRegionsAction));
        this.mainMenuBar.add(this.regionsMenu);
        this.measuresMenu = new JMenu("Measures");
        this.measuresMenu.add(new JMenuItem(this.addGridMeasureAction));
        this.measuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
        if (!macPlatform) {
            this.measuresMenu.addSeparator();
            this.measuresMenu.add(new JMenuItem(this.preferencesAction));
        }
        this.mainMenuBar.add(this.measuresMenu);
        if (!macPlatform) {
            this.helpMenu = new JMenu("Help");
            this.helpMenu.add(new JMenuItem(this.aboutAction));
            this.mainMenuBar.add(this.helpMenu);
        }
        gridWindow.setJMenuBar(this.mainMenuBar);
        if (macPlatform) {
            this.filtersMenuBar = new JMenuBar();
            this.filtersFileMenu = new JMenu("File");
            this.filtersFileMenu.add(new JMenuItem(this.openAction));
            this.filtersFileMenu.add(new JMenuItem(this.closeAction));
            this.filtersFileMenu.add(new JMenuItem(this.saveAction));
            this.filtersFileMenu.add(new JMenuItem(this.saveAsAction));
            this.filtersFileMenu.add(new JMenuItem(this.imageExportAction));
            this.filtersFileMenu.add(new JMenuItem(this.measuresExportAction));
            this.filtersMenuBar.add(this.filtersFileMenu);
            this.filtersFiltersMenu = new JMenu("Filters");
            this.filtersFiltersMenu.add(new JMenuItem(this.addFilterAction));
            this.filtersFiltersMenu.add(new JMenuItem(this.resetFiltersAction));
            this.filtersMenuBar.add(this.filtersFiltersMenu);
            this.filtersGroupsMenu = new JMenu("Groups");
            this.filtersGroupsMenu.add(new JMenuItem(this.createGroupAction));
            this.filtersGroupsMenu.add(new JMenuItem(this.addToGroupAction));
            this.filtersGroupsMenu.add(new JMenuItem(this.renameGroupAction));
            this.filtersGroupsMenu.add(new JMenuItem(this.deleteGroupsAction));
            this.filtersGroupsMenu.add(new JMenuItem(this.showGroupsAction));
            this.filtersMenuBar.add(this.filtersGroupsMenu);
            this.filtersLayoutMenu = new JMenu("Grid");
            layoutGroup = new ButtonGroup();
            menuItem = new JRadioButtonMenuItem(this.randomAction);
            ((layoutActionClass)this.randomAction).addButton(menuItem);
            this.filtersLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            menuItem = new JRadioButtonMenuItem(this.diagonalAction);
            ((layoutActionClass)this.diagonalAction).addButton(menuItem);
            this.filtersLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            this.filtersLayoutMenu.addSeparator();
            this.filtersLayoutMenu.add(new JMenuItem(this.squareCellsAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.colourAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.randomizeAction));
            this.filtersLayoutMenu.addSeparator();
            this.filtersLayoutMenu.add(new JMenuItem(this.nodesAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.translucentAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.hollowAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.startNodeAction));
            this.filtersLayoutMenu.addSeparator();
            this.filtersLayoutMenu.add(new JMenuItem(this.transitionsAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.arrowsAction));
            this.filtersLayoutMenu.add(new JMenuItem(this.missingAction));
            this.filtersMenuBar.add(this.filtersLayoutMenu);
            this.filtersXAxisMenu = new JMenu("X Axis");
            this.filtersYAxisMenu = new JMenu("Y Axis");
            xAxisGroup = new ButtonGroup();
            yAxisGroup = new ButtonGroup();
            x = this.xAxisActions.iterator();
            y = this.yAxisActions.iterator();
            while (x.hasNext()) {
                action = (AbstractAction)x.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((xAxisActionClass)action).addButton(menuItem);
                this.filtersXAxisMenu.add(menuItem);
                xAxisGroup.add(menuItem);
                action = (AbstractAction)y.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((yAxisActionClass)action).addButton(menuItem);
                this.filtersYAxisMenu.add(menuItem);
                yAxisGroup.add(menuItem);
            }
            this.filtersMenuBar.add(this.filtersYAxisMenu);
            this.filtersMenuBar.add(this.filtersXAxisMenu);
            this.filtersRegionsMenu = new JMenu("Regions");
            this.filtersRegionsMenu.add(new JMenuItem(this.createRegionAction));
            this.filtersRegionsMenu.add(new JMenuItem(this.createCellRegionsAction));
            this.filtersRegionsMenu.add(new JMenuItem(this.renameRegionAction));
            this.filtersRegionsMenu.add(new JMenuItem(this.deleteRegionsAction));
            this.filtersRegionsMenu.add(new JMenuItem(this.showRegionsAction));
            this.filtersMenuBar.add(this.filtersRegionsMenu);
            this.filtersMeasuresMenu = new JMenu("Measures");
            this.filtersMeasuresMenu.add(new JMenuItem(this.addGridMeasureAction));
            this.filtersMeasuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
            this.filtersMenuBar.add(this.filtersMeasuresMenu);
            filters.setJMenuBar(this.filtersMenuBar);
            this.measuresMenuBar = new JMenuBar();
            this.measuresFileMenu = new JMenu("File");
            this.measuresFileMenu.add(new JMenuItem(this.openAction));
            this.measuresFileMenu.add(new JMenuItem(this.closeAction));
            this.measuresFileMenu.add(new JMenuItem(this.saveAction));
            this.measuresFileMenu.add(new JMenuItem(this.saveAsAction));
            this.measuresFileMenu.add(new JMenuItem(this.imageExportAction));
            this.measuresFileMenu.add(new JMenuItem(this.measuresExportAction));
            this.measuresMenuBar.add(this.measuresFileMenu);
            this.measuresFiltersMenu = new JMenu("Filters");
            this.measuresFiltersMenu.add(new JMenuItem(this.addFilterAction));
            this.measuresFiltersMenu.add(new JMenuItem(this.resetFiltersAction));
            this.measuresMenuBar.add(this.measuresFiltersMenu);
            this.measuresGroupsMenu = new JMenu("Groups");
            this.measuresGroupsMenu.add(new JMenuItem(this.createGroupAction));
            this.measuresGroupsMenu.add(new JMenuItem(this.addToGroupAction));
            this.measuresGroupsMenu.add(new JMenuItem(this.renameGroupAction));
            this.measuresGroupsMenu.add(new JMenuItem(this.deleteGroupsAction));
            this.measuresGroupsMenu.add(new JMenuItem(this.showGroupsAction));
            this.measuresMenuBar.add(this.measuresGroupsMenu);
            this.measuresLayoutMenu = new JMenu("Grid");
            layoutGroup = new ButtonGroup();
            menuItem = new JRadioButtonMenuItem(this.randomAction);
            ((layoutActionClass)this.randomAction).addButton(menuItem);
            this.measuresLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            menuItem = new JRadioButtonMenuItem(this.diagonalAction);
            ((layoutActionClass)this.diagonalAction).addButton(menuItem);
            this.measuresLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            this.measuresLayoutMenu.addSeparator();
            this.measuresLayoutMenu.add(new JMenuItem(this.squareCellsAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.colourAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.randomizeAction));
            this.measuresLayoutMenu.addSeparator();
            this.measuresLayoutMenu.add(new JMenuItem(this.nodesAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.translucentAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.hollowAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.startNodeAction));
            this.measuresLayoutMenu.addSeparator();
            this.measuresLayoutMenu.add(new JMenuItem(this.transitionsAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.arrowsAction));
            this.measuresLayoutMenu.add(new JMenuItem(this.missingAction));
            this.measuresMenuBar.add(this.measuresLayoutMenu);
            this.measuresXAxisMenu = new JMenu("X Axis");
            this.measuresYAxisMenu = new JMenu("Y Axis");
            xAxisGroup = new ButtonGroup();
            yAxisGroup = new ButtonGroup();
            x = this.xAxisActions.iterator();
            y = this.yAxisActions.iterator();
            while (x.hasNext()) {
                action = (AbstractAction)x.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((xAxisActionClass)action).addButton(menuItem);
                this.measuresXAxisMenu.add(menuItem);
                xAxisGroup.add(menuItem);
                action = (AbstractAction)y.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((yAxisActionClass)action).addButton(menuItem);
                this.measuresYAxisMenu.add(menuItem);
                yAxisGroup.add(menuItem);
            }
            this.measuresMenuBar.add(this.measuresYAxisMenu);
            this.measuresMenuBar.add(this.measuresXAxisMenu);
            this.measuresRegionsMenu = new JMenu("Regions");
            this.measuresRegionsMenu.add(new JMenuItem(this.createRegionAction));
            this.measuresRegionsMenu.add(new JMenuItem(this.createCellRegionsAction));
            this.measuresRegionsMenu.add(new JMenuItem(this.renameRegionAction));
            this.measuresRegionsMenu.add(new JMenuItem(this.deleteRegionsAction));
            this.measuresRegionsMenu.add(new JMenuItem(this.showRegionsAction));
            this.measuresMenuBar.add(this.measuresRegionsMenu);
            this.measuresMeasuresMenu = new JMenu("Measures");
            this.measuresMeasuresMenu.add(new JMenuItem(this.addGridMeasureAction));
            this.measuresMeasuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
            this.measuresMenuBar.add(this.measuresMeasuresMenu);
            measures.setJMenuBar(this.measuresMenuBar);
            this.logMenuBar = new JMenuBar();
            this.logFileMenu = new JMenu("File");
            this.logFileMenu.add(new JMenuItem(this.openAction));
            this.logFileMenu.add(new JMenuItem(this.closeAction));
            this.logFileMenu.add(new JMenuItem(this.saveAction));
            this.logFileMenu.add(new JMenuItem(this.saveAsAction));
            this.logFileMenu.add(new JMenuItem(this.imageExportAction));
            this.logFileMenu.add(new JMenuItem(this.measuresExportAction));
            this.logMenuBar.add(this.logFileMenu);
            this.logFiltersMenu = new JMenu("Filters");
            this.logFiltersMenu.add(new JMenuItem(this.addFilterAction));
            this.logFiltersMenu.add(new JMenuItem(this.resetFiltersAction));
            this.logMenuBar.add(this.logFiltersMenu);
            this.logGroupsMenu = new JMenu("Groups");
            this.logGroupsMenu.add(new JMenuItem(this.createGroupAction));
            this.logGroupsMenu.add(new JMenuItem(this.addToGroupAction));
            this.logGroupsMenu.add(new JMenuItem(this.renameGroupAction));
            this.logGroupsMenu.add(new JMenuItem(this.deleteGroupsAction));
            this.logGroupsMenu.add(new JMenuItem(this.showGroupsAction));
            this.logMenuBar.add(this.logGroupsMenu);
            this.logLayoutMenu = new JMenu("Grid");
            layoutGroup = new ButtonGroup();
            menuItem = new JRadioButtonMenuItem(this.randomAction);
            ((layoutActionClass)this.randomAction).addButton(menuItem);
            this.logLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            menuItem = new JRadioButtonMenuItem(this.diagonalAction);
            ((layoutActionClass)this.diagonalAction).addButton(menuItem);
            this.logLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            this.logLayoutMenu.addSeparator();
            this.logLayoutMenu.add(new JMenuItem(this.squareCellsAction));
            this.logLayoutMenu.add(new JMenuItem(this.colourAction));
            this.logLayoutMenu.add(new JMenuItem(this.randomizeAction));
            this.logLayoutMenu.addSeparator();
            this.logLayoutMenu.add(new JMenuItem(this.nodesAction));
            this.logLayoutMenu.add(new JMenuItem(this.translucentAction));
            this.logLayoutMenu.add(new JMenuItem(this.hollowAction));
            this.logLayoutMenu.add(new JMenuItem(this.startNodeAction));
            this.logLayoutMenu.addSeparator();
            this.logLayoutMenu.add(new JMenuItem(this.transitionsAction));
            this.logLayoutMenu.add(new JMenuItem(this.arrowsAction));
            this.logLayoutMenu.add(new JMenuItem(this.missingAction));
            this.logMenuBar.add(this.logLayoutMenu);
            this.logXAxisMenu = new JMenu("X Axis");
            this.logYAxisMenu = new JMenu("Y Axis");
            xAxisGroup = new ButtonGroup();
            yAxisGroup = new ButtonGroup();
            x = this.xAxisActions.iterator();
            y = this.yAxisActions.iterator();
            while (x.hasNext()) {
                action = (AbstractAction)x.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((xAxisActionClass)action).addButton(menuItem);
                this.logXAxisMenu.add(menuItem);
                xAxisGroup.add(menuItem);
                action = (AbstractAction)y.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((yAxisActionClass)action).addButton(menuItem);
                this.logYAxisMenu.add(menuItem);
                yAxisGroup.add(menuItem);
            }
            this.logMenuBar.add(this.logYAxisMenu);
            this.logMenuBar.add(this.logXAxisMenu);
            this.logRegionsMenu = new JMenu("Regions");
            this.logRegionsMenu.add(new JMenuItem(this.createRegionAction));
            this.logRegionsMenu.add(new JMenuItem(this.createCellRegionsAction));
            this.logRegionsMenu.add(new JMenuItem(this.renameRegionAction));
            this.logRegionsMenu.add(new JMenuItem(this.deleteRegionsAction));
            this.logRegionsMenu.add(new JMenuItem(this.showRegionsAction));
            this.logMenuBar.add(this.logRegionsMenu);
            this.logMeasuresMenu = new JMenu("Measures");
            this.logMeasuresMenu.add(new JMenuItem(this.addGridMeasureAction));
            this.logMeasuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
            this.logMenuBar.add(this.logMeasuresMenu);
            boolean wasVisible = logWindow.isVisible();
            logWindow.setVisible(false);
            logWindow.setJMenuBar(this.logMenuBar);
            logWindow.setVisible(wasVisible);
            this.regionsMenuBar = new JMenuBar();
            this.regionsFileMenu = new JMenu("File");
            this.regionsFileMenu.add(new JMenuItem(this.openAction));
            this.regionsFileMenu.add(new JMenuItem(this.closeAction));
            this.regionsFileMenu.add(new JMenuItem(this.saveAction));
            this.regionsFileMenu.add(new JMenuItem(this.saveAsAction));
            this.regionsFileMenu.add(new JMenuItem(this.imageExportAction));
            this.regionsFileMenu.add(new JMenuItem(this.measuresExportAction));
            this.regionsMenuBar.add(this.regionsFileMenu);
            this.regionsFiltersMenu = new JMenu("Filters");
            this.regionsFiltersMenu.add(new JMenuItem(this.addFilterAction));
            this.regionsFiltersMenu.add(new JMenuItem(this.resetFiltersAction));
            this.regionsMenuBar.add(this.regionsFiltersMenu);
            this.regionsGroupsMenu = new JMenu("Groups");
            this.regionsGroupsMenu.add(new JMenuItem(this.createGroupAction));
            this.regionsGroupsMenu.add(new JMenuItem(this.addToGroupAction));
            this.regionsGroupsMenu.add(new JMenuItem(this.renameGroupAction));
            this.regionsGroupsMenu.add(new JMenuItem(this.deleteGroupsAction));
            this.regionsGroupsMenu.add(new JMenuItem(this.showGroupsAction));
            this.regionsMenuBar.add(this.regionsGroupsMenu);
            this.regionsLayoutMenu = new JMenu("Grid");
            layoutGroup = new ButtonGroup();
            menuItem = new JRadioButtonMenuItem(this.randomAction);
            ((layoutActionClass)this.randomAction).addButton(menuItem);
            this.regionsLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            menuItem = new JRadioButtonMenuItem(this.diagonalAction);
            ((layoutActionClass)this.diagonalAction).addButton(menuItem);
            this.regionsLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            this.regionsLayoutMenu.addSeparator();
            this.regionsLayoutMenu.add(new JMenuItem(this.squareCellsAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.colourAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.randomizeAction));
            this.regionsLayoutMenu.addSeparator();
            this.regionsLayoutMenu.add(new JMenuItem(this.nodesAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.translucentAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.hollowAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.startNodeAction));
            this.regionsLayoutMenu.addSeparator();
            this.regionsLayoutMenu.add(new JMenuItem(this.transitionsAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.arrowsAction));
            this.regionsLayoutMenu.add(new JMenuItem(this.missingAction));
            this.regionsMenuBar.add(this.regionsLayoutMenu);
            this.regionsXAxisMenu = new JMenu("X Axis");
            this.regionsYAxisMenu = new JMenu("Y Axis");
            xAxisGroup = new ButtonGroup();
            yAxisGroup = new ButtonGroup();
            x = this.xAxisActions.iterator();
            y = this.yAxisActions.iterator();
            while (x.hasNext()) {
                action = (AbstractAction)x.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((xAxisActionClass)action).addButton(menuItem);
                this.regionsXAxisMenu.add(menuItem);
                xAxisGroup.add(menuItem);
                action = (AbstractAction)y.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((yAxisActionClass)action).addButton(menuItem);
                this.regionsYAxisMenu.add(menuItem);
                yAxisGroup.add(menuItem);
            }
            this.regionsMenuBar.add(this.regionsYAxisMenu);
            this.regionsMenuBar.add(this.regionsXAxisMenu);
            this.regionsRegionsMenu = new JMenu("Regions");
            this.regionsRegionsMenu.add(new JMenuItem(this.createRegionAction));
            this.regionsRegionsMenu.add(new JMenuItem(this.createCellRegionsAction));
            this.regionsRegionsMenu.add(new JMenuItem(this.renameRegionAction));
            this.regionsRegionsMenu.add(new JMenuItem(this.deleteRegionsAction));
            this.regionsRegionsMenu.add(new JMenuItem(this.showRegionsAction));
            this.regionsMenuBar.add(this.regionsRegionsMenu);
            this.regionsMeasuresMenu = new JMenu("Measures");
            this.regionsMeasuresMenu.add(new JMenuItem(this.addGridMeasureAction));
            this.regionsMeasuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
            this.regionsMenuBar.add(this.regionsMeasuresMenu);
            regionsWindow.setJMenuBar(this.regionsMenuBar);
            this.groupsMenuBar = new JMenuBar();
            this.groupsFileMenu = new JMenu("File");
            this.groupsFileMenu.add(new JMenuItem(this.openAction));
            this.groupsFileMenu.add(new JMenuItem(this.closeAction));
            this.groupsFileMenu.add(new JMenuItem(this.saveAction));
            this.groupsFileMenu.add(new JMenuItem(this.saveAsAction));
            this.groupsFileMenu.add(new JMenuItem(this.imageExportAction));
            this.groupsFileMenu.add(new JMenuItem(this.measuresExportAction));
            this.groupsMenuBar.add(this.groupsFileMenu);
            this.groupsFiltersMenu = new JMenu("Filters");
            this.groupsFiltersMenu.add(new JMenuItem(this.addFilterAction));
            this.groupsFiltersMenu.add(new JMenuItem(this.resetFiltersAction));
            this.groupsMenuBar.add(this.groupsFiltersMenu);
            this.groupsGroupsMenu = new JMenu("Groups");
            this.groupsGroupsMenu.add(new JMenuItem(this.createGroupAction));
            this.groupsGroupsMenu.add(new JMenuItem(this.addToGroupAction));
            this.groupsGroupsMenu.add(new JMenuItem(this.renameGroupAction));
            this.groupsGroupsMenu.add(new JMenuItem(this.deleteGroupsAction));
            this.groupsGroupsMenu.add(new JMenuItem(this.showGroupsAction));
            this.groupsMenuBar.add(this.groupsGroupsMenu);
            this.groupsLayoutMenu = new JMenu("Grid");
            layoutGroup = new ButtonGroup();
            menuItem = new JRadioButtonMenuItem(this.randomAction);
            ((layoutActionClass)this.randomAction).addButton(menuItem);
            this.groupsLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            menuItem = new JRadioButtonMenuItem(this.diagonalAction);
            ((layoutActionClass)this.diagonalAction).addButton(menuItem);
            this.groupsLayoutMenu.add(menuItem);
            layoutGroup.add(menuItem);
            this.groupsLayoutMenu.addSeparator();
            this.groupsLayoutMenu.add(new JMenuItem(this.squareCellsAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.colourAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.randomizeAction));
            this.groupsLayoutMenu.addSeparator();
            this.groupsLayoutMenu.add(new JMenuItem(this.nodesAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.translucentAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.hollowAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.startNodeAction));
            this.groupsLayoutMenu.addSeparator();
            this.groupsLayoutMenu.add(new JMenuItem(this.transitionsAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.arrowsAction));
            this.groupsLayoutMenu.add(new JMenuItem(this.missingAction));
            this.groupsMenuBar.add(this.groupsLayoutMenu);
            this.groupsXAxisMenu = new JMenu("X Axis");
            this.groupsYAxisMenu = new JMenu("Y Axis");
            xAxisGroup = new ButtonGroup();
            yAxisGroup = new ButtonGroup();
            x = this.xAxisActions.iterator();
            y = this.yAxisActions.iterator();
            while (x.hasNext()) {
                action = (AbstractAction)x.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((xAxisActionClass)action).addButton(menuItem);
                this.groupsXAxisMenu.add(menuItem);
                xAxisGroup.add(menuItem);
                action = (AbstractAction)y.next();
                menuItem = new JRadioButtonMenuItem(action);
                ((yAxisActionClass)action).addButton(menuItem);
                this.groupsYAxisMenu.add(menuItem);
                yAxisGroup.add(menuItem);
            }
            this.groupsMenuBar.add(this.groupsYAxisMenu);
            this.groupsMenuBar.add(this.groupsXAxisMenu);
            this.groupsRegionsMenu = new JMenu("Regions");
            this.groupsRegionsMenu.add(new JMenuItem(this.createRegionAction));
            this.groupsRegionsMenu.add(new JMenuItem(this.createCellRegionsAction));
            this.groupsRegionsMenu.add(new JMenuItem(this.renameRegionAction));
            this.groupsRegionsMenu.add(new JMenuItem(this.deleteRegionsAction));
            this.groupsRegionsMenu.add(new JMenuItem(this.showRegionsAction));
            this.groupsMenuBar.add(this.groupsRegionsMenu);
            this.groupsMeasuresMenu = new JMenu("Measures");
            this.groupsMeasuresMenu.add(new JMenuItem(this.addGridMeasureAction));
            this.groupsMeasuresMenu.add(new JMenuItem(this.addRegionMeasureAction));
            this.groupsMenuBar.add(this.groupsMeasuresMenu);
            groupsWindow.setJMenuBar(this.groupsMenuBar);
        }
    }

    public static long timeSinceStart() {
        return new Date().getTime() - startTime;
    }

    public class aboutActionClass
    extends AbstractAction {
        public aboutActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.about();
        }
    }

    public class addFilterActionClass
    extends AbstractAction {
        public addFilterActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            filters.addFilter();
        }
    }

    public class addGridMeasureActionClass
    extends AbstractAction {
        public addGridMeasureActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            measures.addGridMeasure();
        }
    }

    public class addRegionMeasureActionClass
    extends AbstractAction {
        public addRegionMeasureActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            measures.addRegionMeasure();
        }
    }

    public class arrowsActionClass
    extends AbstractAction {
        public arrowsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.drawArrows) {
                Trajectory.drawArrows = false;
                this.putValue("Name", "Show Arrows");
                gridWindow.repaint();
            } else {
                Trajectory.drawArrows = true;
                this.putValue("Name", "Hide Arrows");
                gridWindow.repaint();
            }
        }
    }

    public class closeActionClass
    extends AbstractAction {
        public closeActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.close(true);
        }
    }

    public class colourActionClass
    extends AbstractAction {
        public colourActionClass(String text) {
            super(text);
        }

        public colourActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            Colour newColour = Colour.getColour(JColorChooser.showDialog(gridWindow, "Choose Colour", Color.blue));
            if (newColour != null) {
                gridWindow.colourTrajectories(newColour);
                gridWindow.repaint();
                GridWare.setSomethingToSave(true);
            }
        }
    }

    public class createCellRegionsActionClass
    extends AbstractAction {
        public createCellRegionsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.createCellRegions();
        }
    }

    public class createRegionActionClass
    extends AbstractAction {
        public createRegionActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.createRegion();
        }
    }

    public class deleteRegionsActionClass
    extends AbstractAction {
        public deleteRegionsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.deleteRegions();
        }
    }

    public class filtersActionClass
    extends AbstractAction {
        public filtersActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (filters.isVisible()) {
                GridWare.this.hideFilters();
                this.putValue("Name", "Show Filters");
            } else {
                GridWare.this.showFilters();
                this.putValue("Name", "Hide Filters");
            }
        }
    }

    public class hollowActionClass
    extends AbstractAction {
        public hollowActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.hollowNodes) {
                Trajectory.hollowNodes = false;
                this.putValue("Name", "Hollow Nodes");
                gridWindow.repaint();
            } else {
                Trajectory.hollowNodes = true;
                this.putValue("Name", "Filled Nodes");
                gridWindow.repaint();
            }
        }
    }

    public class imageExportActionClass
    extends AbstractAction {
        public imageExportActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file = GridWare.selectOutputFile();
                if (file != null) {
                    if (file.getPath().endsWith(".png")) {
                        gridWindow.imageExport(file);
                    } else {
                        gridWindow.imageExport(new File(String.valueOf(file.getPath()) + ".png"));
                    }
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                GridWare.quitDueToError(ex.getMessage());
            }
        }
    }

    public class layoutActionClass
    extends AbstractAction {
        Set buttons;

        public layoutActionClass(String text) {
            super(text);
            this.buttons = new HashSet();
        }

        public layoutActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.buttons = new HashSet();
            this.putValue("AcceleratorKey", shortcut);
        }

        public void addButton(AbstractButton b) {
            this.buttons.add(b);
        }

        public void actionPerformed(ActionEvent e) {
            if (((String)this.getValue("Name")).equals("Random Layout")) {
                gridWindow.setNodeLayout(0);
                GridWare.this.randomizeAction.setEnabled(true);
                if (macPlatform) {
                    Iterator i = this.buttons.iterator();
                    while (i.hasNext()) {
                        ((AbstractButton)i.next()).setSelected(true);
                    }
                }
            } else if (((String)this.getValue("Name")).equals("Diagonal Layout")) {
                gridWindow.setNodeLayout(1);
                GridWare.this.randomizeAction.setEnabled(false);
                if (macPlatform) {
                    Iterator i = this.buttons.iterator();
                    while (i.hasNext()) {
                        ((AbstractButton)i.next()).setSelected(true);
                    }
                }
            } else if (((String)this.getValue("Name")).equals("Randomize Nodes")) {
                gridWindow.randomizeNodes();
                gridWindow.repaint();
                GridWare.setSomethingToSave(true);
            }
        }
    }

    public class measuresActionClass
    extends AbstractAction {
        public measuresActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (GridWindow.measures.isVisible()) {
                GridWare.this.hideMeasures();
                this.putValue("Name", "Show Measures");
            } else {
                GridWare.this.showMeasures();
                this.putValue("Name", "Hide Measures");
            }
        }
    }

    public class measuresExportActionClass
    extends AbstractAction {
        public measuresExportActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            GridWindow.measuresExportDialog.setVisible(true);
        }
    }

    public class missingActionClass
    extends AbstractAction {
        public missingActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.drawMissing) {
                Trajectory.drawMissing = false;
                this.putValue("Name", "Show Missing");
                gridWindow.repaint();
            } else {
                Trajectory.drawMissing = true;
                this.putValue("Name", "Hide Missing");
                gridWindow.repaint();
            }
        }
    }

    public class newActionClass
    extends AbstractAction {
        public newActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            if (GridWare.this.close(true)) {
                gridWindow = new GridWindow();
                GridWare.this.openDataFile(GridWare.selectInputFile());
            }
        }
    }

    public class nodesActionClass
    extends AbstractAction {
        public nodesActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.drawNodes) {
                Trajectory.drawNodes = false;
                this.putValue("Name", "Show Event Nodes");
                gridWindow.repaint();
            } else {
                Trajectory.drawNodes = true;
                this.putValue("Name", "Hide Event Nodes");
                gridWindow.repaint();
            }
        }
    }

    public class openActionClass
    extends AbstractAction {
        public openActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            if (GridWare.this.close(true)) {
                gridWindow = new GridWindow();
                GridWare.this.openDataFile(GridWare.selectInputFile());
            }
        }
    }

    public class preferencesActionClass
    extends AbstractAction {
        public preferencesActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.preferences();
        }
    }

    public class printActionClass
    extends AbstractAction {
        public printActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.print();
        }
    }

    public class quitActionClass
    extends AbstractAction {
        public quitActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.quit(true);
        }
    }

    public class renameRegionActionClass
    extends AbstractAction {
        public renameRegionActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.renameRegion();
        }
    }

    public class resetFiltersActionClass
    extends AbstractAction {
        public resetFiltersActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            filters.resetFilters();
        }
    }

    public class saveActionClass
    extends AbstractAction {
        public saveActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.saveState(false);
        }
    }

    public class saveAsActionClass
    extends AbstractAction {
        public saveAsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            GridWare.this.saveState(true);
        }
    }

    public class showRegionsActionClass
    extends AbstractAction {
        public showRegionsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            regionsWindow.setVisible(true);
        }
    }

    public class squareCellsActionClass
    extends AbstractAction {
        public squareCellsActionClass(String text, KeyStroke shortcut) {
            super(text);
            this.putValue("AcceleratorKey", shortcut);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.squareCells();
        }
    }

    public class startNodeActionClass
    extends AbstractAction {
        public startNodeActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.markStartNode) {
                Trajectory.markStartNode = false;
                this.putValue("Name", "Mark Start Node");
                gridWindow.repaint();
            } else {
                Trajectory.markStartNode = true;
                this.putValue("Name", "Unmark Start Node");
                gridWindow.repaint();
            }
        }
    }

    public class transitionsActionClass
    extends AbstractAction {
        public transitionsActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.drawTransitions) {
                Trajectory.drawTransitions = false;
                this.putValue("Name", "Show Transitions");
                gridWindow.repaint();
            } else {
                Trajectory.drawTransitions = true;
                this.putValue("Name", "Hide Transitions");
                gridWindow.repaint();
            }
        }
    }

    public class translucentActionClass
    extends AbstractAction {
        public translucentActionClass(String text) {
            super(text);
        }

        public void actionPerformed(ActionEvent e) {
            if (Trajectory.translucentNodes) {
                Trajectory.translucentNodes = false;
                this.putValue("Name", "Translucent Nodes");
                gridWindow.repaint();
            } else {
                Trajectory.translucentNodes = true;
                this.putValue("Name", "Opaque Nodes");
                gridWindow.repaint();
            }
        }
    }

    public class xAxisActionClass
    extends AbstractAction {
        Variable xVariable;
        Set buttons;

        public xAxisActionClass(Variable v) {
            super(v.label);
            this.buttons = new HashSet();
            this.xVariable = v;
        }

        public void addButton(AbstractButton b) {
            this.buttons.add(b);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.setXVariable(this.xVariable);
            if (macPlatform) {
                Iterator i = this.buttons.iterator();
                while (i.hasNext()) {
                    ((AbstractButton)i.next()).setSelected(true);
                }
            }
        }
    }

    public class yAxisActionClass
    extends AbstractAction {
        Variable yVariable;
        Set buttons;

        public yAxisActionClass(Variable v) {
            super(v.label);
            this.buttons = new HashSet();
            this.yVariable = v;
        }

        public void addButton(AbstractButton b) {
            this.buttons.add(b);
        }

        public void actionPerformed(ActionEvent e) {
            gridWindow.setYVariable(this.yVariable);
            if (macPlatform) {
                Iterator i = this.buttons.iterator();
                while (i.hasNext()) {
                    ((AbstractButton)i.next()).setSelected(true);
                }
            }
        }
    }
}

