/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellPanel;
import GridWare.CellSet;
import GridWare.Colour;
import GridWare.DyadEvent;
import GridWare.EditableLabel;
import GridWare.Filter;
import GridWare.Grid;
import GridWare.GridWare;
import GridWare.GroupsWindow;
import GridWare.IOHandler;
import GridWare.IntVariable;
import GridWare.MeasuresExportDialog;
import GridWare.MeasuresWindow;
import GridWare.PiecemealFilter;
import GridWare.RangeFilter;
import GridWare.RegionsWindow;
import GridWare.StringVariable;
import GridWare.Trajectory;
import GridWare.TrajectorySet;
import GridWare.ValueLabel;
import GridWare.Variable;
import GridWare.XAxis;
import GridWare.YAxis;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class GridWindow
extends JFrame
implements ActionListener,
Observer,
Printable {
    Container contentPane;
    static JLabel gridTitle;
    static XAxis xAxis;
    static YAxis yAxis;
    static MeasuresWindow measures;
    static MeasuresExportDialog measuresExportDialog;
    static RegionsWindow regionsWindow;
    static GroupsWindow groupsWindow;
    GridBagLayout layout;
    GridBagConstraints xAxisConstraints;
    GridBagConstraints yAxisConstraints;
    Font titleFont = new Font("sansserif", 1, 24);
    int minTitleFontSize = 14;
    static Variable xVariable;
    static Variable yVariable;
    Set filters = new HashSet();
    static int minTime;
    static int maxTime;
    static TrajectorySet allTrajectories;
    static TrajectorySet visibleTrajectories;
    int nodeLayout = 0;
    static int numCols;
    static int numRows;
    static Grid grid;
    static CellPanel[][][][] allCells;
    static CellPanel[][] cells;
    private Color evenColour = new Color(0.75f, 0.75f, 0.75f);
    private Color oddColour = new Color(0.85f, 0.85f, 0.85f);
    boolean cellsSquared = false;
    static CellSet selectedCells;
    static CellSet depCells;
    static CellSet destCells;
    static double transBin;
    NumberFormat nf;
    static boolean allowMissingValues;
    static String missingValue;
    static boolean reportGrid;
    static boolean reportRegions;
    static boolean reportTransitions;
    static boolean reportTrasitionsReady;
    static boolean reportIndividualTrajectories;
    static boolean reportGroups;
    static boolean reportTimeSegment;
    static boolean reportDuration;
    static boolean reportEvents;
    static boolean reportVisits;
    static boolean reportRange;
    static boolean reportDispersion;
    static boolean reportDurPerEvent;
    static boolean reportDurPerVisit;
    static boolean reportDurPerCell;
    static boolean reportReturnTime;
    static boolean reportReturnVisits;
    static boolean reportFirstEntry;
    static boolean reportLastExit;
    static boolean reportEntropyMeasures;
    static MouseAdapter cellListener;

    static {
        selectedCells = new CellSet();
        depCells = new CellSet();
        destCells = new CellSet();
        transBin = -1.0;
        allowMissingValues = true;
        missingValue = "--";
        reportGrid = true;
        reportRegions = true;
        reportTransitions = true;
        reportTrasitionsReady = true;
        reportIndividualTrajectories = true;
        reportGroups = true;
        reportTimeSegment = false;
        reportDuration = true;
        reportEvents = true;
        reportVisits = true;
        reportRange = true;
        reportDispersion = true;
        reportDurPerEvent = true;
        reportDurPerVisit = true;
        reportDurPerCell = true;
        reportReturnTime = true;
        reportReturnVisits = true;
        reportFirstEntry = true;
        reportLastExit = true;
        reportEntropyMeasures = true;
        cellListener = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Component source = e.getComponent();
                if (source instanceof CellPanel) {
                    regionsWindow.clearSelection();
                    CellPanel cell = (CellPanel)e.getSource();
                    boolean wasSelected = cell.getSelected();
                    boolean onlyCellSelected = false;
                    if (wasSelected && selectedCells.size() == 1) {
                        onlyCellSelected = true;
                    }
                    if (!e.isShiftDown()) {
                        Iterator i = selectedCells.iterator();
                        while (i.hasNext()) {
                            ((CellPanel)i.next()).setSelected(false);
                        }
                        selectedCells.clear();
                    } else if (wasSelected) {
                        cell.setSelected(false);
                        selectedCells.remove(cell);
                    }
                    if (!wasSelected || !onlyCellSelected && !e.isShiftDown()) {
                        cell.setSelected(true);
                        selectedCells.add(cell);
                    }
                    cell.setBorder();
                    int x = cell.x;
                    int y = cell.y;
                    cell = GridWindow.getCell(x - 1, y);
                    if (cell != null) {
                        cell.setBorder();
                    }
                    if ((cell = GridWindow.getCell(x + 1, y)) != null) {
                        cell.setBorder();
                    }
                    if ((cell = GridWindow.getCell(x, y - 1)) != null) {
                        cell.setBorder();
                    }
                    if ((cell = GridWindow.getCell(x, y + 1)) != null) {
                        cell.setBorder();
                    }
                    grid.repaint();
                    GridWindow.takeMeasures();
                } else if (source instanceof JLabel && !e.isAltDown()) {
                    regionsWindow.clearSelection();
                    if (source instanceof EditableLabel) {
                        CellPanel cell;
                        int x = xVariable.getIndex(((EditableLabel)source).value);
                        boolean columnSelected = true;
                        boolean onlyColumnSelected = false;
                        int r = 0;
                        while (r < numRows) {
                            if (!cells[x][r].getSelected()) {
                                columnSelected = false;
                            }
                            ++r;
                        }
                        if (columnSelected && selectedCells.size() == numRows) {
                            onlyColumnSelected = true;
                        }
                        if (!e.isShiftDown()) {
                            Iterator i = selectedCells.iterator();
                            while (i.hasNext()) {
                                ((CellPanel)i.next()).setSelected(false);
                            }
                            selectedCells.clear();
                            if (!onlyColumnSelected) {
                                r = 0;
                                while (r < numRows) {
                                    cell = cells[x][r];
                                    cell.setSelected(true);
                                    selectedCells.add(cell);
                                    ++r;
                                }
                            }
                        } else if (columnSelected) {
                            r = 0;
                            while (r < numRows) {
                                cell = cells[x][r];
                                cell.setSelected(false);
                                selectedCells.remove(cell);
                                ++r;
                            }
                        } else {
                            r = 0;
                            while (r < numRows) {
                                cell = cells[x][r];
                                if (!cell.getSelected()) {
                                    cell.setSelected(true);
                                    selectedCells.add(cell);
                                }
                                ++r;
                            }
                        }
                        r = 0;
                        while (r < numRows) {
                            cell = GridWindow.getCell(x - 1, r);
                            if (cell != null) {
                                cell.setBorder();
                            }
                            if ((cell = GridWindow.getCell(x, r)) != null) {
                                cell.setBorder();
                            }
                            if ((cell = GridWindow.getCell(x + 1, r)) != null) {
                                cell.setBorder();
                            }
                            ++r;
                        }
                    } else if (source instanceof ValueLabel) {
                        CellPanel cell;
                        int y = yVariable.getIndex(((ValueLabel)source).value);
                        boolean rowSelected = true;
                        boolean onlyRowSelected = false;
                        int c = 0;
                        while (c < numCols) {
                            if (!cells[c][y].getSelected()) {
                                rowSelected = false;
                            }
                            ++c;
                        }
                        if (rowSelected && selectedCells.size() == numCols) {
                            onlyRowSelected = true;
                        }
                        if (!e.isShiftDown()) {
                            Iterator i = selectedCells.iterator();
                            while (i.hasNext()) {
                                ((CellPanel)i.next()).setSelected(false);
                            }
                            selectedCells.clear();
                            if (!onlyRowSelected) {
                                c = 0;
                                while (c < numCols) {
                                    cell = cells[c][y];
                                    cell.setSelected(true);
                                    selectedCells.add(cell);
                                    ++c;
                                }
                            }
                        } else if (rowSelected) {
                            c = 0;
                            while (c < numCols) {
                                cell = cells[c][y];
                                cell.setSelected(false);
                                selectedCells.remove(cell);
                                ++c;
                            }
                        } else {
                            c = 0;
                            while (c < numCols) {
                                cell = cells[c][y];
                                if (!cell.getSelected()) {
                                    cell.setSelected(true);
                                    selectedCells.add(cell);
                                }
                                ++c;
                            }
                        }
                        c = 0;
                        while (c < numCols) {
                            cell = GridWindow.getCell(c, y - 1);
                            if (cell != null) {
                                cell.setBorder();
                            }
                            if ((cell = GridWindow.getCell(c, y)) != null) {
                                cell.setBorder();
                            }
                            if ((cell = GridWindow.getCell(c, y + 1)) != null) {
                                cell.setBorder();
                            }
                            ++c;
                        }
                    }
                    grid.repaint();
                    GridWindow.takeMeasures();
                }
            }
        };
    }

    public void selectRegion(CellSet r) {
        Iterator i = selectedCells.iterator();
        while (i.hasNext()) {
            ((CellPanel)i.next()).setSelected(false);
        }
        selectedCells.clear();
        if (r != null) {
            GridWindow.selectedCells.regionName = r.regionName;
            for (CellPanel cell : r) {
                cell.setSelected(true);
                selectedCells.add(cell);
            }
        }
        int x = 0;
        while (x < numCols) {
            int y = 0;
            while (y < numRows) {
                GridWindow.getCell(x, y).setBorder();
                ++y;
            }
            ++x;
        }
        grid.repaint();
        GridWindow.takeMeasures();
    }

    public void selectRegions(Object[] regions) {
        Iterator i = selectedCells.iterator();
        while (i.hasNext()) {
            ((CellPanel)i.next()).setSelected(false);
        }
        selectedCells.clear();
        int j = 0;
        while (j < regions.length) {
            CellSet curRegion = (CellSet)regions[j];
            for (CellPanel cell : curRegion) {
                cell.setSelected(true);
                selectedCells.add(cell);
            }
            ++j;
        }
        int x = 0;
        while (x < numCols) {
            int y = 0;
            while (y < numRows) {
                GridWindow.getCell(x, y).setBorder(regions);
                ++y;
            }
            ++x;
        }
        grid.repaint();
        GridWindow.takeMeasures();
    }

    public void createRegion() {
        regionsWindow.addRegion(selectedCells);
        regionsWindow.setVisible(true);
    }

    public void createCellRegions() {
        int x = 0;
        while (x < numCols) {
            int y = 0;
            while (y < numRows) {
                CellPanel curCell = GridWindow.getCell(x, y);
                CellSet curRegion = new CellSet();
                curRegion.add(curCell);
                regionsWindow.addRegion(curRegion, curCell.toString());
                ++y;
            }
            ++x;
        }
        regionsWindow.setVisible(true);
    }

    public void deleteRegions() {
        if (regionsWindow.isVisible()) {
            regionsWindow.deleteRegions();
        } else {
            JOptionPane.showMessageDialog(this, "Show Regions Window first.");
        }
    }

    public void renameRegion() {
        if (regionsWindow.isVisible()) {
            regionsWindow.renameRegion();
        } else {
            JOptionPane.showMessageDialog(this, "Show Regions Window first.");
        }
    }

    public void selectGroup(TrajectorySet g) {
        if (g != null) {
            visibleTrajectories = new TrajectorySet((Collection)g);
        }
        grid.repaint();
        GridWindow.takeMeasures();
    }

    public void selectGroups(Object[] groups) {
        visibleTrajectories = new TrajectorySet();
        int j = 0;
        while (j < groups.length) {
            visibleTrajectories.addAll((TrajectorySet)groups[j]);
            ++j;
        }
        grid.repaint();
        GridWindow.takeMeasures();
    }

    public void createGroup() {
        groupsWindow.addGroup(visibleTrajectories);
        groupsWindow.setVisible(true);
    }

    public void addToGroup() {
        groupsWindow.addToGroup(visibleTrajectories);
        groupsWindow.setVisible(true);
    }

    public void deleteGroups() {
        if (groupsWindow.isVisible()) {
            groupsWindow.deleteGroups();
        } else {
            JOptionPane.showMessageDialog(this, "Show Groups Window first.");
        }
    }

    public void renameGroup() {
        if (groupsWindow.isVisible()) {
            groupsWindow.renameGroup();
        } else {
            JOptionPane.showMessageDialog(this, "Show Groups Window first.");
        }
    }

    public GridWindow() {
        super("GridWare");
        this.contentPane = this.getContentPane();
        ((JPanel)this.contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.nf = NumberFormat.getInstance();
    }

    public static void init() {
        allowMissingValues = true;
        missingValue = "--";
        reportGrid = true;
        reportRegions = true;
        reportTransitions = true;
        reportIndividualTrajectories = true;
        reportGroups = true;
        reportTimeSegment = false;
        reportDuration = true;
        reportEvents = true;
        reportVisits = true;
        reportRange = true;
        reportDispersion = true;
        reportDurPerEvent = true;
        reportDurPerVisit = true;
        reportDurPerCell = true;
        reportReturnTime = true;
        reportReturnVisits = true;
        reportFirstEntry = true;
        reportLastExit = true;
        selectedCells = new CellSet();
        depCells = new CellSet();
        destCells = new CellSet();
    }

    public void setupGrid(BufferedReader trajReader, String trajFolderName) {
        Iterator allVariables = DyadEvent.getStateVariables().iterator();
        if (allVariables.hasNext()) {
            xVariable = (Variable)allVariables.next();
            yVariable = allVariables.hasNext() ? (Variable)allVariables.next() : xVariable;
        } else {
            throw new IllegalStateException("There must be at least one state variable defined before a grid can be created.");
        }
        GridBagConstraints gbc = new GridBagConstraints();
        this.layout = new GridBagLayout();
        this.contentPane.setLayout(this.layout);
        Component topLeftFiller = Box.createRigidArea(new Dimension(50, 50));
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.layout.setConstraints(topLeftFiller, gbc);
        this.contentPane.add(topLeftFiller);
        gridTitle = new JLabel("", 0);
        gridTitle.setFont(this.titleFont);
        FontMetrics fm = gridTitle.getFontMetrics(this.titleFont.deriveFont((float)this.minTitleFontSize));
        int titleHeight = 3 * fm.getHeight();
        gridTitle.setMaximumSize(new Dimension(Integer.MAX_VALUE, titleHeight));
        gridTitle.setPreferredSize(new Dimension(400, titleHeight));
        gridTitle.setSize(new Dimension(400, titleHeight));
        gridTitle.setHorizontalAlignment(0);
        gridTitle.setVerticalAlignment(1);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.layout.setConstraints(gridTitle, gbc);
        this.contentPane.add(gridTitle);
        this.yAxisConstraints = new GridBagConstraints();
        this.yAxisConstraints.gridx = 0;
        this.yAxisConstraints.gridy = 1;
        this.yAxisConstraints.fill = 3;
        this.yAxisConstraints.anchor = 13;
        this.yAxisConstraints.weightx = 0.0;
        this.yAxisConstraints.weighty = 1.0;
        yAxis = new YAxis(yVariable);
        this.layout.setConstraints(yAxis, this.yAxisConstraints);
        this.contentPane.add(yAxis);
        this.xAxisConstraints = new GridBagConstraints();
        this.xAxisConstraints.gridx = 1;
        this.xAxisConstraints.gridy = 2;
        this.xAxisConstraints.fill = 2;
        this.xAxisConstraints.anchor = 11;
        this.xAxisConstraints.weightx = 1.0;
        this.xAxisConstraints.weighty = 0.0;
        xAxis = new XAxis(xVariable);
        this.layout.setConstraints(xAxis, this.xAxisConstraints);
        this.contentPane.add(xAxis);
        Component bottomLeftFiller = Box.createRigidArea(new Dimension(50, 50));
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        this.layout.setConstraints(bottomLeftFiller, gbc);
        this.contentPane.add(bottomLeftFiller);
        grid = new Grid(this);
        grid.setOpaque(false);
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 1;
        gbc.anchor = 16;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.layout.setConstraints(grid, gbc);
        this.contentPane.add(grid);
        this.createCells();
        RegionsWindow.init();
        this.setCells();
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (allTrajectories != null) {
                    allTrajectories.updateNodePositions();
                }
            }
        });
        allTrajectories = new TrajectorySet(trajReader, trajFolderName);
        allTrajectories.run();
        visibleTrajectories = new TrajectorySet((Collection)allTrajectories);
        GroupsWindow.gridWindow = this;
        GroupsWindow.init();
        this.setGridTitle(gridTitle.getText());
        measures = new MeasuresWindow();
        measuresExportDialog = new MeasuresExportDialog(this);
    }

    public boolean isOptimizedDrawingEnabled() {
        return false;
    }

    public void close() {
        if (visibleTrajectories != null) {
            visibleTrajectories.clear();
        }
        if (allTrajectories != null) {
            allTrajectories.clear();
        }
        if (selectedCells != null) {
            selectedCells.clear();
        }
        if (measures != null) {
            measures.setVisible(false);
        }
        if (this.contentPane != null) {
            if (gridTitle != null) {
                this.contentPane.remove(gridTitle);
            }
            if (xAxis != null) {
                this.contentPane.remove(xAxis);
            }
            if (yAxis != null) {
                this.contentPane.remove(yAxis);
            }
            if (grid != null) {
                this.contentPane.remove(grid);
            }
        }
        if (cells != null && grid != null) {
            int c = 0;
            while (c < numCols) {
                int r = 0;
                while (r < numRows) {
                    grid.remove(cells[c][r]);
                    ++r;
                }
                ++c;
            }
        }
        cells = null;
        grid = null;
        measures = null;
        gridTitle = null;
        xAxis = null;
        yAxis = null;
        this.filters = null;
        xVariable = null;
        yVariable = null;
    }

    public void createCells() {
        int numStateVars = DyadEvent.stateVars.size();
        allCells = new CellPanel[numStateVars][numStateVars][][];
        int i = 0;
        while (i < numStateVars) {
            int numXValues = ((Variable)DyadEvent.stateVars.get(i)).numValues();
            int j = 0;
            while (j < numStateVars) {
                int numYValues = ((Variable)DyadEvent.stateVars.get(j)).numValues();
                GridWindow.allCells[i][j] = new CellPanel[numXValues][numYValues];
                int c = 0;
                while (c < numXValues) {
                    boolean even = c % 2 == 0;
                    int r = 0;
                    while (r < numYValues) {
                        GridWindow.allCells[i][j][c][r] = new CellPanel(c, r, even ? this.evenColour : this.oddColour, new Dimension(400 / numXValues, 400 / numYValues), cellListener);
                        even = !even;
                        ++r;
                    }
                    ++c;
                }
                ++j;
            }
            ++i;
        }
    }

    public void setCells() {
        selectedCells.clear();
        if (cells != null) {
            int c = 0;
            while (c < numCols) {
                int r = 0;
                while (r < numRows) {
                    grid.remove(cells[c][r]);
                    cells[c][r].setSelected(false);
                    ++r;
                }
                ++c;
            }
        }
        cells = allCells[DyadEvent.stateVars.indexOf(xVariable)][DyadEvent.stateVars.indexOf(yVariable)];
        numCols = xVariable.numValues();
        numRows = yVariable.numValues();
        RegionsWindow.setRegionList(xVariable, yVariable);
        grid.setLayout(new GridLayout(numRows, numCols));
        int r = numRows - 1;
        while (r >= 0) {
            int c = 0;
            while (c < numCols) {
                CellPanel curCell = cells[c][r];
                grid.add(curCell);
                ++c;
            }
            --r;
        }
        this.validate();
    }

    public void setXVariable(Variable xVar) {
        xVariable = xVar;
        this.contentPane.remove(xAxis);
        xAxis = new XAxis(xVariable);
        this.layout.setConstraints(xAxis, this.xAxisConstraints);
        this.contentPane.add(xAxis);
        this.setCells();
        if (GridWare.readyToMeasure) {
            allTrajectories.updateNodes();
            this.setGridTitle(gridTitle.getText());
            this.validate();
            this.repaint();
            GridWindow.takeMeasures();
        }
    }

    public void setYVariable(Variable yVar) {
        yVariable = yVar;
        this.contentPane.remove(yAxis);
        yAxis = new YAxis(yVariable);
        this.layout.setConstraints(yAxis, this.yAxisConstraints);
        this.contentPane.add(yAxis);
        this.setCells();
        if (GridWare.readyToMeasure) {
            allTrajectories.updateNodes();
            this.setGridTitle(gridTitle.getText());
            this.validate();
            this.repaint();
            GridWindow.takeMeasures();
        }
    }

    public static void updateYAxisLabels() {
        yAxis.updateLabels();
    }

    public static synchronized void takeMeasures() {
        visibleTrajectories.takeMeasures(xVariable, yVariable, selectedCells, minTime, maxTime);
        transBin = Trajectory.minDuration;
        if (selectedCells.size() > 0) {
            measures.enableTrans(true);
        } else {
            measures.enableTrans(false);
        }
        if (!depCells.isEmpty() && !destCells.isEmpty()) {
            visibleTrajectories.takeTransitionMeasures(xVariable, yVariable, depCells, destCells, minTime, maxTime);
            if (GridWare.measures.trajectories.TP >= 0.0 && GridWare.measures.trajectories.TP <= 1.0) {
                String tpString = NumberFormat.getInstance().format(GridWare.measures.trajectories.TP);
                String teString = NumberFormat.getInstance().format(GridWare.measures.trajectories.TE);
                GridWare.measures.transP.setText(tpString);
                GridWare.measures.transE.setText(teString);
            } else {
                GridWare.measures.transP.setText("N/A");
                GridWare.measures.transE.setText("N/A");
            }
        } else {
            GridWare.measures.transP.setText("N/A");
            GridWare.measures.transE.setText("N/A");
        }
        measures.updateValues(visibleTrajectories);
        transBin = Trajectory.minDuration;
        NumberFormat nf = NumberFormat.getInstance();
        GridWindow.measures.transLagValue.setText(nf.format(transBin));
    }

    public Filter createFilter(Variable sortVariable) {
        Filter filter;
        if (sortVariable instanceof IntVariable) {
            filter = new RangeFilter(sortVariable, allTrajectories);
        } else if (sortVariable instanceof StringVariable) {
            filter = new PiecemealFilter(sortVariable, allTrajectories);
        } else {
            throw new IllegalArgumentException("Unsupported variable type.");
        }
        this.filters.add(filter);
        filter.addObserver(this);
        return filter;
    }

    public void removeFilter(Filter filter) {
        this.filters.remove(filter);
        filter.deleteObserver(this);
    }

    public void filter() {
        visibleTrajectories = new TrajectorySet((Collection)allTrajectories);
        for (Filter curFilter : this.filters) {
            curFilter.filter(visibleTrajectories);
        }
        if (GridWare.readyToMeasure) {
            this.setGridTitle();
            GridWindow.takeMeasures();
        }
    }

    void setGridTitle() {
        this.setGridTitle(visibleTrajectories.getTitle());
    }

    void setGridTitle(String title) {
        gridTitle.setText(title);
        gridTitle.setFont(this.titleFont);
        FontMetrics fm = gridTitle.getFontMetrics(this.titleFont);
        int width = fm.stringWidth(title) + 10;
        int maxWidth = (int)gridTitle.getSize().getWidth();
        int fontSize = this.titleFont.getSize();
        Font font = this.titleFont;
        while (width > maxWidth && fontSize >= this.minTitleFontSize + 2) {
            font = font.deriveFont((float)(fontSize -= 2));
            gridTitle.setFont(font);
            fm = gridTitle.getFontMetrics(font);
            width = fm.stringWidth(title) + 10;
        }
        if (width > maxWidth && title.indexOf(44) > 0) {
            boolean textLeft = true;
            StringBuffer titleBuffer = new StringBuffer();
            int lastCommaIndex = -1;
            int nextCommaIndex = 0;
            int lineCount = 1;
            while (lineCount <= 3 && textLeft) {
                StringBuffer line = new StringBuffer();
                width = 0;
                while (width <= maxWidth && textLeft) {
                    nextCommaIndex = title.indexOf(44, lastCommaIndex + 1);
                    String nextFileName = title.substring(lastCommaIndex + 1, nextCommaIndex >= 0 ? nextCommaIndex + 1 : title.length() - 1);
                    width = fm.stringWidth(String.valueOf(line.toString()) + nextFileName);
                    if (width <= maxWidth) {
                        line.append(nextFileName);
                        lastCommaIndex = nextCommaIndex;
                        if (nextCommaIndex >= 0) continue;
                        textLeft = false;
                        continue;
                    }
                    if (lineCount != 3) continue;
                    line.append("...");
                }
                titleBuffer.append(line.toString());
                ++lineCount;
            }
            gridTitle.setText("<html>" + titleBuffer.toString());
        }
        gridTitle.validate();
    }

    public void adjustTimeBounds(int min, int max) {
        minTime = min;
        maxTime = max;
        this.repaint();
        if (GridWare.readyToMeasure) {
            GridWindow.takeMeasures();
        }
    }

    public static void selectAllCells() {
        int x = 0;
        while (x < numCols) {
            int y = 0;
            while (y < numRows) {
                CellPanel cell = cells[x][y];
                if (!cell.getSelected()) {
                    cell.setSelected(true);
                    selectedCells.add(cell);
                }
                ++y;
            }
            ++x;
        }
        grid.repaint();
        GridWindow.takeMeasures();
    }

    public void repaint() {
        if (GridWare.readyToMeasure) {
            super.repaint();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
    }

    public void paintComponents(Graphics g) {
        super.paintComponents(g);
    }

    public void print() {
        try {
            PrinterJob job = PrinterJob.getPrinterJob();
            PageFormat format = job.pageDialog(job.defaultPage());
            job.setPrintable(this, job.defaultPage());
            if (job.printDialog()) {
                job.print();
            }
        }
        catch (PrinterException ex) {
            System.err.println("Error: Couldn't print.");
        }
    }

    public int print(Graphics g, PageFormat format, int pagenum) {
        if (pagenum > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(format.getImageableX(), format.getImageableY());
        Dimension size = this.contentPane.getSize();
        double pageWidth = format.getImageableWidth();
        if ((double)size.width > pageWidth) {
            double factor = pageWidth / (double)size.width;
            g2.scale(factor, factor);
        }
        size = this.contentPane.getSize();
        double pageHeight = format.getImageableHeight();
        if ((double)size.height > pageHeight) {
            double factor = pageHeight / (double)size.height;
            g2.scale(factor, factor);
        }
        size = this.contentPane.getSize();
        g2.translate((pageWidth - (double)size.width) / 2.0, (pageHeight - (double)size.height) / 2.0);
        g2.drawRect(-1, -1, size.width + 2, size.height + 2);
        g2.setClip(0, 0, size.width, size.height);
        this.contentPane.paint(g2);
        return 0;
    }

    public void imageExport(File file) throws IOException {
        System.out.println("Exporting grid image to " + file.getPath() + "...");
        int w = this.contentPane.getWidth();
        int h = this.contentPane.getHeight();
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2 = image.createGraphics();
        this.contentPane.paint(g2);
        g2.dispose();
        ImageIO.write((RenderedImage)image, "png", file);
        image.flush();
        System.out.println("Grid image grid export finished.");
    }

    public void updateNodes() {
        if (allTrajectories != null) {
            allTrajectories.updateNodes();
        }
    }

    public void setNodeLayout(int nodeLayout) {
        this.nodeLayout = nodeLayout;
        this.repaint();
    }

    public static CellPanel getCell(int x, int y) {
        if (x >= 0 && x < numCols && y >= 0 && y < numRows) {
            return cells[x][y];
        }
        return null;
    }

    public static CellPanel getCell(DyadEvent event) {
        int x = event.getValueIndex(xVariable);
        int y = event.getValueIndex(yVariable);
        if (x >= 0 && y >= 0) {
            return cells[x][y];
        }
        return null;
    }

    public Trajectory getTrajectory(String trajName) {
        return allTrajectories.getTrajectory(trajName);
    }

    public void randomizeNodes() {
        if (visibleTrajectories != null) {
            visibleTrajectories.randomizeNodes(selectedCells);
        }
    }

    public void colourTrajectories(Colour c) {
        if (visibleTrajectories != null) {
            visibleTrajectories.colourNodes(c, selectedCells, minTime, maxTime);
        }
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void squareCells() {
        int overWidth = 0;
        int overHeight = 0;
        if (cells != null) {
            Dimension cellSize = cells[0][0].getSize();
            if (cellSize.width > cellSize.height) {
                overWidth = (cellSize.width - cellSize.height) * numCols;
            } else if (cellSize.width < cellSize.height) {
                overHeight = (cellSize.height - cellSize.width) * numRows;
            }
        }
        this.setSize(this.getSize().width - overWidth, this.getSize().height - overHeight);
    }

    public void update(Observable o, Object arg) {
        this.filter();
        if (GridWare.readyToMeasure) {
            this.repaint();
        }
    }

    public void saveTrajectories(String trajFolderName) {
        allTrajectories.save(trajFolderName);
    }

    public void exportMeasures() {
        File file = GridWare.selectOutputFile();
        if (file.getPath().endsWith(".txt")) {
            this.printMeasuresStacked(file);
        } else {
            this.printMeasuresStacked(new File(String.valueOf(file.getPath()) + ".txt"));
        }
    }

    public void printMeasuresStacked(File outFile) {
        System.out.println("Exporting measures to " + outFile.getPath() + "...");
        CellSet selectedRegions = selectedCells;
        StringBuffer output = new StringBuffer();
        IOHandler.openOutFile(outFile);
        output.append("file\t");
        Iterator i = Trajectory.getTrajectoryVariables().iterator();
        while (i.hasNext()) {
            output.append(String.valueOf(((Variable)i.next()).label) + "\t");
        }
        output.append("numTrajs\t");
        if (reportTimeSegment) {
            output.append("minTime\t");
            output.append("maxTime\t");
        }
        if (reportGrid) {
            output.append("gridCells\t");
            if (reportDuration) {
                output.append("gridDuration\t");
            }
            if (reportDuration) {
                output.append("missingDuration\t");
            }
            if (reportEvents) {
                output.append("missingEvents\t");
            }
            if (reportEvents) {
                output.append("gridEvents\t");
            }
            if (reportVisits) {
                output.append("gridVisits\t");
            }
            if (reportRange) {
                output.append("gridRangeM\t");
                output.append("gridRangeO\t");
            }
            if (reportDispersion) {
                output.append("gridDispersion\t");
            }
            if (reportEntropyMeasures) {
                output.append("gridDurEntropy\t");
                output.append("gridVisitEntropy\t");
            }
            if (reportDurPerEvent) {
                output.append("gridDurPerEvent\t");
            }
            if (reportDurPerVisit) {
                output.append("gridDurPerVisit\t");
            }
            if (reportDurPerCell) {
                output.append("gridDurPerCell\t");
            }
        }
        if (reportRegions) {
            CellSet curRegion = selectedRegions;
            String curName = curRegion.regionName;
            if (curName.equals("")) {
                curName = "Cell ";
            }
            output.append(String.valueOf(curName) + "selected\t");
            if (reportDuration) {
                output.append(String.valueOf(curName) + "Duration\t");
            }
            if (reportEvents) {
                output.append(String.valueOf(curName) + "Events\t");
            }
            if (reportVisits) {
                output.append(String.valueOf(curName) + "Visits\t");
            }
            if (reportRange) {
                output.append(String.valueOf(curName) + "RangeM\t");
                output.append(String.valueOf(curName) + "RangeO\t");
            }
            if (reportDispersion) {
                output.append(String.valueOf(curName) + "Dispersion\t");
            }
            if (reportDurPerEvent) {
                output.append(String.valueOf(curName) + "DurPerEvent\t");
            }
            if (reportDurPerVisit) {
                output.append(String.valueOf(curName) + "DurPerVisit\t");
            }
            if (reportDurPerCell) {
                output.append(String.valueOf(curName) + "DurPerCell\t");
            }
            if (reportFirstEntry) {
                output.append(String.valueOf(curName) + "FirstEntry\t");
            }
            if (reportLastExit) {
                output.append(String.valueOf(curName) + "LastExit\t");
            }
            if (reportReturnTime) {
                output.append(String.valueOf(curName) + "ReturnTime\t");
            }
            if (reportReturnVisits) {
                output.append(String.valueOf(curName) + "ReturnVisits\t");
            }
        }
        if (reportTransitions) {
            NumberFormat nf = NumberFormat.getInstance();
            output.append("Transitional Propensities(Origin: " + GridWindow.depCells.regionName + ")~(Destination: " + GridWindow.destCells.regionName + "), TransBin = " + nf.format(transBin) + "\t");
            output.append("Transitional Entropy(Origin: " + GridWindow.depCells.regionName + ")~(Destination: " + GridWindow.destCells.regionName + ")\t");
        }
        IOHandler.printToFile(String.valueOf(output.toString()) + "\n");
        if (reportGroups) {
            TrajectorySet curGroup = allTrajectories;
            output = new StringBuffer("ALL\t");
            Iterator j = Trajectory.getTrajectoryVariables().iterator();
            while (j.hasNext()) {
                output.append(String.valueOf(missingValue) + "\t");
                j.next();
            }
            output.append(String.valueOf(curGroup.size()) + "\t");
            if (reportTimeSegment) {
                output.append(String.valueOf(this.format(minTime)) + "\t");
                output.append(String.valueOf(this.format(maxTime)) + "\t");
            }
            if (reportGrid) {
                if (!reportTimeSegment) {
                    curGroup.takeMeasures(xVariable, yVariable, selectedCells, 0, (int)Math.ceil(Trajectory.maxDuration));
                } else {
                    curGroup.takeMeasures(xVariable, yVariable, selectedCells, minTime, maxTime);
                }
                output.append(String.valueOf(this.format(numRows * numCols)) + "\t");
                if (reportDuration) {
                    output.append(String.valueOf(this.format(curGroup.duration)) + "\t");
                }
                if (reportDuration) {
                    output.append(String.valueOf(this.format(curGroup.missingDuration)) + "\t");
                }
                if (reportEvents) {
                    output.append(String.valueOf(this.format(curGroup.missingEvents)) + "\t");
                }
                if (reportEvents) {
                    output.append(String.valueOf(this.format(curGroup.numEvents)) + "\t");
                }
                if (reportVisits) {
                    output.append(String.valueOf(this.format(curGroup.numVisits)) + "\t");
                }
                if (reportRange) {
                    output.append(String.valueOf(this.format(curGroup.meanRange)) + "\t");
                }
                if (reportRange) {
                    output.append(String.valueOf(this.format(curGroup.overallRange)) + "\t");
                }
                if (reportDispersion) {
                    output.append(String.valueOf(this.format(curGroup.dispersion)) + "\t");
                }
                if (reportEntropyMeasures) {
                    output.append(String.valueOf(this.format(curGroup.durEntropy)) + "\t");
                }
                if (reportEntropyMeasures) {
                    output.append(String.valueOf(this.format(curGroup.visitEntropy)) + "\t");
                }
                if (reportDurPerEvent) {
                    output.append(String.valueOf(this.format(curGroup.durPerEvent)) + "\t");
                }
                if (reportDurPerVisit) {
                    output.append(String.valueOf(this.format(curGroup.durPerVisit)) + "\t");
                }
                if (reportDurPerCell) {
                    output.append(String.valueOf(this.format(curGroup.durPerCell)) + "\t");
                }
            }
            if (reportRegions) {
                CellSet curRegion = selectedRegions;
                if (!reportTimeSegment) {
                    curGroup.takeMeasures(xVariable, yVariable, curRegion, 0, (int)Math.ceil(Trajectory.maxDuration));
                } else {
                    curGroup.takeMeasures(xVariable, yVariable, curRegion, minTime, maxTime);
                }
                output.append(String.valueOf(curRegion.size()) + "\t");
                if (reportDuration) {
                    output.append(String.valueOf(this.format(curGroup.regionDuration)) + "\t");
                }
                if (reportEvents) {
                    output.append(String.valueOf(this.format(curGroup.regionEvents)) + "\t");
                }
                if (reportVisits) {
                    output.append(String.valueOf(this.format(curGroup.regionVisits)) + "\t");
                }
                if (reportRange) {
                    output.append(String.valueOf(this.format(curGroup.regionMeanRange)) + "\t");
                }
                if (reportRange) {
                    output.append(String.valueOf(this.format(curGroup.regionOverallRange)) + "\t");
                }
                if (reportDispersion) {
                    output.append(String.valueOf(this.format(curGroup.regionDispersion)) + "\t");
                }
                if (reportDurPerEvent) {
                    output.append(String.valueOf(this.format(curGroup.regionDurPerEvent)) + "\t");
                }
                if (reportDurPerVisit) {
                    output.append(String.valueOf(this.format(curGroup.regionDurPerVisit)) + "\t");
                }
                if (reportDurPerCell) {
                    output.append(String.valueOf(this.format(curGroup.regionDurPerCell)) + "\t");
                }
                if (reportFirstEntry) {
                    output.append(String.valueOf(this.format(curGroup.regionFirstEntry)) + "\t");
                }
                if (reportLastExit) {
                    output.append(String.valueOf(this.format(curGroup.regionLastExit)) + "\t");
                }
                if (reportReturnTime) {
                    output.append(String.valueOf(this.format(curGroup.regionReturnTime)) + "\t");
                }
                if (reportReturnVisits) {
                    output.append(String.valueOf(this.format(curGroup.regionReturnVisits)) + "\t");
                }
            }
            if (reportTransitions && reportTrasitionsReady) {
                output.append(String.valueOf(this.format(curGroup.TP)) + "\t");
                output.append(String.valueOf(this.format(curGroup.TE)) + "\t");
            }
            output.append("\n");
            IOHandler.printToFile(output.toString());
        } else if (!reportTimeSegment) {
            visibleTrajectories.takeMeasures(xVariable, yVariable, selectedCells, 0, (int)Math.ceil(Trajectory.maxDuration));
        } else {
            visibleTrajectories.takeMeasures(xVariable, yVariable, selectedCells, minTime, maxTime);
        }
        if (reportIndividualTrajectories) {
            List sortedTrajectories = visibleTrajectories.getSorted();
            for (Trajectory curTraj : sortedTrajectories) {
                output = new StringBuffer(String.valueOf(curTraj.filename) + "\t");
                Iterator j = Trajectory.getTrajectoryVariables().iterator();
                while (j.hasNext()) {
                    output.append(curTraj.getValue((Variable)j.next()) + "\t");
                }
                output.append("1\t");
                if (reportTimeSegment) {
                    output.append(String.valueOf(this.format(minTime)) + "\t");
                    output.append(String.valueOf(this.format(maxTime)) + "\t");
                }
                if (reportGrid) {
                    output.append(String.valueOf(this.format(numRows * numCols)) + "\t");
                    if (reportDuration) {
                        output.append(String.valueOf(this.format(curTraj.duration)) + "\t");
                    }
                    if (reportDuration) {
                        output.append(String.valueOf(this.format(curTraj.missingDuration)) + "\t");
                    }
                    if (reportEvents) {
                        output.append(String.valueOf(this.format(curTraj.missingEvents)) + "\t");
                    }
                    if (reportEvents) {
                        output.append(String.valueOf(this.format(curTraj.numEvents)) + "\t");
                    }
                    if (reportVisits) {
                        output.append(String.valueOf(this.format(curTraj.numVisits)) + "\t");
                    }
                    if (reportRange) {
                        output.append(String.valueOf(this.format(curTraj.cellRange)) + "\t");
                    }
                    if (reportRange) {
                        output.append(String.valueOf(this.format(curTraj.cellRange)) + "\t");
                    }
                    if (reportDispersion) {
                        output.append(String.valueOf(this.format(curTraj.dispersion)) + "\t");
                    }
                    if (reportEntropyMeasures) {
                        output.append(String.valueOf(this.format(curTraj.durEntropy)) + "\t");
                    }
                    if (reportEntropyMeasures) {
                        output.append(String.valueOf(this.format(curTraj.visitEntropy)) + "\t");
                    }
                    if (reportDurPerEvent) {
                        output.append(String.valueOf(this.format(curTraj.durPerEvent)) + "\t");
                    }
                    if (reportDurPerVisit) {
                        output.append(String.valueOf(this.format(curTraj.durPerVisit)) + "\t");
                    }
                    if (reportDurPerCell) {
                        output.append(String.valueOf(this.format(curTraj.durPerCell)) + "\t");
                    }
                }
                if (reportRegions) {
                    CellSet curRegion = selectedRegions;
                    curRegion = selectedRegions;
                    if (!reportTimeSegment) {
                        curTraj.takeMeasures(xVariable, yVariable, curRegion, 0, (int)Math.ceil(Trajectory.maxDuration));
                    } else {
                        curTraj.takeMeasures(xVariable, yVariable, curRegion, minTime, maxTime);
                    }
                    output.append(String.valueOf(curRegion.size()) + "\t");
                    if (reportDuration) {
                        output.append(String.valueOf(this.format(curTraj.regionDuration)) + "\t");
                    }
                    if (reportEvents) {
                        output.append(String.valueOf(this.format(curTraj.regionEvents)) + "\t");
                    }
                    if (reportVisits) {
                        output.append(String.valueOf(this.format(curTraj.regionVisits)) + "\t");
                    }
                    if (reportRange) {
                        output.append(String.valueOf(this.format(curTraj.regionRange)) + "\t");
                    }
                    if (reportRange) {
                        output.append(String.valueOf(this.format(curTraj.regionRange)) + "\t");
                    }
                    if (reportDispersion) {
                        output.append(String.valueOf(this.format(curTraj.regionDispersion)) + "\t");
                    }
                    if (reportDurPerEvent) {
                        output.append(String.valueOf(this.format(curTraj.regionDurPerEvent)) + "\t");
                    }
                    if (reportDurPerVisit) {
                        output.append(String.valueOf(this.format(curTraj.regionDurPerVisit)) + "\t");
                    }
                    if (reportDurPerCell) {
                        output.append(String.valueOf(this.format(curTraj.regionDurPerCell)) + "\t");
                    }
                    if (reportFirstEntry) {
                        output.append(String.valueOf(this.format(curTraj.regionFirstEntry)) + "\t");
                    }
                    if (reportLastExit) {
                        output.append(String.valueOf(this.format(curTraj.regionLastExit)) + "\t");
                    }
                    if (reportReturnTime) {
                        output.append(String.valueOf(this.format(curTraj.regionReturnTime)) + "\t");
                    }
                    if (reportReturnVisits) {
                        output.append(String.valueOf(this.format(curTraj.regionReturnVisits)) + "\t");
                    }
                }
                if (reportTransitions) {
                    output.append(String.valueOf(this.format(curTraj.TP)) + "\t");
                    output.append(String.valueOf(this.format(curTraj.TE)) + "\t");
                }
                output.append("\n");
                IOHandler.printToFile(output.toString());
            }
        }
        IOHandler.closeOutFile();
        System.out.println("Measures export finished.");
    }

    public String format(double number) {
        if (number >= 0.0) {
            return this.nf.format(number);
        }
        return missingValue;
    }

    public String format(int number) {
        if (number >= 0) {
            return String.valueOf(number);
        }
        return missingValue;
    }
}

