/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.DyadEvent;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.Trajectory;
import GridWare.TrajectorySet;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class GroupsWindow
extends JFrame {
    static GridWindow gridWindow;
    Container contentPane;
    static StringBuffer groupDefinitions;
    static Vector groups;
    static JList groupList;
    JScrollPane scrollPane;
    ListSelectionListener listListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent evt) {
            JList source = (JList)evt.getSource();
            gridWindow.selectGroups(source.getSelectedValues());
        }
    };

    static {
        groupDefinitions = new StringBuffer("");
    }

    public static List getSelectedGroups() {
        return Arrays.asList(groupList.getSelectedValues());
    }

    public static void clearSelection() {
        groupList.clearSelection();
    }

    public static void init() {
        groupList = new JList();
        groups = new Vector();
        BufferedReader br = new BufferedReader(new StringReader(groupDefinitions.toString()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line, "\t");
                st.nextToken();
                TrajectorySet curGroup = new TrajectorySet();
                curGroup.groupName = st.nextToken();
                while (st.hasMoreTokens()) {
                    String trajName = st.nextToken();
                    Trajectory curTraj = gridWindow.getTrajectory(trajName);
                    if (curTraj != null) {
                        curGroup.add(curTraj);
                        continue;
                    }
                    System.err.println("Trajectory not found: " + trajName);
                }
                groups.add(curGroup);
            }
            br.close();
            groupList.setListData(groups);
        }
        catch (IOException ex) {
            System.err.println("IOException while parsing groupDefinitions String.  File was already read, however, so I don't see how this could happen.");
        }
    }

    public String toString() {
        StringBuffer output = new StringBuffer("");
        int numStateVars = DyadEvent.stateVars.size();
        for (TrajectorySet curGroup : groups) {
            output.append(curGroup.definitionString());
        }
        return output.toString();
    }

    public GroupsWindow(GridWindow gW) {
        super("Trajectory Groups");
        this.addWindowListener(new SymWindow());
        if (gW == null) {
            throw new IllegalArgumentException("No GridWindow linked to GroupsWindow");
        }
        gridWindow = gW;
        GridWindow.groupsWindow = this;
        this.contentPane = this.getContentPane();
        ((JPanel)this.contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        groupList.setLayoutOrientation(0);
        groupList.addListSelectionListener(this.listListener);
        groupList.setVisibleRowCount(10);
        this.scrollPane = new JScrollPane(groupList);
        this.contentPane.add(this.scrollPane);
        this.pack();
    }

    public void addGroup(TrajectorySet tS) {
        int groupCount = 0;
        String groupName = "G" + groupCount;
        boolean groupNameFound = false;
        block0: while (!groupNameFound) {
            groupName = "G" + ++groupCount;
            groupNameFound = true;
            for (TrajectorySet curGroup : groups) {
                if (!curGroup.groupName.equals(groupName)) continue;
                groupNameFound = false;
                continue block0;
            }
        }
        groups.add(new TrajectorySet(tS, groupName));
        groupList.setListData(groups);
        GridWare.somethingToSave = true;
    }

    public void addGroup(TrajectorySet tS, String groupName) {
        groups.add(new TrajectorySet(tS, groupName));
        groupList.setListData(groups);
        GridWare.somethingToSave = true;
    }

    public void removeGroup(TrajectorySet tS) {
        groups.remove(tS);
        groupList.setListData(groups);
        GridWare.somethingToSave = true;
    }

    public void deleteGroups() {
        Object[] selectedGroups = groupList.getSelectedValues();
        int i = 0;
        while (i < selectedGroups.length) {
            TrajectorySet selectedGroup = (TrajectorySet)selectedGroups[i];
            this.removeGroup(selectedGroup);
            ++i;
        }
    }

    public void renameGroup() {
        Object[] selectedGroups = groupList.getSelectedValues();
        if (selectedGroups.length != 1) {
            JOptionPane.showMessageDialog(this, "Please select exactly one group to rename.");
        } else {
            TrajectorySet selectedGroup = (TrajectorySet)selectedGroups[0];
            String newName = (String)JOptionPane.showInputDialog(this, "New Group Name:", "Rename Group", -1, null, null, selectedGroup.groupName);
            if (newName != null && newName.length() > 0) {
                selectedGroup.groupName = newName;
                groupList.setListData(groups);
                GridWare.somethingToSave = true;
            }
        }
    }

    public void addToGroup(TrajectorySet tS) {
        Object[] selectedGroups = groupList.getSelectedValues();
        if (selectedGroups.length != 1) {
            JOptionPane.showMessageDialog(this, "Please select exactly one group to add to.");
        } else {
            TrajectorySet selectedGroup = (TrajectorySet)selectedGroups[0];
            selectedGroup.addAll(tS);
            GridWare.somethingToSave = true;
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            GroupsWindow.this.setVisible(false);
        }
    }
}

