/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.Writer;

public class IOHandler {
    private static Reader reader;
    private static Writer writer;
    static String inFileName;
    static String outFileName;

    public static StreamTokenizer openInFile(String name) {
        inFileName = name;
        try {
            System.err.println("Opening file: " + inFileName);
            File inFile = new File(inFileName);
            reader = new BufferedReader(new FileReader(inFile));
            return new StreamTokenizer(reader);
        }
        catch (FileNotFoundException e) {
            inFileName = "";
            return null;
        }
    }

    public static StreamTokenizer openInFile(File file) {
        inFileName = file.getName();
        try {
            System.err.println("Opening file: " + inFileName);
            reader = new BufferedReader(new FileReader(file));
            return new StreamTokenizer(reader);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static StreamTokenizer openInFile() {
        try {
            Frame f = new Frame();
            FileDialog fd = new FileDialog(f, null, 0);
            fd.show();
            String name = String.valueOf(fd.getDirectory()) + fd.getFile();
            System.err.println("Opening file: " + name);
            File inFile = new File(name);
            reader = new BufferedReader(new FileReader(inFile));
            return new StreamTokenizer(reader);
        }
        catch (FileNotFoundException e) {
            inFileName = "";
            return null;
        }
    }

    public static String readData(String name) throws IOException {
        StreamTokenizer in = IOHandler.openInFile(name);
        String input = "";
        if (in == null) {
            System.err.println("Unable to open file");
        } else {
            in.eolIsSignificant(true);
            in.nextToken();
            while (in.ttype != -1) {
                input = String.valueOf(input) + in.sval + "\t";
                in.nextToken();
            }
            System.err.println("File read.");
            IOHandler.closeInFile();
        }
        return input;
    }

    public static void closeInFile() {
        try {
            reader.close();
            inFileName = "";
        }
        catch (IOException e) {
            System.err.println("Error closing " + inFileName);
        }
    }

    public static void readArray(String name) throws IOException {
        StreamTokenizer in = IOHandler.openInFile(name);
        if (in == null) {
            System.err.println("Unable to open file");
        } else {
            int widthCount = 0;
            int lengthCount = 0;
            int maxWidth = 0;
            StringBuffer input = new StringBuffer("");
            in.eolIsSignificant(true);
            in.parseNumbers();
            in.nextToken();
            while (in.ttype != -1) {
                if (in.ttype == 10) {
                    if (widthCount < maxWidth) {
                        System.err.println("Short input - line " + lengthCount);
                    }
                    maxWidth = Math.max(maxWidth, widthCount);
                    widthCount = 0;
                    ++lengthCount;
                    input.append("\n");
                } else {
                    ++widthCount;
                    input.append(String.valueOf(in.sval) + "\t");
                }
                in.nextToken();
            }
            double[][] data = new double[maxWidth][lengthCount];
            StringReader inStr = new StringReader(input.toString());
            in = new StreamTokenizer(new BufferedReader(inStr));
            in.eolIsSignificant(true);
            in.parseNumbers();
            lengthCount = 0;
            widthCount = 0;
            in.nextToken();
            while (in.ttype != -1) {
                if (in.ttype == 10) {
                    widthCount = 0;
                    ++lengthCount;
                } else {
                    data[lengthCount][widthCount] = in.nval;
                    ++widthCount;
                }
                in.nextToken();
            }
            System.err.println("File read.");
            IOHandler.closeInFile();
        }
    }

    public static void openOutFile(String name) {
        try {
            outFileName = name;
            writer = new FileWriter(outFileName);
        }
        catch (IOException e) {
            System.err.println("Error opening " + outFileName);
        }
    }

    public static void openOutFile(File file) {
        try {
            outFileName = file.getName();
            writer = new FileWriter(file);
        }
        catch (IOException e) {
            System.err.println("Error opening " + file.getName());
        }
    }

    public static void closeOutFile() {
        try {
            writer.close();
            outFileName = "";
        }
        catch (IOException e) {
            System.err.println("Error closing " + outFileName);
        }
    }

    public static void printToFile(String output) {
        try {
            writer.write(output);
        }
        catch (IOException e) {
            System.err.println("Error writing to " + outFileName);
        }
    }

    public static void printArrayToFile(int[][] data) {
        IOHandler.printToFile(IOHandler.printArray(data));
    }

    public static void printArrayToFile(String label, int[][] data) {
        IOHandler.printToFile(String.valueOf(label) + IOHandler.printArray(data));
    }

    public static String printArray(int[][] data) {
        StringBuffer output = new StringBuffer("");
        int i = 0;
        while (i < data.length) {
            int j = 0;
            while (j < data[0].length) {
                output.append(String.valueOf(String.valueOf(data[i][j])) + "\t");
                ++j;
            }
            output.append("\r");
            ++i;
        }
        return output.toString();
    }
}

