/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GridWindow;
import GridWare.Variable;

public class IntVariable
extends Variable {
    boolean rangeFixed = false;
    public Integer minimum;
    public Integer maximum;

    public IntVariable(String lbl) {
        super(lbl);
    }

    public IntVariable(String lbl, int min, int max) {
        super(lbl);
        this.setRange(min, max);
        this.fillInValues();
        this.fixValues();
    }

    public IntVariable(String lbl, int min, int max, String[] labels) {
        super(lbl);
        this.setRange(min, max);
        this.fillInValues(labels);
        this.fixValues();
        this.saveLabelsNotValues = true;
    }

    public void setRange(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("Error specifying range of variable \"" + this.label + "\": minimum exceeds maximum.");
        }
        this.minimum = new Integer(min);
        this.maximum = new Integer(max);
        this.rangeFixed = true;
    }

    public void fixValues() {
        this.fixRange();
        this.fillInValues();
        this.valuesFixed = true;
    }

    public void fixRange() {
        if (!this.rangeFixed) {
            this.setRange((Integer)this.valueSet.first(), (Integer)this.valueSet.last());
        }
        this.rangeFixed = true;
    }

    public boolean validate(Comparable value) {
        if (value instanceof Integer) {
            if (this.rangeFixed) {
                if (this.maximum.compareTo((Integer)value) >= 0 && this.minimum.compareTo((Integer)value) <= 0) {
                    return true;
                }
                throw new IllegalArgumentException("Value outside of variable " + this.label + "'s range (" + this.minimum + " to " + this.maximum + "): " + value.toString());
            }
            return true;
        }
        if (value == null) {
            if (Variable.allowMissingValues) {
                return true;
            }
            throw new IllegalArgumentException("Missing values not allowed for variable " + this.label + ".");
        }
        throw new IllegalArgumentException("Value doesn't match variable " + this.label + "'s type (Integer): " + value.toString());
    }

    public Comparable valueOf(String s) {
        Integer integer;
        if (Variable.allowMissingValues && s.equals(GridWindow.missingValue)) {
            return null;
        }
        try {
            integer = Integer.valueOf(s);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("Variable " + this.label + " takes integer values only.  Value read: " + s);
        }
        for (Comparable curValue : this.valueSet) {
            if (!curValue.equals(integer)) continue;
            return curValue;
        }
        return integer;
    }

    public void fillInValues() {
        int i = this.minimum;
        while (i <= this.maximum) {
            this.addValue(new Integer(i));
            ++i;
        }
    }

    public void fillInValues(String[] labels) {
        int j = 0;
        int i = this.minimum;
        while (i <= this.maximum) {
            this.addValue(new Integer(i), labels[j++]);
            ++i;
        }
    }
}

