/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellSet;
import GridWare.GridMeasureChooser;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.MeasureChooser;
import GridWare.RegionMeasureChooser;
import GridWare.TrajectorySet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MeasuresWindow
extends JFrame {
    TrajectorySet trajectories = null;
    Container contentPane;
    MeasureChooser gMChooser1;
    MeasureChooser rMChooser1;
    JLabel gMLabel1;
    JLabel rMLabel1;
    JPanel gridMeasuresPanel = new JPanel();
    JPanel regionMeasuresPanel = new JPanel();
    JPanel transMeasuresTitlePanel = new JPanel();
    JPanel transMeasuresPanel = new JPanel();
    JButton depButton = new JButton("Origin");
    JButton destButton = new JButton("Destination");
    JLabel depInfo = new JLabel("Not Selected");
    JLabel destInfo = new JLabel("Not Selected");
    JLabel transLag = new JLabel("Transitional Bin Size:");
    JLabel transLagValue = new JLabel();
    JLabel transLabel = new JLabel("Transitional Propensity:");
    JLabel transP = new JLabel("N/A");
    JLabel transELabel = new JLabel("Transitional Entropy:");
    JLabel transE = new JLabel("N/A");
    GridBagLayout gridMeasuresLayout = new GridBagLayout();
    GridBagLayout regionMeasuresLayout = new GridBagLayout();
    GridBagLayout transMeasuresTitleLayout = new GridBagLayout();
    GridBagLayout transMeasuresLayout = new GridBagLayout();
    GridBagConstraints titleConstraints = new GridBagConstraints();
    GridBagConstraints chooserConstraints = new GridBagConstraints();
    GridBagConstraints numberConstraints = new GridBagConstraints();
    GridBagConstraints xFillerConstraints = new GridBagConstraints();
    GridBagConstraints yFillerConstraints = new GridBagConstraints();
    Set gridMeasures = new HashSet();
    Set regionMeasures = new HashSet();

    public MeasuresWindow() {
        super("Measures");
        this.contentPane = this.getContentPane();
        ((JPanel)this.contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5));
        Box bigBox = new Box(1);
        bigBox.add(this.gridMeasuresPanel);
        bigBox.add(Box.createRigidArea(new Dimension(0, 10)));
        bigBox.add(this.regionMeasuresPanel);
        bigBox.add(Box.createRigidArea(new Dimension(0, 10)));
        bigBox.add(this.transMeasuresTitlePanel);
        bigBox.add(this.transMeasuresPanel);
        this.gridMeasuresPanel.setLayout(this.gridMeasuresLayout);
        this.regionMeasuresPanel.setLayout(this.regionMeasuresLayout);
        this.transMeasuresTitlePanel.setLayout(this.transMeasuresTitleLayout);
        this.transMeasuresPanel.setLayout(this.transMeasuresLayout);
        this.contentPane.add((Component)bigBox, "North");
        this.titleConstraints.gridx = 0;
        this.titleConstraints.gridy = -1;
        this.titleConstraints.weightx = 0.0;
        this.titleConstraints.weighty = 0.0;
        this.titleConstraints.gridwidth = 2;
        this.titleConstraints.gridheight = 1;
        this.titleConstraints.fill = 0;
        this.titleConstraints.anchor = 10;
        this.chooserConstraints.gridx = 0;
        this.chooserConstraints.gridy = -1;
        this.chooserConstraints.weightx = 0.0;
        this.chooserConstraints.weighty = 0.0;
        this.chooserConstraints.gridwidth = 1;
        this.chooserConstraints.gridheight = 1;
        this.chooserConstraints.fill = 2;
        this.chooserConstraints.anchor = 13;
        this.numberConstraints.gridx = 1;
        this.numberConstraints.gridy = -1;
        this.numberConstraints.weightx = 0.0;
        this.numberConstraints.weighty = 0.0;
        this.numberConstraints.gridwidth = 1;
        this.numberConstraints.gridheight = 1;
        this.numberConstraints.fill = 0;
        this.numberConstraints.anchor = 13;
        this.xFillerConstraints.gridx = -1;
        this.xFillerConstraints.gridy = 0;
        this.xFillerConstraints.weightx = 1.0;
        this.xFillerConstraints.weighty = 0.0;
        this.yFillerConstraints.gridx = 0;
        this.yFillerConstraints.gridy = -1;
        this.yFillerConstraints.weightx = 0.0;
        this.yFillerConstraints.weighty = 1.0;
        JLabel gridLabel = new JLabel("<html><b><u>Grid Measures</u></b></html>");
        this.gridMeasuresLayout.setConstraints(gridLabel, this.titleConstraints);
        this.gridMeasuresPanel.add(gridLabel);
        Component xFiller1 = Box.createRigidArea(new Dimension(0, 0));
        this.gridMeasuresLayout.setConstraints(xFiller1, this.xFillerConstraints);
        this.gridMeasuresPanel.add(xFiller1);
        Component chooserSpacer1 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 180 : 120, 5));
        this.gridMeasuresLayout.setConstraints(chooserSpacer1, this.chooserConstraints);
        this.gridMeasuresPanel.add(chooserSpacer1);
        Component numberSpacer1 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 80 : 60, 5));
        this.gridMeasuresLayout.setConstraints(numberSpacer1, this.numberConstraints);
        this.gridMeasuresPanel.add(numberSpacer1);
        this.addGridMeasure("Selected Trajectories");
        this.addGridMeasure("Mean Missing Duration");
        this.addGridMeasure("Mean Missing Events");
        this.addGridMeasure("Mean Duration");
        this.addGridMeasure("Mean # of Events");
        this.addGridMeasure("Mean # of Visits");
        this.addGridMeasure("Mean Cell Range");
        this.addGridMeasure("Overall Cell Range");
        JLabel regionLabel = new JLabel("<html><b><u>Region Measures</u></b></html>");
        Component xFiller2 = Box.createRigidArea(new Dimension(0, 0));
        this.regionMeasuresLayout.setConstraints(regionLabel, this.titleConstraints);
        this.regionMeasuresPanel.add(regionLabel);
        this.regionMeasuresLayout.setConstraints(xFiller2, this.xFillerConstraints);
        this.regionMeasuresPanel.add(xFiller2);
        Component chooserSpacer2 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 180 : 120, 5));
        this.regionMeasuresLayout.setConstraints(chooserSpacer2, this.chooserConstraints);
        this.regionMeasuresPanel.add(chooserSpacer2);
        Component numberSpacer2 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 80 : 60, 5));
        this.regionMeasuresLayout.setConstraints(numberSpacer2, this.numberConstraints);
        this.regionMeasuresPanel.add(numberSpacer2);
        this.addRegionMeasure("Selected Cells");
        this.addRegionMeasure("Mean Duration");
        this.addRegionMeasure("Mean # of Events");
        this.addRegionMeasure("Mean # of Visits");
        this.addRegionMeasure("Mean Cell Range");
        this.addRegionMeasure("Overall Cell Range");
        JLabel transLabel = new JLabel("<html><b><u>Transitional Measures</u></b></html>");
        Component xFiller3 = Box.createRigidArea(new Dimension(0, 0));
        this.transMeasuresLayout.setConstraints(transLabel, this.titleConstraints);
        this.transMeasuresPanel.add(transLabel);
        this.transMeasuresLayout.setConstraints(xFiller3, this.xFillerConstraints);
        this.transMeasuresPanel.add(xFiller3);
        this.enableTrans(false);
        this.addTransMeasuresToPane(this.transMeasuresPanel);
    }

    public synchronized void addTransMeasuresToPane(JPanel pane) {
        ActionListener transActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CellSet selectedCells = GridWindow.selectedCells;
                if (MeasuresWindow.this.trajectories != null) {
                    if (e.getSource() == MeasuresWindow.this.depButton) {
                        String cellList = "";
                        String name = "";
                        GridWindow.depCells = new CellSet(selectedCells);
                        Iterator it = selectedCells.iterator();
                        if (GridWindow.selectedCells.regionName.equals("")) {
                            while (it.hasNext()) {
                                cellList = String.valueOf(cellList) + " {" + it.next().toString() + "}";
                            }
                            GridWindow.depCells.regionName = name = cellList;
                        } else {
                            name = GridWindow.selectedCells.regionName;
                        }
                        if (name.length() > 20) {
                            cellList = String.valueOf(cellList.substring(0, 15)) + "...";
                            MeasuresWindow.this.depInfo.setText(cellList);
                        } else {
                            MeasuresWindow.this.depInfo.setText(name);
                        }
                    } else if (e.getSource() == MeasuresWindow.this.destButton) {
                        String cellList = "";
                        String name = "";
                        GridWindow.destCells = new CellSet(selectedCells);
                        Iterator it = selectedCells.iterator();
                        if (GridWindow.selectedCells.regionName.equals("")) {
                            while (it.hasNext()) {
                                cellList = String.valueOf(cellList) + " {" + it.next().toString() + "}";
                            }
                            GridWindow.destCells.regionName = name = cellList;
                        } else {
                            name = GridWindow.selectedCells.regionName;
                        }
                        if (name.length() > 20) {
                            cellList = String.valueOf(cellList.substring(0, 15)) + "...";
                            MeasuresWindow.this.destInfo.setText(cellList);
                        } else {
                            MeasuresWindow.this.destInfo.setText(name);
                        }
                    }
                }
                GridWindow.takeMeasures();
            }
        };
        ActionListener transLagListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GridWindow.transBin = new Double(e.getActionCommand());
                if (GridWindow.transBin > (double)(GridWindow.maxTime - GridWindow.minTime)) {
                    GridWindow.transBin = GridWindow.maxTime - GridWindow.minTime;
                }
                GridWindow.takeMeasures();
            }
        };
        GridBagConstraints transMeasureConstraints = new GridBagConstraints();
        Component Spacer1 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 180 : 120, 5));
        Component Spacer2 = Box.createRigidArea(new Dimension(GridWare.macPlatform ? 180 : 120, 5));
        pane.add(Spacer1, this.chooserConstraints);
        pane.add(Spacer2, this.numberConstraints);
        this.depButton.addActionListener(transActionListener);
        pane.add((Component)this.depButton, this.chooserConstraints);
        pane.add((Component)this.depInfo, this.numberConstraints);
        this.destButton.addActionListener(transActionListener);
        pane.add((Component)this.destButton, this.chooserConstraints);
        pane.add((Component)this.destInfo, this.numberConstraints);
        pane.add(Spacer1, this.chooserConstraints);
        pane.add(Spacer2, this.numberConstraints);
        pane.add((Component)this.transLag, this.chooserConstraints);
        pane.add((Component)this.transLagValue, this.numberConstraints);
        pane.add((Component)this.transLabel, this.chooserConstraints);
        pane.add((Component)this.transP, this.numberConstraints);
        pane.add((Component)this.transELabel, this.chooserConstraints);
        pane.add((Component)this.transE, this.numberConstraints);
    }

    public void updateValues(TrajectorySet trajs) {
        this.trajectories = trajs;
        if (this.trajectories != null) {
            Iterator i = this.gridMeasures.iterator();
            while (i.hasNext()) {
                ((MeasureChooser)i.next()).updateLabel();
            }
            i = this.regionMeasures.iterator();
            while (i.hasNext()) {
                ((MeasureChooser)i.next()).updateLabel();
            }
        }
    }

    public void enableTrans(boolean bool) {
        this.depButton.setEnabled(bool);
        this.destButton.setEnabled(bool);
    }

    public void addGridMeasure() {
        String[] gridMeasureArray = GridMeasureChooser.measures;
        String curMeasure = null;
        boolean measureAlreadyPresent = true;
        int m = 0;
        while (m < gridMeasureArray.length && measureAlreadyPresent) {
            curMeasure = gridMeasureArray[m];
            measureAlreadyPresent = false;
            for (GridMeasureChooser curMeasureChooser : this.gridMeasures) {
                if (!curMeasure.equals(curMeasureChooser.getSelectedItem())) continue;
                measureAlreadyPresent = true;
                break;
            }
            ++m;
        }
        this.addGridMeasure(curMeasure);
    }

    public void addGridMeasure(String measureName) {
        boolean wasVisible = this.isVisible();
        this.setVisible(false);
        JLabel gMLabel = new JLabel("");
        GridMeasureChooser gMChooser = new GridMeasureChooser(this, gMLabel);
        gMChooser.setSelectedItem(measureName);
        this.gridMeasures.add(gMChooser);
        this.gridMeasuresLayout.setConstraints(gMChooser, this.chooserConstraints);
        this.gridMeasuresPanel.add(gMChooser);
        this.gridMeasuresLayout.setConstraints(gMLabel, this.numberConstraints);
        this.gridMeasuresPanel.add(gMLabel);
        this.validate();
        if (wasVisible) {
            this.pack();
            this.setVisible(true);
        }
        this.setEnabled(true);
    }

    public void addRegionMeasure() {
        String[] regionMeasureArray = RegionMeasureChooser.measures;
        String curMeasure = null;
        boolean measureAlreadyPresent = true;
        int m = 0;
        while (m < regionMeasureArray.length && measureAlreadyPresent) {
            curMeasure = regionMeasureArray[m];
            measureAlreadyPresent = false;
            for (RegionMeasureChooser curMeasureChooser : this.regionMeasures) {
                if (!curMeasure.equals(curMeasureChooser.getSelectedItem())) continue;
                measureAlreadyPresent = true;
                break;
            }
            ++m;
        }
        this.addRegionMeasure(curMeasure);
        this.validate();
        this.setEnabled(true);
    }

    public void addRegionMeasure(String measureName) {
        boolean wasVisible = this.isVisible();
        this.setVisible(false);
        JLabel rMLabel = new JLabel("");
        RegionMeasureChooser rMChooser = new RegionMeasureChooser(this, rMLabel);
        rMChooser.setSelectedItem(measureName);
        this.regionMeasures.add(rMChooser);
        this.regionMeasuresLayout.setConstraints(rMChooser, this.chooserConstraints);
        this.regionMeasuresPanel.add(rMChooser);
        this.regionMeasuresLayout.setConstraints(rMLabel, this.numberConstraints);
        this.regionMeasuresPanel.add(rMLabel);
        this.validate();
        if (wasVisible) {
            this.pack();
            this.setVisible(true);
        }
        this.setEnabled(true);
    }
}

