/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.CellSet;
import GridWare.DyadEvent;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.Variable;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class RegionsWindow
extends JFrame {
    GridWindow gridWindow;
    Container contentPane;
    static StringBuffer regionDefinitions = new StringBuffer("");
    static Vector regions;
    static Vector[][] regionVectors;
    static JList regionList;
    JScrollPane scrollPane;
    ListSelectionListener listListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent evt) {
            JList source = (JList)evt.getSource();
            RegionsWindow.this.gridWindow.selectRegion((CellSet)source.getSelectedValue());
        }
    };

    public static List getSelectedRegions() {
        return Arrays.asList(regionList.getSelectedValues());
    }

    public static void init() {
        regionList = new JList();
        int numStateVars = DyadEvent.stateVars.size();
        regionVectors = new Vector[numStateVars][numStateVars];
        int i = 0;
        while (i < numStateVars) {
            int j = 0;
            while (j < numStateVars) {
                RegionsWindow.regionVectors[i][j] = new Vector();
                ++j;
            }
            ++i;
        }
        BufferedReader br = new BufferedReader(new StringReader(regionDefinitions.toString()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                StringTokenizer tabTokenizer = new StringTokenizer(line, "\t");
                tabTokenizer.nextToken();
                String xName = tabTokenizer.nextToken();
                Variable xVar = (Variable)DyadEvent.stateVariables.get(xName);
                String yName = tabTokenizer.nextToken();
                Variable yVar = (Variable)DyadEvent.stateVariables.get(yName);
                String regionName = tabTokenizer.nextToken();
                CellSet curRegion = new CellSet(regionName, xVar, yVar);
                String xyValues = tabTokenizer.nextToken();
                StringTokenizer commaTokenizer = new StringTokenizer(xyValues, ",");
                String xValue = commaTokenizer.nextToken();
                String yValue = commaTokenizer.nextToken();
                curRegion.add(GridWindow.allCells[DyadEvent.stateVars.indexOf(xVar)][DyadEvent.stateVars.indexOf(yVar)][xVar.getIndex(xVar.valueOf(xValue))][yVar.getIndex(yVar.valueOf(yValue))]);
                while (tabTokenizer.hasMoreTokens()) {
                    xyValues = tabTokenizer.nextToken();
                    if (xyValues.indexOf(",") <= 0) continue;
                    commaTokenizer = new StringTokenizer(xyValues, ",");
                    xValue = commaTokenizer.nextToken();
                    yValue = commaTokenizer.nextToken();
                    curRegion.add(GridWindow.allCells[DyadEvent.stateVars.indexOf(xVar)][DyadEvent.stateVars.indexOf(yVar)][xVar.getIndex(xVar.valueOf(xValue))][yVar.getIndex(yVar.valueOf(yValue))]);
                }
                regionVectors[DyadEvent.stateVars.indexOf(xVar)][DyadEvent.stateVars.indexOf(yVar)].add(curRegion);
            }
            br.close();
        }
        catch (IOException ex) {
            System.err.println("IOException while parsing regionDefinitions String.  File was already read, however, so I don't see how this could happen.");
        }
    }

    public static void setRegionList(Variable v1, Variable v2) {
        regions = regionVectors[DyadEvent.stateVars.indexOf(v1)][DyadEvent.stateVars.indexOf(v2)];
        regionList.setListData(regions);
    }

    public String toString() {
        StringBuffer output = new StringBuffer("");
        int numStateVars = DyadEvent.stateVars.size();
        int i = 0;
        while (i < numStateVars) {
            int j = 0;
            while (j < numStateVars) {
                Vector curRegionVector = regionVectors[i][j];
                for (CellSet curRegion : curRegionVector) {
                    output.append(curRegion.definitionString());
                }
                ++j;
            }
            ++i;
        }
        return output.toString();
    }

    public RegionsWindow(GridWindow gW) {
        super("Regions");
        this.addWindowListener(new SymWindow());
        if (gW == null) {
            throw new IllegalArgumentException("No GridWindow linked to RegionsWindow");
        }
        this.gridWindow = gW;
        GridWindow.regionsWindow = this;
        this.contentPane = this.getContentPane();
        ((JPanel)this.contentPane).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        regionList.setLayoutOrientation(0);
        regionList.addListSelectionListener(this.listListener);
        regionList.setVisibleRowCount(10);
        this.scrollPane = new JScrollPane(regionList);
        this.contentPane.add(this.scrollPane);
        this.pack();
    }

    public void addRegion(CellSet c) {
        int regionCount = 0;
        String regionName = "R" + regionCount;
        boolean regionNameFound = false;
        block0: while (!regionNameFound) {
            regionName = "R" + ++regionCount;
            regionNameFound = true;
            for (CellSet curRegion : regions) {
                if (!curRegion.regionName.equals(regionName)) continue;
                regionNameFound = false;
                continue block0;
            }
        }
        regions.add(new CellSet(c, regionName, GridWindow.xVariable, GridWindow.yVariable));
        regionList.setListData(regions);
        GridWare.somethingToSave = true;
    }

    public void addRegion(CellSet c, String regionName) {
        regions.add(new CellSet(c, regionName, GridWindow.xVariable, GridWindow.yVariable));
        regionList.setListData(regions);
        GridWare.somethingToSave = true;
    }

    public void removeRegion(CellSet c) {
        regions.remove(c);
        regionList.setListData(regions);
        GridWare.somethingToSave = true;
    }

    public void deleteRegions() {
        Object[] selectedRegions = regionList.getSelectedValues();
        int i = 0;
        while (i < selectedRegions.length) {
            CellSet selectedRegion = (CellSet)selectedRegions[i];
            this.removeRegion(selectedRegion);
            ++i;
        }
    }

    public void renameRegion() {
        Object[] selectedRegions = regionList.getSelectedValues();
        if (selectedRegions.length != 1) {
            JOptionPane.showMessageDialog(this, "Please select exactly one region to rename.");
        } else {
            CellSet selectedRegion = (CellSet)selectedRegions[0];
            String newName = (String)JOptionPane.showInputDialog(this, "New Region Name:", "Rename Region", -1, null, null, selectedRegion.regionName);
            if (newName != null && newName.length() > 0) {
                selectedRegion.regionName = newName;
                regionList.setListData(regions);
                GridWare.somethingToSave = true;
            }
        }
    }

    public void clearSelection() {
        regionList.clearSelection();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent event) {
            RegionsWindow.this.setVisible(false);
        }
    }
}

