/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.GWSlider;
import GridWare.GridWindow;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TimeSlider
extends GWSlider {
    GridWindow gridWindow;
    JPanel panel = new JPanel();
    JLabel label;
    JTextField minField = new JTextField(4);
    JTextField maxField = new JTextField(4);
    GridBagLayout panelLayout = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    static ChangeListener timeSliderListener = new ChangeListener(){

        public void stateChanged(ChangeEvent evt) {
            TimeSlider source = (TimeSlider)evt.getSource();
            int value = source.getValue();
            int extent = source.getExtent();
            if (extent > 0) {
                source.minField.setText(Integer.toString(value));
                source.maxField.setText(Integer.toString(value + extent));
                source.gridWindow.adjustTimeBounds(value, value + extent);
            } else {
                source.maxField.setText(Integer.toString(value));
                source.minField.setText(Integer.toString(value + extent));
                source.gridWindow.adjustTimeBounds(value + extent, value);
            }
            source.repaint();
        }
    };
    FocusListener fieldFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent evt) {
            JTextField source = (JTextField)evt.getSource();
            if (source == TimeSlider.this.minField) {
                TimeSlider.this.ensureExtentPositive();
            } else if (source == TimeSlider.this.maxField) {
                TimeSlider.this.ensureExtentNegative();
            }
        }
    };
    ActionListener fieldListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            JTextField source = (JTextField)evt.getSource();
            int min = Integer.parseInt(TimeSlider.this.minField.getText());
            int max = Integer.parseInt(TimeSlider.this.maxField.getText());
            if (source == TimeSlider.this.minField) {
                if (min > max) {
                    max = min;
                    TimeSlider.this.maxField.setText(TimeSlider.this.minField.getText());
                    TimeSlider.this.setValueAndExtent(min, 0);
                } else if (TimeSlider.this.getExtent() >= 0) {
                    TimeSlider.this.setValue(min, false);
                }
            } else if (source == TimeSlider.this.maxField) {
                if (min > max) {
                    min = max;
                    TimeSlider.this.minField.setText(TimeSlider.this.maxField.getText());
                    TimeSlider.this.setValueAndExtent(max, 0);
                } else if (TimeSlider.this.getExtent() <= 0) {
                    TimeSlider.this.setValue(max, false);
                }
            }
            if (TimeSlider.this.isRequestFocusEnabled()) {
                TimeSlider.this.requestFocus();
            }
        }
    };

    public TimeSlider(int min, int max, int value, int ext, GridWindow gW) {
        super(min, max, value);
        this.gridWindow = gW;
        this.panel.setLayout(this.panelLayout);
        this.minField.setHorizontalAlignment(4);
        this.gbc.gridx = 0;
        this.gbc.gridy = 0;
        this.gbc.weightx = 1.0;
        this.gbc.weighty = 0.0;
        this.gbc.fill = 0;
        this.gbc.anchor = 14;
        this.panelLayout.setConstraints(this.minField, this.gbc);
        this.panel.add(this.minField);
        this.label = new JLabel(" \u2264 time \u2264 ");
        this.gbc.gridx = 1;
        this.gbc.weightx = 0.0;
        this.gbc.anchor = 15;
        this.panelLayout.setConstraints(this.label, this.gbc);
        this.panel.add(this.label);
        this.gbc.gridx = 2;
        this.gbc.weightx = 1.0;
        this.gbc.anchor = 16;
        this.panelLayout.setConstraints(this.maxField, this.gbc);
        this.panel.add(this.maxField);
        this.gbc.gridx = 0;
        this.gbc.gridy = 1;
        this.gbc.weightx = 1.0;
        this.gbc.gridwidth = 3;
        this.gbc.gridheight = 2;
        this.gbc.fill = 2;
        this.gbc.anchor = 17;
        this.panelLayout.setConstraints(this, this.gbc);
        this.panel.add(this);
        this.minField.addActionListener(this.fieldListener);
        this.maxField.addActionListener(this.fieldListener);
        this.minField.addFocusListener(this.fieldFocusListener);
        this.maxField.addFocusListener(this.fieldFocusListener);
        this.setMinorTickSpacing((int)Math.ceil((double)(max - min) / 25.0));
        this.setMajorTickSpacing(5 * this.getMinorTickSpacing());
        this.setSnapToTicks(false);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.addChangeListener(timeSliderListener);
        this.setExtent(ext);
        this.fireStateChanged();
    }

    void reset() {
        this.setValue(this.getMinimum());
        this.setExtent(this.getMaximum() - this.getMinimum());
        this.fireStateChanged();
    }
}

