/*
 * Decompiled with CFR 0.152.
 */
package GridWare;

import GridWare.EditableLabel;
import GridWare.GridWare;
import GridWare.GridWindow;
import GridWare.LabelField;
import GridWare.Variable;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class XAxis
extends JPanel
implements MouseListener,
ActionListener {
    Variable variable;
    String axisString;
    Vector variableValues;
    int numValues;
    EditableLabel[] valueLabels;
    JLabel axisLabel;
    JPanel labelPanel;
    Font axisFont = new Font("sansserif", 1, 20);
    Font labelFont = new Font("sansserif", 0, 18);
    GridBagConstraints constraints = new GridBagConstraints();
    GridBagLayout layout = new GridBagLayout();

    public XAxis(Variable var) {
        this.variable = var;
        this.axisString = String.valueOf(this.variable.label.substring(0, 1).toUpperCase()) + this.variable.label.substring(1);
        this.variableValues = this.variable.getValues();
        this.numValues = this.variableValues.size();
        this.setLayout(this.layout);
        this.constraints.gridx = 0;
        this.constraints.gridy = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 15;
        this.constraints.gridwidth = this.numValues;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.axisLabel = new JLabel();
        this.axisLabel.setFont(this.axisFont);
        this.axisLabel.setText(this.axisString);
        this.axisLabel.setVerticalAlignment(3);
        this.axisLabel.setHorizontalAlignment(0);
        this.axisLabel.setAlignmentX(0.5f);
        this.layout.setConstraints(this.axisLabel, this.constraints);
        this.add(this.axisLabel);
        this.labelPanel = new JPanel();
        this.labelPanel.setLayout(new GridLayout(1, this.numValues));
        this.valueLabels = new EditableLabel[this.numValues];
        Iterator i = this.variableValues.iterator();
        int l = 0;
        while (l < this.numValues) {
            this.valueLabels[l] = new EditableLabel(this.variable, (Comparable)i.next());
            this.valueLabels[l].setFont(this.labelFont);
            this.valueLabels[l].addMouseListener(this);
            this.valueLabels[l].addMouseListener(GridWindow.cellListener);
            this.labelPanel.add(this.valueLabels[l]);
            this.valueLabels[l].field.addActionListener(this);
            ++l;
        }
        this.constraints.gridx = 0;
        this.constraints.gridy = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 15;
        this.constraints.gridwidth = this.numValues;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.layout.setConstraints(this.labelPanel, this.constraints);
        this.add(this.labelPanel);
        this.adjustValueLabelSize();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.adjustValueLabelSize();
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.adjustValueLabelSize();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.adjustValueLabelSize();
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.adjustValueLabelSize();
    }

    public void adjustValueLabelSize() {
        Dimension d = this.getSize();
        int valueLabelWidth = (int)Math.floor(d.getWidth() / (double)this.numValues) - 6;
        int valueLabelHeight = (int)Math.floor(d.getHeight() / 2.0);
        d.setSize(valueLabelWidth, valueLabelHeight);
        Font font = this.labelFont;
        int l = 0;
        while (l < this.numValues) {
            this.valueLabels[l].setPreferredSize(d);
            this.valueLabels[l].setSize(d);
            this.valueLabels[l].field.setPreferredSize(d);
            this.valueLabels[l].field.setSize(d);
            String curLabel = this.valueLabels[l].getText();
            this.valueLabels[l].setFont(font);
            FontMetrics fm = this.valueLabels[l].getFontMetrics(font);
            int width = fm.stringWidth(curLabel);
            int maxWidth = (int)this.valueLabels[l].getSize().getWidth();
            int fontSize = font.getSize();
            boolean shrunkFont = false;
            while (width > maxWidth && fontSize >= 12) {
                font = font.deriveFont((float)(--fontSize));
                this.valueLabels[l].setFont(font);
                fm = this.valueLabels[l].getFontMetrics(font);
                width = fm.stringWidth(curLabel);
                shrunkFont = true;
            }
            if (shrunkFont) {
                int m = 0;
                while (m < this.numValues) {
                    this.valueLabels[m].setFont(font);
                    this.valueLabels[m].invalidate();
                    ++m;
                }
            }
            ++l;
        }
        this.validate();
    }

    public void actionPerformed(ActionEvent evt) {
        EditableLabel label;
        boolean someLabelsChanged = false;
        boolean allLabelsDifferent = true;
        int l = this.valueLabels.length - 1;
        while (l >= 0) {
            label = this.valueLabels[l];
            String fieldText = label.field.getText();
            if (!fieldText.equals(label.getText())) {
                someLabelsChanged = true;
            }
            int m = l - 1;
            while (m >= 0) {
                if (fieldText.equals(this.valueLabels[m].field.getText())) {
                    allLabelsDifferent = false;
                }
                --m;
            }
            --l;
        }
        this.setVisible(false);
        l = this.valueLabels.length - 1;
        while (l >= 0) {
            label = this.valueLabels[l];
            LabelField field = label.field;
            if (someLabelsChanged && allLabelsDifferent) {
                label.setText(field.getText());
                this.variable.setLabel(label.value, field.getText());
            } else {
                field.setText(label.getText());
            }
            this.labelPanel.remove(field);
            --l;
        }
        if (someLabelsChanged && allLabelsDifferent) {
            if (this.variable == GridWindow.yVariable) {
                GridWindow.updateYAxisLabels();
            }
            GridWare.setSomethingToSave(true);
            this.variable.saveLabelsNotValues = true;
        }
        l = 0;
        while (l < this.valueLabels.length) {
            this.labelPanel.add(this.valueLabels[l]);
            ++l;
        }
        this.adjustValueLabelSize();
        this.validate();
        this.setVisible(true);
    }

    public void mouseClicked(MouseEvent e) {
        EditableLabel label = (EditableLabel)e.getSource();
        if ((e.getModifiers() & 8) > 0) {
            this.setVisible(false);
            int l = this.valueLabels.length - 1;
            while (l >= 0) {
                this.labelPanel.remove(this.valueLabels[l]);
                --l;
            }
            l = 0;
            while (l < this.valueLabels.length) {
                this.labelPanel.add(this.valueLabels[l].field);
                ++l;
            }
            this.validate();
            this.setVisible(true);
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }
}

